<?php
namespace SabaiApps\Directories\Component\Faker\Generator;

use SabaiApps\Directories\Component\Field;

class WPPicsumPhotoGenerator extends AbstractGenerator
{
    protected function _fakerGeneratorInfo()
    {
        return array(
            'label' => __('Picsum Photo Generator', 'directories-faker'),
            'description' => __('Download random photos from https://picsum.photos/.', 'directories-faker'),
            'field_types' => array('wp_image'),
            'default_settings' => array(
                'probability' => 100,
                'max' => 5,
            ),
        );
    }

    public function fakerGeneratorSettingsForm(Field\IField $field, array $settings, array $parents = [])
    {
        return [
            'probability' => $this->_getProbabilitySettingForm($settings['probability']),
            'max' => $this->_getMaxNumItemsSettingForm($field, $settings['max']),
        ];
    }

    public function fakerGeneratorGenerate(Field\IField $field, array $settings, array &$values, array &$formStorage)
    {
        if (mt_rand(0, 100) > $settings['probability']) return;

        if (!$picsum_photos = $this->_application->getPlatform()->getCache('faker_wp_picsum_photos')) {
            try {
                $result = $this->_application->getPlatform()->remoteGet('https://picsum.photos/list');
                if (!$picsum_photos = json_decode($result, true)) {
                    throw new Exception\RuntimeException('Failed decoding photo list JSON return from picsum.photos.');
                }
            } catch (\Exception $e) {
                $this->_application->logError($e);
                return false;
            }
            $this->_application->getPlatform()->setCache($picsum_photos, 'faker_wp_picsum_photos', 86400 * 7);
        }

        if (!isset($formStorage['wp_picsum_photo_ids'])) {
            $formStorage['wp_picsum_photos'] = [];
        }

        $ret = [];
        $num = $this->_getMaxNumItems($field, $settings['max']);
        $max_index = count($picsum_photos) - 1;
        $i = 0;
        do {
            ++$i;
            $index = mt_rand(0, $max_index);
            $photo = $picsum_photos[$index];
            if (isset($ret[$photo['id']])) continue;

            if (!isset($formStorage['wp_picsum_photos'][$photo['id']])) {
                $url = 'https://picsum.photos/1280/720?image=' . $photo['id'];
                try {
                    $file_path = $this->_application->getPlatform()->downloadUrl($url);
                } catch (\Exception $e) {
                    $this->_application->logError($e);
                    continue;
                }

                // Save
                $attachment_id = media_handle_sideload(
                    [
                        'name' => $title = 'picsum-photo-' . $photo['id'] . '.jpeg',
                        'tmp_name' => $file_path,
                    ],
                    0, // post ID
                    null, // desc
                    [
                        'post_name' => 'drts-' . sanitize_title($title),
                        'post_title' => sprintf('Photo by %s (%s)', $photo['author'], $photo['author_url']),
                    ]
                );
                if (is_wp_error($attachment_id)) {
                    @unlink($file_path);
                    $this->_application->logError($attachment_id->get_error_message());
                    continue;
                }

                $formStorage['wp_picsum_photos'][$photo['id']] = $attachment_id;
            }

            $ret[$photo['id']] = $formStorage['wp_picsum_photos'][$photo['id']];

        } while (count($ret) < $num && $i < $num + 5);

        return array_values($ret);
    }
}