<?php
namespace SabaiApps\Directories\Component\Field\Type;

use SabaiApps\Directories\Component\Entity;

class StringType extends AbstractStringType
{
    protected function _fieldTypeInfo()
    {
        return [
            'label' => __('Single Line Text', 'directories'),
            'default_widget' => 'textfield',
            'default_renderer' => 'string',
            'default_settings' => [
                'min_length' => null,
                'max_length' => null,
                'char_validation' => 'none',
                'regex' => null,
                'prefix' => null,
                'suffix' => null,
            ],
            'icon' => 'fas fa-minus',
        ];
    }

    public function fieldTypeSettingsForm($fieldType, Entity\Model\Bundle $bundle, array $settings, array $parents = [])
    {
        return parent::fieldTypeSettingsForm($fieldType, $bundle, $settings, $parents) + [
            'prefix' => [
                '#type' => 'textfield',
                '#title' => __('Field prefix', 'directories'),
                '#description' => __('Example: $, #, -', 'directories'),
                '#size' => 20,
                '#default_value' => $settings['prefix'],
                '#no_trim' => true,
            ],
            'suffix' => [
                '#type' => 'textfield',
                '#title' => __('Field suffix', 'directories'),
                '#description' => __('Example: km, %, g', 'directories'),
                '#size' => 20,
                '#default_value' => $settings['suffix'],
                '#no_trim' => true,
            ],
        ];
    }
}
