<?php
/* This file has been auto-generated. Do not edit this file directly. */
namespace SabaiApps\Directories\Component\Directory\Model\Base;

use SabaiApps\Framework\Model\Model;

abstract class DirectoryGateway extends \SabaiApps\Framework\Model\AbstractGateway
{
    public function getName()
    {
        return 'directory_directory';
    }

    public function getFields()
    {
        return ['directory_name' => Model::KEY_TYPE_VARCHAR, 'directory_type' => Model::KEY_TYPE_VARCHAR, 'directory_data' => Model::KEY_TYPE_TEXT, 'directory_created' => Model::KEY_TYPE_INT, 'directory_updated' => Model::KEY_TYPE_INT];
    }

    protected function _getIdFieldName()
    {
        return 'directory_name';
    }

    protected function _getSelectByIdQuery($id, $fields)
    {
        return sprintf(
            'SELECT %s FROM %sdirectory_directory WHERE directory_name = %s',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $this->_db->escapeString($id)
        );
    }

    protected function _getSelectByIdsQuery($ids, $fields)
    {
        return sprintf(
            'SELECT %s FROM %sdirectory_directory WHERE directory_name IN (%s)',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            implode(', ', array_map(array($this->_db, 'escapeString'), $ids))
        );
    }

    protected function _getSelectByCriteriaQuery($criteriaStr, $fields)
    {
        return sprintf(
            'SELECT %1$s FROM %2$sdirectory_directory directory_directory WHERE %3$s',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $criteriaStr
        );
    }

    protected function _getInsertQuery(&$values)
    {
        $values['directory_created'] = time();
        $values['directory_updated'] = 0;
        return sprintf('INSERT INTO %sdirectory_directory(directory_name, directory_type, directory_data, directory_created, directory_updated) VALUES(%s, %s, %s, %d, %d)', $this->_db->getResourcePrefix(), $this->_db->escapeString($values['directory_name']), $this->_db->escapeString($values['directory_type']), $this->_db->escapeString(serialize($values['directory_data'])), $values['directory_created'], $values['directory_updated']);
    }

    protected function _getUpdateQuery($id, $values)
    {
        $last_update = $values['directory_updated'];
        $values['directory_updated'] = time();
        return sprintf('UPDATE %sdirectory_directory SET directory_type = %s, directory_data = %s, directory_updated = %d WHERE directory_name = %s AND directory_updated = %d', $this->_db->getResourcePrefix(), $this->_db->escapeString($values['directory_type']), $this->_db->escapeString(serialize($values['directory_data'])), $values['directory_updated'], $this->_db->escapeString($id), $last_update);
    }

    protected function _getDeleteQuery($id)
    {
        return sprintf('DELETE FROM %1$sdirectory_directory WHERE directory_name = %2$s', $this->_db->getResourcePrefix(), $this->_db->escapeString($id));
    }

    protected function _getUpdateByCriteriaQuery($criteriaStr, $sets)
    {
        $sets['directory_updated'] = 'directory_updated=' . time();
        return sprintf('UPDATE %sdirectory_directory directory_directory SET %s WHERE %s', $this->_db->getResourcePrefix(), implode(', ', $sets), $criteriaStr);
    }

    protected function _getDeleteByCriteriaQuery($criteriaStr)
    {
        return sprintf('DELETE directory_directory FROM %1$sdirectory_directory directory_directory WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getCountByCriteriaQuery($criteriaStr)
    {
        return sprintf('SELECT COUNT(*) FROM %1$sdirectory_directory directory_directory WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }
}