<?php
namespace SabaiApps\Directories\Component\Entity\Type;

use SabaiApps\Directories\Component\Field;
use SabaiApps\Directories\Exception;

class FieldQuery extends Field\Query
{
    protected $_bundleName;

    public function taxonomyTermIdIn($taxonomyBundleType, array $ids, $ignoreAuto = false, $alias = null)
    {
        $this->fieldIsIn($taxonomyBundleType, $ids, 'value', $alias);
        // whether or not to ignore terms automatically added by the system, such as parent terms that were not selected by the user explicitly 
        if ($ignoreAuto) {
            $this->fieldIsNot($taxonomyBundleType, true, 'auto', $alias);
        }
    }
    
    public function taxonomyTermIdIs($taxonomyBundleType, $id, $ignoreAuto = true, $alias = null)
    {
        $this->fieldIs($taxonomyBundleType, $id, 'value', $alias);
        // whether or not to ignore terms automatically added by the system, such as parent terms that were not selected by the user explicitly 
        if ($ignoreAuto) {
            $this->fieldIsNot($taxonomyBundleType, true, 'auto', $alias);
        }
    }
    
    public function taxonomyTermIdNotIn($taxonomyBundleType, array $ids, $ignoreAuto = true, $alias = null)
    {
        $this->fieldIsNotIn($taxonomyBundleType, $ids, 'value', $alias);
        // whether or not to ignore terms automatically added by the system, such as parent terms that were not selected by the user explicitly 
        if ($ignoreAuto) {
            $this->fieldIsNot($taxonomyBundleType, true, 'auto', $alias);
        }
    }
    
    public function taxonomyTermTitleContains($taxonomyBundleName, $taxonomyBundleType, $string)
    {
        throw new Exception\RuntimeException('Call to unsupported method: ' . __METHOD__);
    }

    public function fieldIs($field, $value, $column = 'value', $alias = null, $on = null)
    {
        if ($field === 'bundle_name') {
            $this->_bundleName = $value;
        }
        return parent::fieldIs($field, $value, $column, $alias, $on);
    }

    public function fieldIsIn($field, array $values, $column = 'value', $alias = null, $on = null)
    {
        if ($field === 'bundle_name') {
            $this->_bundleName = current(array_values($values));
        }
        return parent::fieldIsIn($field, $values, $column, $alias, $on);
    }

    public function getQueriedBundleName()
    {
        return $this->_bundleName;
    }
}