<?php
/* This file has been auto-generated. Do not edit this file directly. */
namespace SabaiApps\Directories\Component\View\Model\Base;

use SabaiApps\Framework\Model\Model;

abstract class FilterGateway extends \SabaiApps\Framework\Model\AbstractGateway
{
    public function getName()
    {
        return 'view_filter';
    }

    public function getFields()
    {
        return ['filter_name' => Model::KEY_TYPE_VARCHAR, 'filter_type' => Model::KEY_TYPE_VARCHAR, 'filter_data' => Model::KEY_TYPE_TEXT, 'filter_bundle_name' => Model::KEY_TYPE_VARCHAR, 'filter_field_id' => Model::KEY_TYPE_INT, 'filter_display_name' => Model::KEY_TYPE_VARCHAR, 'filter_id' => Model::KEY_TYPE_INT, 'filter_created' => Model::KEY_TYPE_INT, 'filter_updated' => Model::KEY_TYPE_INT];
    }

    protected function _getIdFieldName()
    {
        return 'filter_id';
    }

    protected function _getSelectByIdQuery($id, $fields)
    {
        return sprintf(
            'SELECT %s FROM %sview_filter WHERE filter_id = %d',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $id
        );
    }

    protected function _getSelectByIdsQuery($ids, $fields)
    {
        return sprintf(
            'SELECT %s FROM %sview_filter WHERE filter_id IN (%s)',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            implode(', ', array_map('intval', $ids))
        );
    }

    protected function _getSelectByCriteriaQuery($criteriaStr, $fields)
    {
        return sprintf(
            'SELECT %1$s FROM %2$sview_filter view_filter WHERE %3$s',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $criteriaStr
        );
    }

    protected function _getInsertQuery(&$values)
    {
        $values['filter_created'] = time();
        $values['filter_updated'] = 0;
        return sprintf('INSERT INTO %sview_filter(filter_name, filter_type, filter_data, filter_bundle_name, filter_field_id, filter_display_name, filter_id, filter_created, filter_updated) VALUES(%s, %s, %s, %s, %d, %s, %s, %d, %d)', $this->_db->getResourcePrefix(), $this->_db->escapeString($values['filter_name']), $this->_db->escapeString($values['filter_type']), $this->_db->escapeString(serialize($values['filter_data'])), $this->_db->escapeString($values['filter_bundle_name']), $values['filter_field_id'], $this->_db->escapeString($values['filter_display_name']), empty($values['filter_id']) ? 'NULL' : intval($values['filter_id']), $values['filter_created'], $values['filter_updated']);
    }

    protected function _getUpdateQuery($id, $values)
    {
        $last_update = $values['filter_updated'];
        $values['filter_updated'] = time();
        return sprintf('UPDATE %sview_filter SET filter_name = %s, filter_type = %s, filter_data = %s, filter_bundle_name = %s, filter_field_id = %d, filter_display_name = %s, filter_updated = %d WHERE filter_id = %d AND filter_updated = %d', $this->_db->getResourcePrefix(), $this->_db->escapeString($values['filter_name']), $this->_db->escapeString($values['filter_type']), $this->_db->escapeString(serialize($values['filter_data'])), $this->_db->escapeString($values['filter_bundle_name']), $values['filter_field_id'], $this->_db->escapeString($values['filter_display_name']), $values['filter_updated'], $id, $last_update);
    }

    protected function _getDeleteQuery($id)
    {
        return sprintf('DELETE FROM %1$sview_filter WHERE filter_id = %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getUpdateByCriteriaQuery($criteriaStr, $sets)
    {
        $sets['filter_updated'] = 'filter_updated=' . time();
        return sprintf('UPDATE %sview_filter view_filter SET %s WHERE %s', $this->_db->getResourcePrefix(), implode(', ', $sets), $criteriaStr);
    }

    protected function _getDeleteByCriteriaQuery($criteriaStr)
    {
        return sprintf('DELETE view_filter FROM %1$sview_filter view_filter WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getCountByCriteriaQuery($criteriaStr)
    {
        return sprintf('SELECT COUNT(*) FROM %1$sview_filter view_filter WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }
}