<?php
/* This file has been auto-generated. Do not edit this file directly. */
namespace SabaiApps\Directories\Component\System\Model\Base;

use SabaiApps\Framework\Model\Model;

abstract class ComponentGateway extends \SabaiApps\Framework\Model\AbstractGateway
{
    public function getName()
    {
        return 'system_component';
    }

    public function getFields()
    {
        return ['component_name' => Model::KEY_TYPE_VARCHAR, 'component_version' => Model::KEY_TYPE_VARCHAR, 'component_priority' => Model::KEY_TYPE_INT, 'component_config' => Model::KEY_TYPE_TEXT, 'component_events' => Model::KEY_TYPE_TEXT, 'component_created' => Model::KEY_TYPE_INT, 'component_updated' => Model::KEY_TYPE_INT];
    }

    protected function _getIdFieldName()
    {
        return 'component_name';
    }

    protected function _getSelectByIdQuery($id, $fields)
    {
        return sprintf(
            'SELECT %s FROM %ssystem_component WHERE component_name = %s',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $this->_db->escapeString($id)
        );
    }

    protected function _getSelectByIdsQuery($ids, $fields)
    {
        return sprintf(
            'SELECT %s FROM %ssystem_component WHERE component_name IN (%s)',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            implode(', ', array_map(array($this->_db, 'escapeString'), $ids))
        );
    }

    protected function _getSelectByCriteriaQuery($criteriaStr, $fields)
    {
        return sprintf(
            'SELECT %1$s FROM %2$ssystem_component system_component WHERE %3$s',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $criteriaStr
        );
    }

    protected function _getInsertQuery(&$values)
    {
        $values['component_created'] = time();
        $values['component_updated'] = 0;
        return sprintf('INSERT INTO %ssystem_component(component_name, component_version, component_priority, component_config, component_events, component_created, component_updated) VALUES(%s, %s, %d, %s, %s, %d, %d)', $this->_db->getResourcePrefix(), $this->_db->escapeString($values['component_name']), $this->_db->escapeString($values['component_version']), $values['component_priority'], $this->_db->escapeString(serialize($values['component_config'])), $this->_db->escapeString(serialize($values['component_events'])), $values['component_created'], $values['component_updated']);
    }

    protected function _getUpdateQuery($id, $values)
    {
        $last_update = $values['component_updated'];
        $values['component_updated'] = time();
        return sprintf('UPDATE %ssystem_component SET component_version = %s, component_priority = %d, component_config = %s, component_events = %s, component_updated = %d WHERE component_name = %s AND component_updated = %d', $this->_db->getResourcePrefix(), $this->_db->escapeString($values['component_version']), $values['component_priority'], $this->_db->escapeString(serialize($values['component_config'])), $this->_db->escapeString(serialize($values['component_events'])), $values['component_updated'], $this->_db->escapeString($id), $last_update);
    }

    protected function _getDeleteQuery($id)
    {
        return sprintf('DELETE FROM %1$ssystem_component WHERE component_name = %2$s', $this->_db->getResourcePrefix(), $this->_db->escapeString($id));
    }

    protected function _getUpdateByCriteriaQuery($criteriaStr, $sets)
    {
        $sets['component_updated'] = 'component_updated=' . time();
        return sprintf('UPDATE %ssystem_component system_component SET %s WHERE %s', $this->_db->getResourcePrefix(), implode(', ', $sets), $criteriaStr);
    }

    protected function _getDeleteByCriteriaQuery($criteriaStr)
    {
        return sprintf('DELETE system_component FROM %1$ssystem_component system_component WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getCountByCriteriaQuery($criteriaStr)
    {
        return sprintf('SELECT COUNT(*) FROM %1$ssystem_component system_component WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }
}