<?php
namespace SabaiApps\Directories\Component\Location\FieldRenderer;

use SabaiApps\Directories\Component\Field\IField;
use SabaiApps\Directories\Component\Map\FieldRenderer\MapFieldRenderer as MapFieldRendererBase;

class MapFieldRenderer extends MapFieldRendererBase
{
    protected function _fieldRendererInfo()
    {
        $info = parent::_fieldRendererInfo();
        $info['field_types'][] = 'location_address';
        $info['default_settings'] += [
            'custom_infobox_addr_format' => false,
            'infobox_addr_format' => null,
        ];
        return $info;
    }
    
    protected function _fieldRendererSettingsForm(IField $field, array $settings, array $parents = [])
    {
        $form = parent::_fieldRendererSettingsForm($field, $settings, $parents);
        if ($this->_name === 'location_address') {
            if (!$field->isCustomField()) {
                $location_bundle = $this->_getLocationBundle($field);
                $location_hierarchy = $this->_application->Location_Hierarchy($location_bundle ? $location_bundle : null);
            } else {
                $location_hierarchy = null;
            }
            $form += [
                'custom_infobox_addr_format' => [
                    '#type' => 'checkbox',
                    '#title' => __('Customize format of address on infobox', 'directories-pro'),
                    '#default_value' => !empty($settings['custom_infobox_addr_format']),
                    '#weight' => 20,
                ],
                'infobox_addr_format' => [
                    '#type' => 'textfield',
                    '#description' => sprintf(
                        __('Available tags: %s', 'directories-pro'),
                        implode(' ', $this->_application->Location_FormatAddress_tags($field->Bundle, $location_hierarchy))
                    ),
                    '#default_value' => isset($settings['infobox_addr_format']) ? $settings['infobox_addr_format'] : '{full_address}',
                    '#states' => [
                        'visible' => [
                            sprintf(
                                'input[name="%s"]',
                                $this->_application->Form_FieldName(array_merge($parents, ['custom_infobox_addr_format']))
                            ) => ['type' => 'checked', 'value' => true],
                        ],
                    ],
                    '#weight' => 21,
                ],
            ];
        }
        
        return $form;
    }

    protected function _getJsMapOptions(array $settings)
    {
        return [
            'infobox' => true,
        ] + parent::_getJsMapOptions($settings);
    }
}
