<?php

namespace Directorist_Pricing_Plan\Lib\WP_Background_Processing;

use Directorist_Pricing_Plan\Lib\WP_Background_Processing\WP_Background_Process;

class Core_Background_Process extends WP_Background_Process {

	protected $action                  = 'pricing_plan_background_process';
	public    $after_complete_callback = null;

	public function __construct( $after_complete_callback = null ) {
		parent::__construct();
		$this->after_complete_callback = $after_complete_callback;
	}

	/**
	 * Task
	 *
	 * Override this method to perform any actions required on each
	 * queue item. Return the modified item for further processing
	 * in the next pass through. Or, return false to remove the
	 * item from the queue.
	 *
	 * @param mixed $item Queue item to iterate over
	 *
	 * @return mixed
	 */
	protected function task( $item ) {
		if ( ! $this->is_valid_callback( $item ) ) {
			return false;
		}

		$args = ( isset( $item[2] ) ) ? $item[2] : [];
		$callback = call_user_func( [ $item[0], $item[1]  ], $args );

		return ( $callback === true ) ? $item : false;
	}

	public static function is_valid_callback( $item ) {
		if ( ! is_array( $item ) ) {
			return false;
		}

		if ( ! ( count( $item ) >= 2 ) ) {
			return false;
		}

		if ( ! class_exists( $item[0] ) ) {
			return false;
		}

		$controller = new $item[0]();

		if ( ! method_exists( $controller, $item[1] ) ) {
			return false;
		}

		return true;
	}

	/**
	 * Complete
	 *
	 * Override if applicable, but ensure that the below actions are
	 * performed, or, call parent::complete().
	 */
	protected function complete() {
		parent::complete();

		if ( is_callable( $this->after_complete_callback ) ) {
			call_user_func( $this->after_complete_callback );
		}
	}

}