<?php
defined('ABSPATH') || die('Direct access is not allowed.');
/**
 * @since 1.7.4
 * @package Directorist
 */
if (!class_exists('DWPP_Views')) :

    class DWPP_Views
    {
        public function __construct()
        {
            add_shortcode('directorist_pricing_plans', array($this, 'directorist_fee_plane_page'));
            add_action('atbdp_listing_form_after_add_listing_title', array($this, 'dwpp_type_of_listing'));
            add_action('atbdp_user_dashboard_listings_before_expiration', array($this, 'dwpp_plan_change'));
            add_action('wp_footer', array($this, 'dwpp_plan_change_modal'));
            add_action('atbdp_tab_after_favorite_listings', array($this, 'dwpp_tab_after_favorite_listings'));
            add_action('atbdp_tab_content_after_favorite', array($this, 'dwpp_tab_content_after_favorite'));

            add_action('directorist_dashboard_tabs', array($this, 'directorist_dashboard_tabs'));
            add_action('directorist_before_pricing_plan_page', array($this, 'atbdp_add_listing_page_url'));
            add_action( 'directorist_dashboard_listing_th_6', array( $this, 'directorist_dashboard_listing_th_6' ) );
            add_action( 'directorist_dashboard_listing_td_6', array( $this, 'directorist_dashboard_listing_td_6' ) );
            add_filter( 'directorist_dashboard_listing_action_items', array( $this, 'directorist_dashboard_listing_action_items' ) );
            add_filter( 'directorist_dashboard_listing_action_items_end', array( $this, 'directorist_dashboard_listing_action_items_end' ) );

        }

        public function directorist_dashboard_tabs( $tabs ){
            $user_order_history = get_directorist_option('user_order_history', 1);
            $user_active_package = get_directorist_option('user_active_package', 1);
            $user_id        = get_current_user_id();
            $user_type      = (string) get_user_meta( $user_id, '_user_type', true );
            
            if( $user_active_package && ( empty( $user_type ) || 'general' != $user_type ) ){
                $tabs['packages'] = array(
                    'title'     => __('Packages', 'directorist-woocommerce-pricing-plans'),
                    'content'   => $this->dashboard_package_content(),
                    'icon'		=> 'las la-money-bill',
                );
            }

            if( $user_order_history ){
                $tabs['order_history'] = array(
                    'title'     => __('Order History', 'directorist-woocommerce-pricing-plans'),
                    'content'   => $this->dashboard_order_history(),
                    'icon'		=> 'las la-clock',
                );
            }


            return $tabs;
        }

        public function directorist_dashboard_listing_action_items_end( $items )
        {
            global $post;
            $restrict_listing_deletion = get_directorist_option( 'restrict_listing_deletion' );
            $plan_id = get_post_meta( $post->ID, '_fm_plans', true );
            $modal_id = apply_filters('atbdp_pricing_plan_change_modal_id', 'atpp-plan-change-modal', $post->ID );

            if( isset( $items['renew'] ) ){
                $items['pricing_plan']['label'] = __('Renew', 'directorist-woocommerce-pricing-plans');
				unset( $items['renew'] );

            }
            
            if( ! empty( $plan_id ) && $restrict_listing_deletion ) {
                unset( $items['delete'] );
            }
            if( isset( $items['promote'] ) ){
                unset( $items['promote'] );
            }

            return $items;
        }

        public function directorist_dashboard_listing_action_items( $items ) {

            global $post;
            $plan_id = get_post_meta( $post->ID, '_fm_plans', true );
            $change_plan = get_directorist_option('change_plan', 1);
            $modal_id = apply_filters( 'atbdp_pricing_plan_change_modal_id', 'atpp-plan-change-modal', $post->ID );
            $plan_purchased = subscribed_package_or_PPL_plans(get_current_user_id(), 'completed', $plan_id);
            $label = has_plan( $post->ID ) ? ( $plan_purchased ? __('Change', 'directorist-woocommerce-pricing-plans') : __('Pay Now', 'directorist-woocommerce-pricing-plans' ) ) : __('Promote', 'directorist-woocommerce-pricing-plans');
            $items['pricing_plan'] = array(
                'class'			    => 'atpp_change_plan',
                'data_attr'			=>	'data-target="'. $modal_id . '" data-listing_id="'. $post->ID .'"',
                'link'				=>	'#',
                'field'				=>  '',
                'icon'				=>  directorist_icon( 'las la-edit', false ),
                'label'				=>  $label
             );

             return $items;
        }

        public function directorist_dashboard_listing_th_6() {
            ob_start();
            ?>
            <th class="directorist_table-plan"><?php esc_html_e( 'Plan', 'directorist-woocommerce-pricing-plans' ); ?></th>
            <?php
            echo apply_filters( 'directorist_dashboard_listing_plan_th', ob_get_clean());

        }

        public function directorist_dashboard_listing_td_6( $dashboard ) {
            $plan_id = get_post_meta( get_the_ID(), '_fm_plans', true );
            $plan_name = ( has_plan( get_the_ID() ) && ( 'publish' == get_post_status( $plan_id ) ) ) ? get_the_title( $plan_id ) : __('No Plan!', 'directorist-woocommerce-pricing-plans' );
            ?>
           <td><span class="directorist_listing-plan"><?php echo $plan_name; ?></span></td>
            <?php
        }

        private function dashboard_package_content(){
            $user_id = get_current_user_id();
            $loop = directorist_plans_dashboard_data();
            $subscribed_package_ids = directorist_plans_dashboard_data( 'package_ids' );

            ob_start();
            ?>
            <div <?php echo apply_filters('atbdp_dashboard_package_content_div_attributes', 'class="atbd_tab_inner" id="manage_fees"'); ?>>
            <?php
            /**
             * @since 1.2.3
             */
            do_action('atbdp_before_package_table'); ?>

            <div class="atbd_manage_fees_wrapper">
                <?php
                if (!empty($subscribed_package_ids)) { ?>
                    <table class="table table-bordered atbd_single_saved_item table-responsive-sm">

                        <thead>
                        <tr>
                            <th><?php _e('Package Name', 'directorist-woocommerce-pricing-plans') ?></th>
                            <th><?php _e('Amount', 'directorist-woocommerce-pricing-plans') ?></th>
                            <th><?php _e('Remaining listings', 'directorist-woocommerce-pricing-plans') ?></th>
                            <th><?php _e('Order Date', 'directorist-woocommerce-pricing-plans') ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        $all_order_ids = array();
                        $order_data = array();
                        while ($loop->have_posts()) {
                        $loop->the_post();
                        $all_order_ids[] = $loop->post->ID;
                        $order = new WC_Order($loop->post->ID);
                        foreach ($order->get_items() as $key => $lineItem) {
                            $order_data[] = $order->get_items();
                            $subscribed_package_id = $lineItem->get_data()['product_id'];

                            $plan_type = get_post_meta($subscribed_package_id, 'plan_type', true);
                            if ($plan_type === 'package') {

                                $order_id = $order->get_id();
                                $subscribed_package_dates = $order->get_date_completed();

								$linked_subscription = get_post_meta( $subscribed_package_id, '_linked_pricing_plan', true );
                				if( class_exists( 'WC_Subscriptions_Product' ) && $linked_subscription ) {
									$subscribed_package_id = get_post_meta( $subscribed_package_id, '_linked_pricing_plan', true );
								}

                                $plan_name  = get_the_title($subscribed_package_id);
								$remaining  = plans_remaining( $subscribed_package_id, $order_id );
								$featured   = $remaining['featured'];
								$regular    = $remaining['regular'];
								
                                $start_date = !empty($subscribed_package_dates) ? $subscribed_package_dates : '';
                                ?>

                                <tr>
                                    <td class="package_name">
                                        <p><?php echo esc_attr( $plan_name ); ?></p>
                                    </td>

                                    <td class="package_amount">
                                        <p><?php echo esc_attr(  get_woocommerce_currency_symbol() . $lineItem->get_data()["total"] ); ?></p>
                                    </td>

                                    <td class="package_remaining">
                                        <p><?php echo !empty($num_regular_unl) ? __('Unlimited Regular listing ', 'directorist-woocommerce-pricing-plans') : __('Regular listing ', 'directorist-woocommerce-pricing-plans') . esc_attr($regular); ?>
                                        </p>

                                        <p><?php echo !empty($num_featured_unl) ? __('Unlimited Featured listing ', 'directorist-woocommerce-pricing-plans') : __('Featured listing ', 'directorist-woocommerce-pricing-plans') . esc_attr($featured); ?>
                                        </p>
                                    </td>

                                    <td class="package_start">
                                        <p><?php echo $start_date ? date('Y-m-d', strtotime($start_date)) : __('----', 'directorist-woocommerce-pricing-plans'); ?></p>
                                    </td>

                                </tr>
                                <?php
                            }
                        }//end foreach
                        }//end while
                        wp_reset_postdata();
                        ?>
                        </tbody>
                    </table>
                    <?php
                } else {
                    $text = '<p class="no_package_found">' . __("No package found!", 'directorist-woocommerce-pricing-plans') . '</p>';
                    echo apply_filters('atbdp_no_package_found_text', $text);
                } ?>
            </div>

            <?php
            /**
             * @since 1.3.3
             */
            do_action('atbdp_after_package_table'); ?>
            </div>

            <?php
            return ob_get_clean();
        }

        private function dashboard_order_history(){
            $loop = directorist_plans_dashboard_data();
            $all_order_ids = directorist_plans_dashboard_data( 'order_ids' );
            ob_start();
            ?>

            <div <?php echo apply_filters('atbdp_dashboard_orderHistory_content_div_attributes', 'class="atbd_tab_inner" id="manage_invoices"'); ?>>
                <?php
                /**
                 * @since 1.3.3
                 */
                do_action('atbdp_before_order_table'); ?>

                <div class="atbd_manage_fees_wrapper">
                    <?php
                    if (!empty($all_order_ids)) { ?>

                        <table class="table table-bordered atbd_single_saved_item table-responsive-sm">
                            <thead>
                            <tr>
                                <th><?php _e('Order Number', 'directorist-woocommerce-pricing-plans') ?></th>
                                <th><?php _e('Amount', 'directorist-woocommerce-pricing-plans') ?></th>
                                <th><?php _e('Order Date', 'directorist-woocommerce-pricing-plans') ?></th>
                                <th><?php _e('Plan Name', 'directorist-woocommerce-pricing-plans') ?></th>
                                <th><?php _e('Payment Receipt', 'directorist-woocommerce-pricing-plans') ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                        while ($loop->have_posts()) {
                        $loop->the_post();
                        $all_order_ids[] = $loop->post->ID;
                        $order = new WC_Order($loop->post->ID);
                        foreach ($order->get_items() as $key => $lineItem) {
                            $subscribed_package_id = $lineItem->get_data()['product_id'];
                            $subscribed_date = $order->get_date_completed();
                            $plan_name = $lineItem->get_name();
                            // Current time
                            $start_date = !empty($subscribed_date) ? $subscribed_date : '';

                            printf(' <tr>
                                                        <td class="order_no">
                                                        <p>%s</p>
                                                        </td>
                                                        <td class="package_amount">
                                                        <p>%s</p>
                                                        </td>

                                                        <td class="date">
                                                        <p>%s</p>
                                                        </td>

                                                        <td class="name">
                                                        <p>%s</p>
                                                        </td>

                                                        <td class="action">
                                                        <p>%s</p>
                                                        </td>
                                                    </tr>',
                                //td 1
                                '#' . $order->get_order_number(),
                                //td 2
                                get_woocommerce_currency_symbol() . $order->get_total(),
                                //td 3
                                $start_date ? date('Y-m-d', strtotime($start_date)) : __('----', 'directorist-woocommerce-pricing-plans'),
                                //td 4
                                $plan_name,
                                //td 5
                                '<a class="btn btn-block" href=' . $order->get_view_order_url() . '>' . __('View', 'directorist-woocommerce-pricing-plans') . '</a>'

                            );
                        }
                        }
                        wp_reset_postdata();
                        ?>
                            </tbody>
                        </table>

                        <?php
                    } else {
                        $text = '<p class="no_order_found">' . __("No order found!", 'directorist-woocommerce-pricing-plans') . '</p>';
                        echo apply_filters('atbdp_no_order_found_text', $text);
                    } ?>
                </div>

                <?php
                /**
                 * @since 1.3.3
                 */
                do_action('atbdp_after_order_table'); ?>
            </div>
        <?php
        return ob_get_clean();
        }

        public function dwpp_tab_content_after_favorite()
        {
           DWPP_Pricing_Plans()->load_template('user-dashboard-data');
        }

        public function dwpp_tab_after_favorite_listings()
        {
            $package_tab = get_directorist_option('user_active_package', 1);
            $order_histroy = get_directorist_option('user_order_history', 1);

            if (!empty($package_tab)) {
                $html = '<li class="atbdp_tab_nav--content-link atbd-packages">
                            <a href="" class="atbd_tn_link" target="manage_fees">
                                ' . __('Packages', 'directorist-woocommerce-pricing-plans') . '
                            </a>
                        </li>';
                echo apply_filters('atbdp_package_tab', $html);
            }

            if (!empty($order_histroy)) {
                $html = '<li class="atbd-orderhisyory">
                            <a href="" class="atbdp_tab_nav--content-link atbd_tn_link" target="manage_invoices">
                                ' . __('Order History', 'directorist-woocommerce-pricing-plans') . '
                            </a>
                        </li>';
                echo apply_filters('atbdp_order_history_tab', $html);
            }
        }

      /**
     * @since 1.2.1
     */
    public function atbdp_add_listing_page_url()
    {
        if( is_user_logged_in() )
        $skip_plans = get_directorist_option('skip_plan_page', 0);
        if (empty($skip_plans)) return; // void if admin not to decide show plan page for active packaged user
        $user_id = get_current_user_id();
        $directory_type = !empty($_GET['directory_type']) ? $_GET['directory_type'] : default_directory_type();
        $type = get_term_by( is_numeric( $directory_type ) ? 'id' : 'slug', $directory_type, ATBDP_TYPE );
        $args = array(
            'post_type' => 'shop_order',
            'post_status' => [ "wc-completed", "wc-processing" ],
            'numberposts' => -1,
            'meta_query' => array(
                'relation' => 'AND',
                array(
                    'key' => '_customer_user',
                    'value' => $user_id,
                    'compare' => '='
                ),
                array(
                    'key' => '_fm_plan_ordered',
                    'compare' => 'EXISTS'
                )
            ),
        );
        $orders = new WP_Query($args);

        foreach ($orders->posts as $key => $val) {

            $order_id = $val->ID;
            $plan_id = get_post_meta($order_id, '_fm_plan_ordered', true);
			$linked_subscription = get_post_meta( $plan_id, '_linked_pricing_plan', true );
			if( class_exists( 'WC_Subscriptions_Product' ) && $linked_subscription ) {
				$plan_id = $linked_subscription;
			}
            $assign_to_directory = get_post_meta( $plan_id, '_assign_to_directory', true );

            if ( $assign_to_directory != $type->term_id ) {
                return;
            }

            if ( 'package' !== package_or_PPL( $plan_id ) ) {

                $order_listings = get_post_meta( $order_id , '_listing_id', true );

                if ( ! $order_listings || ( $order_listings == '0' ) ) {

                    $args = [
                        'plan' => $plan_id,
                        'directory_type'=> $directory_type,
                        'order' => $order_id,
                    ];

                    $url = add_query_arg( $args, ATBDP_Permalink::get_add_listing_page_link());

                    echo '<script>window.location="' . $url . '"</script>';
                    exit;
                }


            }

            if ( 'package' === package_or_PPL( $plan_id )  ) {

                $valid_order = directorist_valid_order( $order_id, $plan_id );
                $order_status = get_post_meta( $order_id, '_order_status', true );

                if( ! $valid_order || ( 'exit' === $order_status ) ){
                    continue;
                }

                $args = [
                        'plan' => $plan_id,
                        'directory_type'=> $directory_type,
                        'order' => $order_id,
                    ];

                $url = add_query_arg( $args, ATBDP_Permalink::get_add_listing_page_link());

                echo '<script>window.location="' . $url . '"</script>';
            }
        }
    }



        public function atpp_tab_after_favorite_listings()
        {
            $user_order_history = get_directorist_option('user_order_history', 1);
            $user_active_package = get_directorist_option('user_active_package', 1);
            $user_subscription = 0;

            if (!empty($user_active_package)) {
                $html = '<li class="atbdp_tab_nav--content-link atbd-packages">
                            <a href="" class="atbd_tn_link" target="manage_fees">
                                ' . __('Packages', 'directorist-woocommerce-pricing-plans') . '
                            </a>
                        </li>';
                echo apply_filters('atbdp_package_tab', $html);
            }

            if (!empty($user_order_history)) {
                $html = '<li class="atbdp_tab_nav--content-link atbd-orderhisyory">
                                <a href="" class="atbd_tn_link" target="manage_invoices">
                                    ' . __('Order History', 'directorist-woocommerce-pricing-plans') . '
                                 </a>
                            </li>';
                echo apply_filters('atbdp_order_history_tab', $html);
            }

            if (!empty($user_subscription)) { ?>
                <li class="atbdp_tab_nav--content-link atbd-subscription"><a href="" <?php do_action('atbdp_attribute_in_dashboard_subscription_tab'); ?> class="atbd_tn_link" target="manage_subscription"><?php echo apply_filters('atbdp_subscription_tab_text_in_dashboard', __('Subscription', 'directorist-woocommerce-pricing-plans')); ?></a>
                </li>
            <?php
            }
        }

        public function atpp_tab_content_after_favorite()
        {
            ATBDP_Pricing_Plans()->load_template('user-dashboard-data');
        }
    /**
     * @since 1.1.6
     */
    public function dwpp_plan_change_modal()
    {
        $dashboard_page = get_directorist_option('user_dashboard');
        if( $dashboard_page != get_queried_object_id() ) return;
        ?>
        <div class="at-modal atm-fade" id="atpp-plan-change-modal">
            <div class="at-modal-content at-modal-lg">
                <div class="atm-contents-inner">
                    <a href="" class="at-modal-close">
                        <span aria-hidden="true">×</span>
                    </a>
                    <div class="align-items-center">
                        <form id="dwpp-change-plan-form" class="form-vertical" role="form">
                            <div class="atbd_modal-header">
                                <input type="hidden" value="" id="change_listing_id">
                                <h3 class="atbd_modal-title" id="dwpp-plan-label"><?php _e('Change Pricing Plan', 'directorist-woocommerce-pricing-plans'); ?></h3>
                                <?php
                                $link = '<a href="' . ATBDP_Permalink::get_fee_plan_page_link() . '" target="_blank">' . __('Click Here', 'directorist-woocommerce-pricing-plans') . '</a>';
                                printf('<p>%s %s</p>', __('We recommend you check the details of Pricing Plans before changing.', 'directorist-woocommerce-pricing-plans'), $link)
                                ?>
                            </div>
                            <div class="atbd_modal-contents">
                                <div class="atbd_modal-body">
                                    <div class="dcl_pricing_plan">
                                        <?php
                                        global $product;
                                        $meta_queries = array();
                                        $query_args = array(
                                            'post_type' => 'product',
                                            'tax_query' => array(
                                                array(
                                                    'taxonomy' => 'product_type',
                                                    'field' => 'slug',
                                                    'terms' => 'listing_pricing_plans',
                                                ),
                                            ),
                                            $meta_queries[] = array(
                                                'relation' => 'OR',
                                                array(
                                                    'key' => '_hide_from_plans',
                                                    'compare' => 'NOT EXISTS',
                                                ),
                                                array(
                                                    'key' => '_hide_from_plans',
                                                    'value' => 1,
                                                    'compare' => '!=',
                                                ),
                                            ),
                                        );
                                        $meta_queries = apply_filters('atbdp_plan_meta_query', $meta_queries);
                                        $count_meta_queries = count($meta_queries);
                                        if ($count_meta_queries) {
                                            $query_args['meta_query'] = ($count_meta_queries > 1) ? array_merge(array('relation' => 'AND'), $meta_queries) : $meta_queries;
                                        }

                                        $atbdp_query = new WP_Query($query_args);

                                        if ($atbdp_query->have_posts()) {
                                            global $post;
                                            $plans = $atbdp_query->posts;
                                            printf('<label for="select_plans">%s</label><hr>', __('Select Plan', 'directorist-woocommerce-pricing-plans'));
                                            foreach ($plans as $key => $value) {
                                                $active_plan = subscribed_package_or_PPL_plans(get_current_user_id(), 'completed', $value->ID);
                                                $plan_id = $value->ID;
                                                $unl = __('Unlimited', 'directorist-woocommerce-pricing-plans');
                                                $plan_type = get_post_meta( $plan_id, 'plan_type', true );
                                                $sale_price = get_post_meta( $plan_id, '_sale_price', true );
                                                $fm_price = $sale_price ? $sale_price : get_post_meta( $plan_id, '_regular_price', true );
                                                $fm_length = get_post_meta( $plan_id, 'fm_length', true );
                                                $fm_length_unl = get_post_meta( $plan_id, 'fm_length_unl', true );
                                                $num_regular = get_post_meta( $plan_id, 'num_regular', true );
                                                $num_regular_unl = get_post_meta( $plan_id, 'num_regular_unl', true );
                                                $num_featured = get_post_meta( $plan_id, 'num_featured', true );
                                                $num_featured_unl = get_post_meta( $plan_id, 'num_featured_unl', true );
                                                $regular = (empty($num_regular_unl) ? $num_regular : $unl) . __(' regular & ', 'directorist-woocommerce-pricing-plans');
                                                $featured = (empty($num_featured_unl) ? $num_featured : $unl) . __(' featured listings', 'directorist-woocommerce-pricing-plans');
                                                $allowances = sprintf('<p class="atbd_plan_core_features"><span class="apc_price">%s</span><span>%s%s</span><span>%s</span>%s</p>', get_woocommerce_currency_symbol() . $fm_price, empty($fm_length_unl) ? $fm_length : $unl, __(' days', 'directorist-woocommerce-pricing-plans'), ($plan_type === 'package' ? __('Package', 'directorist-woocommerce-pricing-plans') : __('Pay Per Listing', 'directorist-woocommerce-pricing-plans')), ( $plan_type === 'package' ) ? '<span>' . $regular . $featured . '</span>' : '' );
                                                $active = '';
                                                if ('package' === $plan_type && $active_plan) {
                                                    $active = ' <span class="atbd_badge atbd_badge_open">' . __('Active', 'directorist-woocommerce-pricing-plans') . '</span>';
                                                }
                                                printf('<input type="radio" class="new_plan_id" id="%s" name="new_plan" value="%s"> <label for="%s"> %s</label>%s <br>%s<hr>', $value->ID, $value->ID, $value->ID, $value->post_title, $active, $allowances);
                                            }
                                        }
                                        ?>
                                    </div>
                                    <div id="directorist-allowances"></div>
                                    <div id="dcl-claim-submit-notification"></div>
                                    <div id="dcl-claim-warning-notification"></div>
                                </div>
                                <div class="atbd_modal-footer">
                                    <button type="submit" class="atbd_modal_btn"><?php esc_html_e('Change', 'directorist-woocommerce-pricing-plans'); ?></button>
                                    <span><?php directorist_icon( 'las la-lock' ); ?> <?php esc_html_e('Secure Payment Process', 'directorist-woocommerce-pricing-plans'); ?></span>
                                </div>
                            </div>
                        </form>
                    </div><!-- ends: .col-lg-125 -->
                </div>
            </div>
        </div>
        <?php
    }

    /**
     * 1.3.2
     * @param $listing_id
     */
    public function dwpp_plan_change($listing_id)
    {
        $plan_id = get_post_meta($listing_id, '_fm_plans', true);
        $change_plan = get_directorist_option('change_plan', 1);
        $plan_purchased = subscribed_package_or_PPL_plans(get_current_user_id(), 'completed', $plan_id);
        $change_link_text = has_plan($listing_id) ? ($plan_purchased ? __('Change', 'directorist-woocommerce-pricing-plans') : __('Pay Now', 'directorist-woocommerce-pricing-plans')) : __('Promote', 'directorist-woocommerce-pricing-plans');
        $modal_id = apply_filters('atbdp_pricing_plan_change_modal_id', 'atpp-plan-change-modal', $listing_id);
        $change_plan_link = apply_filters('atbdp_plan_change_link_in_user_dashboard', '<span><a data-target="' . $modal_id . '" class="dwpp_change_plan" data-listing_id="' . $listing_id . '" href="javascript:void(0)">' . $change_link_text . '</a></span>', $listing_id);

        $plan_name = ( has_plan( $listing_id ) && ('publish' == get_post_status($plan_id))) ? get_the_title($plan_id) : __('No Plan!', 'directorist-woocommerce-pricing-plans');
        printf(__('<p><span>Plan:</span> %s %s</p>', 'directorist-woocommerce-pricing-plans'), $plan_name, !empty($change_plan) ? $change_plan_link : '');
    }
                                                                                                                                                                                         
    public function dwpp_type_of_listing($listing_info)
    {
        if (!is_fee_manager_active()) return false; //void if admin deactivated plan from settings panel
        if ((package_or_PPL($plan = null) === 'pay_per_listng') || !empty($listing_info)) return false;
        $plan_id = selected_plan_id();
        $featured = plans_remaining( $plan_id, 'featured' );
        $regular = plans_remaining( $plan_id, 'regular' );
    ?>
        <div class="atbd_listing_type">
            <?php $listing_type = !empty($listing_info['listing_type']) ? $listing_info['listing_type'] : ''; ?>

            <h4 class="atbdp_option_title"><?php _e('Choose Listing Type', 'directorist-woocommerce-pricing-plans') ?></h4>
            <div class="atbd_listing_type_list">
                <?php
                if ( 'Unlimited' === $featured ) {
                ?>
                    <div class="atbdp_input_group --atbdp_inline">
                        <input id="regular" <?php echo ($listing_type == 'regular') ? 'checked' : ''; ?> type="radio" class="atbdp_radio_input" name="listing_type" value="regular" checked>
                        <label for="regular"><?php _e(' Regular listing', 'directorist-woocommerce-pricing-plans') ?>
                            <span class="atbdp_make_str_green"><?php _e(" (Unlimited)", 'directorist-woocommerce-pricing-plans') ?></span>
                        </label>
                    </div>
                <?php } else { ?>
                    <div class="atbdp_input_group --atbdp_inline">
                        <input id="regular" <?php echo ($listing_type == 'regular') ? 'checked' : ''; ?> type="radio" class="atbdp_radio_input" name="listing_type" value="regular" checked>
                        <label for="regular"><?php _e(' Regular listing', 'directorist-woocommerce-pricing-plans') ?>
                            <span class="<?php echo $regular > 0 ? 'atbdp_make_str_green' : 'atbdp_make_str_red' ?>">
                                <?php echo '(' . $regular . __(' Remaining', 'directorist-woocommerce-pricing-plans') . ')'; ?></span>
                        </label>
                    </div>
                <?php } ?>

                <?php
                if ( 'Unlimited' === $regular ) {
                ?>
                    <div class="atbdp_input_group --atbdp_inline">
                        <input id="featured" type="radio" class="atbdp_radio_input" <?php echo ($listing_type == 'featured') ? 'checked' : ''; ?> name="listing_type" value="featured">
                        <label for="featured" class="featured_listing_type_select">
                            <?php _e(' Featured listing', 'directorist-woocommerce-pricing-plans') ?>
                            <span class="atbdp_make_str_green"><?php _e(" (Unlimited)", 'directorist-woocommerce-pricing-plans') ?></span>
                        </label>
                    </div>
                <?php
                } else { ?>
                    <div class="atbdp_input_group --atbdp_inline">
                        <input id="featured" type="radio" <?php echo ($listing_type == 'featured') ? 'checked' : ''; ?> class="atbdp_radio_input" name="listing_type" value="featured">
                        <label for="featured" class="featured_listing_type_select">
                            <?php _e(' Featured listing', 'directorist-woocommerce-pricing-plans') ?>
                            <span class="<?php echo $featured > 0 ? 'atbdp_make_str_green' : 'atbdp_make_str_red' ?>">
                                <?php echo '(' . $featured . __(' Remaining', 'directorist-woocommerce-pricing-plans') . ')'; ?></span>
                        </label>
                    </div>
                <?php } ?>
            </div>
        </div>
<?php
    }

        public function directorist_fee_plane_page($atts)
        {
            ob_start();
            DWPP_Pricing_Plans()->load_template('fee-plans', array('atts' => $atts));
            return ob_get_clean();
        }
    }
endif;