<?php
// Prohibit direct script loading.
defined( 'ABSPATH' ) || die( 'No direct script access allowed!' );

if ( ! function_exists( 'swbd_pricing_plan__include_additional_submission_fields' ) ) {
    function swbd_pricing_plan__include_additional_submission_fields( array $args = [] ) {
        $default = ['submission_form_fields' => []];
        $args    = array_merge( $default, $args );

        $submission_form_fields = ( isset( $args['submission_form_fields'] ) ) ? $args['submission_form_fields'] : [];

        foreach ( $submission_form_fields as $field_key => $field_args ) {

            if ( ! empty( $field_args['modules'] ) ) {
                $_modules = ( is_string( $field_args['modules'] ) ) ? json_decode( $field_args['modules'], true ) : $field_args['modules'];

                if ( is_null( $_modules ) || ! is_array( $_modules ) ) {continue;}

                $_field_key_index = array_search( $field_key, array_keys( $submission_form_fields ) );
                $_counter         = 1;

                foreach ( $_modules as $_module_key => $_module_args ) {
                    $_field_module_key_index = $_field_key_index + $_counter;
                    $_module                 = [];
                    $_module[$_module_key]   = $_module_args;

                    array_splice( $submission_form_fields, $_field_module_key_index, 0, $_module );

                    $_counter++;
                }

            }

        }

        return $submission_form_fields;
    }
}

if ( ! function_exists( 'atbdp_get_option' ) ) {

    /**
     * @return array    It returns the role of the users
     */
    function all_rules() {
        return apply_filters( 'dgrc_default_user_roles', [
            [
                'value' => 'administrator',
                'label' => __( 'Administrator', 'directorist-woocommerce-pricing-plans' ),
            ],
            [
                'value' => 'editor',
                'label' => __( 'Editor', 'directorist-woocommerce-pricing-plans' ),
            ],
            [
                'value' => 'author',
                'label' => __( 'Author', 'directorist-woocommerce-pricing-plans' ),
            ],
            [
                'value' => 'contributor',
                'label' => __( 'Contributor', 'directorist-woocommerce-pricing-plans' ),
            ],
            [
                'value' => 'subscriber',
                'label' => __( 'Subscriber', 'directorist-woocommerce-pricing-plans' ),
            ],
        ] );
    }

    /**
     * It retrieves an option from the database if it exists and returns false if it is not exist.
     * It is a custom function to get the data of custom setting page
     * @param string $name The name of the option we would like to get. Eg. map_api_key
     * @param string $group The name of the group where the option is saved. eg. general_settings
     * @param mixed $default Default value for the option key if the option does not have value then default will be returned
     * @return mixed    It returns the value of the $name option if it exists in the option $group in the database, false otherwise.
     */

    function atbdp_get_option( $name, $group, $default = false ) {
        // at first get the group of options from the database.
        // then check if the data exists in the array and if it exists then return it
        // if not, then return false
        if ( empty( $name ) || empty( $group ) ) {
            if ( ! empty( $default ) ) {
                return $default;
            }

            return false;
        } // vail if either $name or option $group is empty
        $options_array = (array) get_option( $group );
        if ( array_key_exists( $name, $options_array ) ) {
            return $options_array[$name];
        } else {
            if ( ! empty( $default ) ) {
                return $default;
            }

            return false;
        }
    }
}

if ( ! function_exists( 'atbdp_sanitize_array' ) ) {
    /**
     * It sanitize a multi-dimensional array
     * @param array &$array The array of the data to sanitize
     * @return mixed
     */
    function atbdp_sanitize_array( &$array ) {

        foreach ( $array as &$value ) {

            if ( ! is_array( $value ) ) {

                // sanitize if value is not an array
                $value = sanitize_text_field( $value );

            } else {

                // go inside this function again
                atbdp_sanitize_array( $value );
            }

        }

        return $array;

    }
}

if ( ! function_exists( 'is_directoria_active' ) ) {
    /**
     * It checks if the Directorist theme is installed currently.
     * @return bool It returns true if the directorist theme is active currently. False otherwise.
     */
    function is_directoria_active() {
        return wp_get_theme()->get_stylesheet() === 'directoria';
    }
}

if ( ! function_exists( 'is_plan_allowed_business_hours' ) ) {
    /**
     * It checks is user activated business hours and is the purchased plan included that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_business_hours( $plan_id ) {
        //return true;
        //check is BH activated
        if ( class_exists( 'BD_Business_Hour' ) ) {
            // lets check the plan allowances
            $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
            $business_hrs     = selected_plan_meta( $selected_plan_id, 'business_hrs' );
            return ( $business_hrs ) ? true : false;
        } else {
            return false;
        }

    }
}

if ( ! function_exists( 'is_plan_allowed_listing_video' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_listing_video( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $l_video          = selected_plan_meta( $selected_plan_id, 'l_video' );
        return ( $l_video ) ? true : false;
    }
}

if ( ! function_exists( 'is_plan_allowed_owner_contact_widget' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_owner_contact_widget( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $cf_owner         = selected_plan_meta( $selected_plan_id, 'cf_owner' );
        return ( $cf_owner ) ? true : false;
    }
}

if ( ! function_exists( 'is_plan_allowed_listing_email' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_listing_email( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $fm_email         = selected_plan_meta( $selected_plan_id, 'fm_email' );
        return ( $fm_email ) ? true : false;
    }
}

if ( ! function_exists( 'is_plan_allowed_listing_phone' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_listing_phone( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $fm_phone         = selected_plan_meta( $selected_plan_id, 'fm_phone' );
        return ( $fm_phone ) ? true : false;
    }
}

if ( ! function_exists( 'is_plan_allowed_listing_webLink' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_listing_webLink( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $fm_web_link      = selected_plan_meta( $selected_plan_id, 'fm_web_link' );
        return ( $fm_web_link ) ? true : false;
    }
}

if ( ! function_exists( 'is_plan_allowed_listing_social_networks' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_listing_social_networks( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id  = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $fm_social_network = selected_plan_meta( $selected_plan_id, 'fm_social_network' );
        return ( $fm_social_network ) ? true : false;
    }
}

if ( ! function_exists( 'is_plan_allowed_listing_review' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_listing_review( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $fm_cs_review     = selected_plan_meta( $selected_plan_id, 'fm_cs_review' );
        return ( $fm_cs_review ) ? true : false;
    }
}
if ( ! function_exists( 'is_plan_allowed_listing_faqs' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_listing_faqs( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $fm_listing_faq   = selected_plan_meta( $selected_plan_id, 'fm_listing_faq' );
        return ( $fm_listing_faq ) ? true : false;
    }
}

if ( ! function_exists( 'is_plan_allowed_category' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_category( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $exclude_cat      = selected_plan_meta( $selected_plan_id, 'exclude_cat' );
        return ( $exclude_cat ) ? $exclude_cat : false;
    }
}

if ( ! function_exists( 'is_plan_allowed_custom_fields' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_custom_fields( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $fm_custom_field  = selected_plan_meta( $selected_plan_id, 'fm_custom_field' );
        return ( $fm_custom_field ) ? true : false;
    }
}

if ( ! function_exists( 'is_plan_allowed_average_price_range' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_average_price_range( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id     = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $fm_allow_price_range = selected_plan_meta( $selected_plan_id, 'fm_allow_price_range' );
        return ( $fm_allow_price_range ) ? true : false;
    }
}

if ( ! function_exists( 'is_plan_allowed_listing_gallery' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_listing_gallery( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id     = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $atfm_listing_gallery = selected_plan_meta( $selected_plan_id, 'atfm_listing_gallery' );
        return ( $atfm_listing_gallery ) ? true : false;
    }
}

if ( ! function_exists( 'is_plan_allowed_featured_listing' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_featured_listing() {
        $selected_plan_id   = selected_plan_id();
        $num_featured       = selected_plan_meta( $selected_plan_id, 'num_featured' );
        $unlimited_featured = selected_plan_meta( $selected_plan_id, 'num_featured_unl' );
        return ( $num_featured || $unlimited_featured ) ? true : false;
    }
}

if ( ! function_exists( 'selected_plan_id' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function selected_plan_id() {
        if ( ATBDP_VERSION < '6.3.0' ) { // add compatibility with directorist version bellow 6.3.0
            if ( ! empty( $_GET['plan'] ) ) {
                $plan_id = $_GET['plan'];
                return $plan_id;
            } else {
                return false;
            }
        } else {
            if ( ! empty( $_POST['plan'] ) ) {
                $plan_id = $_POST['plan'];
                return $plan_id;
            } else {
                return isset( $_GET['plan'] ) ? $_GET['plan'] : '';
            }
        }

    }
}

if ( ! function_exists( 'selected_plan_meta' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function selected_plan_meta( $plan_id, $meta_key ) {

        $plan_meta = get_post_meta( $plan_id, $meta_key, true );
        return $plan_meta;
    }
}

if ( ! function_exists( 'package_or_PPL' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function package_or_PPL( $plan_id ) {
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $plan_type        = selected_plan_meta( $selected_plan_id, 'plan_type' );
        return ( $plan_type ) ? $plan_type : '';
    }
}

if ( ! function_exists( 'PPL_with_featured' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function PPL_with_featured( $plan = null ) {
        $selected_plan_id    = ! empty( $plan ) ? $plan : selected_plan_id();
        $is_featured_listing = selected_plan_meta( $selected_plan_id, 'is_featured_listing' );
        return ( $is_featured_listing ) ? true : false;
    }
}

if ( ! function_exists( 'atbdp_get_expaire_status' ) ):
    function atbdp_get_expaire_status( array $args = [] ) {
        $default = [
            'post_date'      => date( 'Y-m-d', time() ),
            'length_in_days' => 0,
        ];

        $args = array_merge( $default, $args );
        extract( $args );

        if ( ! $length_in_days ) {
            return [
                'is_expaired'    => false,
                'expair_date'    => null,
                'length_in_days' => $length_in_days,
            ];
        }

        $expair_date = date( 'Y-m-d', strtotime( $post_date . " + $length_in_days days" ) );
        $today       = date( 'Y-m-d', time() );

        $today       = date_create( $today );
        $expair_date = date_create( $expair_date );
        $post_date   = date_create( $post_date );
        $expaired    = ( $today > $expair_date ) ? true : false;

        return [
            'post_date'      => $post_date,
            'expair_date'    => $expair_date,
            'length_in_days' => $length_in_days,
            'is_expaired'    => $expaired,
        ];
    }
endif;

if ( ! function_exists( 'atbdp_plan_expaire_status' ) ):
    function atbdp_plan_expaire_status( $plan_id, $order_id ) {
        $order           = get_post( $order_id );
        $order_post_date = $order->post_date;

        $plan_meta   = get_post_meta( $plan_id );
        $plan_length = $plan_meta['fm_length'][0];

        $expaire_status = atbdp_get_expaire_status( [
            'post_date'      => $order_post_date,
            'length_in_days' => $plan_length,
        ] );

        return [
            'order_date'  => date_create( $order_post_date ),
            'plan_length' => $plan_length,
            'expair_date' => $expaire_status['expair_date'],
            'is_expaired' => $expaire_status['is_expaired'],
        ];
    }
endif;

if ( ! function_exists( 'subscribed_package_or_PPL_plans' ) ) {
    /**
     * Get the order of current author for ATBDP order table.
     * @param $plan_id
     * @param $order_status
     * @param $user_id
     * @return true It returns all the subscribed plan id.
     */
    function subscribed_package_or_PPL_plans( $user_id, $order_status, $plan_id, $listing_id = null ) {

        $subscription = false;
        $status = [ "wc-$order_status", "wc-processing" ];
        if( directoirst_wc_plan_auto_renewal( $plan_id ) ) {
            $plan_id = directoirst_wc_plan_auto_renewal( $plan_id );
            $active_subscription = wcs_get_subscriptions([
                'customer_id' => $user_id,
                'product_id'  => $plan_id,
                'subscription_status'  => 'active',
            ]);

            if ( $active_subscription ) {
                $order_id = wp_get_post_parent_id( array_key_first( $active_subscription ) );
                return $order_id;
            }
            
            $subscription = true;
        }

        if ( ! $user_id ) {
            return [];
        }
        
        $args = [
            'post_type'   => 'shop_order',
            'post_status' => $status,
            'numberposts' => -1,
        ];

        $args['meta_query'] = [
            'relation' => 'AND',
            [
                'key'     => '_customer_user',
                'value'   => $user_id,
                'compare' => '=',
            ],
            [
                'key'     => '_fm_plan_ordered',
                'value'   => $plan_id,
                'compare' => '=',
            ],
        ];

        $orders = new WP_Query( $args );

        $Plan_meta = [];
        foreach ( $orders->posts as $key => $val ) {
            $order_id = $val->ID;
            $order_listings = get_post_meta( $order_id, '_listing_id', true );
			
			if( ! $listing_id ) {
				$Plan_meta[] = $val;
				continue;
			}
			
			if( ! $order_listings ) {
				$Plan_meta[] = $val;
				continue;
			}
			
			if( ! is_array( $order_listings ) && $listing_id == $order_listings ) {
				$Plan_meta[] = $val;
				continue;
			}
			
			if( is_array( $order_listings ) && in_array( $listing_id, $order_listings ) ){
				$Plan_meta[] = $val;
				continue;
			}else{
				$Plan_meta[] = $val;
				continue;
			}
        }
        if( $subscription ) {
            $order_id           = $Plan_meta ? $Plan_meta[0]->ID : '';
            $subscription_id    = get_post_meta( $order_id , '_linked_subscription', true );
            $sub_boject         = wcs_get_subscription( $subscription_id );

            if( $sub_boject ) {
                $status = $sub_boject->get_status();

                if( 'active' !== $status ) {
                    return false;
                }
            }
        }
        return ! empty( $Plan_meta ) ? $Plan_meta : false;
    }
}

if ( ! function_exists( 'swbd_get_listing_wc_payment_status' ) ) {
    function swbd_get_listing_wc_payment_status( $listing_id = '', $plan_id = '', $user_id = '' ) {
        $order_id       = swbd_get_listings_wc_order_id( $listing_id, $plan_id, $user_id );
        $order          = wc_get_order( $order_id );
        $payment_status = ( $order ) ? $order->get_status() : '';

        return $payment_status;
    }
}

if ( ! function_exists( 'swbd_get_listing_plan_order_status' ) ) {
    function swbd_get_listing_plan_order_status( $order_id = '' ) {
        $order          = wc_get_order( $order_id );
        $payment_status = ( $order ) ? $order->get_status() : 'on-hold';

        return $payment_status;
    }
}

if ( ! function_exists( 'swbd_get_listings_wc_order_id' ) ) {
    function swbd_get_listings_wc_order_id( $listing_id = '', $plan_id = '', $user_id = '' ) {
        $order_id = get_post_meta( $listing_id, '_listing_wc_order_id', true );

        if ( ! empty( $order_id ) && empty( $plan_id ) && empty( $user_id ) ) {
            return $order_id;
        }

        $args = [
            'post_type'   => 'shop_order',
            'post_status' => array_keys( wc_get_order_statuses() ),
            'numberposts' => -1,
        ];

        $meta_query             = [];
        $meta_query['relation'] = 'AND';

        if ( ! empty( $user_id ) ) {
            $meta_query[] = [
                'key'     => '_customer_user',
                'value'   => $user_id,
                'compare' => '=',
            ];
        }

        if ( ! empty( $plan_id ) ) {
            $meta_query[] = [
                'key'     => '_fm_plan_ordered',
                'value'   => $plan_id,
                'compare' => '=',
            ];
        }

        if ( ! empty( $listing_id ) ) {
            $meta_query[] = [
                'key'     => '_listing_id',
                'value'   => $listing_id,
                'compare' => '=',
            ];
        }

        $args['meta_querys'] = $meta_query;

        $orders   = new WP_Query( $args );
        $order_id = ( $orders->have_posts() ) ? $orders->post->ID : '';

        if ( ! empty( $listing_id ) && empty( $plan_id ) && empty( $user_id ) ) {
            update_post_meta( $listing_id, '_listing_wc_order_id', $order_id );
        }

        return $order_id;
    }
}

if ( ! function_exists( 'package_or_PPL_with_listing' ) ) {
    /**
     * Get the order of current author for ATBDP order table.
     * @param $listing_id
     * @param $order_status
     * @param $user_id
     * @return true It returns all the subscribed plan id.
     */
    function package_or_PPL_with_listing( $user_id, $order_status, $listing_id ) {
        $status = [ "wc-completed", "wc-processing" ];
        $args = [
            'post_type'   => 'shop_order',
            'post_status' => $status,
            'numberposts' => -1,
            'meta_query'  => [
                'relation' => 'AND',
                [
                    'key'     => '_customer_user',
                    'value'   => $user_id,
                    'compare' => '=',
                ],
                [
                    'key'     => '_listing_id',
                    'value'   => $listing_id,
                    'compare' => '=',
                ],
            ],
        ];

        $active_plan = new WP_Query( $args );

        if ( $active_plan->have_posts() ):
            global $post;
            while ( $active_plan->have_posts() ):
                $active_plan->the_post();
            endwhile;
            wp_reset_postdata();
        endif;
        return ( $active_plan->have_posts() ) ? $post : false;
    }
}

if ( ! function_exists( 'listings_data_with_plan' ) ) {
    /**
     * Get the order of current author for ATBDP order table.
     * @param $plan_id
     * @param $user_id
     * @param $featured
     * @return true It returns all the listings under a subscribed plan id.
     */
    function listings_data_with_plan( $user_id, $featured, $plan_id, $order_id = null ) {
        $args = [
            'post_type'      => 'at_biz_dir',
            'posts_per_page' => -1,
            'post_status'    => [ 'publish', 'pending' ],
            'fields'         => 'ids',
            'author'         => $user_id,
        ];

        $meta_queries = [];

        $meta_queries['general'] = [
            'relation' => 'AND',
            [
                'key'     => '_fm_plans',
                'value'   => $plan_id,
                'compare' => '=',
            ],
            [
                'key'     => '_plan_order_id',
                'value'   => $order_id,
                'compare' => '=',
            ],
        ];

        if ( '1' === $featured ) {
            $meta_queries['featured'] = [
                [
                    'key'     => '_featured',
                    'value'   => '1',
                    'compare' => '=',
                ],
            ];
        }

        if ( '0' === $featured ) {
            $meta_queries['non_featured'] = [
                'relation' => 'OR',
                [
                    'key'     => '_featured',
                    'value'   => '',
                    'compare' => '=',
                ],
                [
                    'key'     => '_featured',
                    'value'   => '0',
                    'compare' => '=',
                ],
            ];
        }

        $args['meta_query'] = array_merge( [ 'relation' => 'AND' ], $meta_queries );

        $orders = new WP_Query( $args );

        return ( $orders->post_count ) ? $orders->post_count : false;
    }
}

if ( ! function_exists( 'is_plan_slider_limit' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_slider_limit( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $slider_range     = selected_plan_meta( $selected_plan_id, 'num_image' );
        return ( $slider_range ) ? $slider_range : false;
    }
}

if ( ! function_exists( 'is_plan_allowed_price' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_price( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $fm_allow_price   = selected_plan_meta( $selected_plan_id, 'fm_allow_price' );
        return ( $fm_allow_price ) ? true : false;
    }
}

if ( ! function_exists( 'is_plan_allowed_tag' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_tag( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $fm_allow_tag     = selected_plan_meta( $selected_plan_id, 'fm_allow_tag' );
        return ( $fm_allow_tag ) ? true : false;
    }
}
if ( ! function_exists( 'is_plan_slider_unlimited' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_slider_unlimited( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $slider_range_unl = selected_plan_meta( $selected_plan_id, 'num_image_unl' );
        return ( $slider_range_unl ) ? true : false;
    }
}
if ( ! function_exists( 'is_plan_tag_limit' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_tag_limit( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $tag_range        = selected_plan_meta( $selected_plan_id, 'fm_tag_limit' );
        return ( $tag_range ) ? $tag_range : false;
    }
}
if ( ! function_exists( 'is_plan_price_limit' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_price_limit( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $price_range      = selected_plan_meta( $selected_plan_id, 'price_range' );
        return ( $price_range ) ? $price_range : false;
    }
}
if ( ! function_exists( 'is_plan_tag_unlimited' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_tag_unlimited( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $tag_range_unl    = selected_plan_meta( $selected_plan_id, 'fm_tag_limit_unl' );
        return ( $tag_range_unl ) ? true : false;
    }
}
if ( ! function_exists( 'is_plan_price_unlimited' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_price_unlimited( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $price_range_unl  = selected_plan_meta( $selected_plan_id, 'price_range_unl' );
        return ( $price_range_unl ) ? true : false;
    }
}

if ( ! function_exists( 'is_plan_allowed_slider' ) ) {
    /**
     * It checks is user purchased plan included in that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function is_plan_allowed_slider( $plan_id ) {
        // lets check the plan allowances
        $selected_plan_id = empty( selected_plan_id() ) ? $plan_id : selected_plan_id();
        $fm_allow_slider  = selected_plan_meta( $selected_plan_id, 'fm_allow_slider' );
        return ( $fm_allow_slider ) ? true : false;
    }
}

/**
 * Output a select input box.
 *
 * @param array $field
 * @since    1.0.0
 *
 */
function dwpp_woocommerce_multiselect( $field ) {

    global $thepostid, $post;

    $thepostid              = empty( $thepostid ) ? $post->ID : $thepostid;
    $field['class']         = isset( $field['class'] ) ? $field['class'] : 'select short';
    $field['wrapper_class'] = isset( $field['wrapper_class'] ) ? $field['wrapper_class'] : '';
    $field['name']          = isset( $field['name'] ) ? $field['name'] : $field['id'];
    $field['value']         = isset( $field['value'] ) ? $field['value'] : ( get_post_meta( $thepostid, $field['id'], true ) ? get_post_meta( $thepostid, $field['id'], true ) : [] );

    echo '<p class="form-field ' . esc_attr( $field['id'] ) . '_field ' . esc_attr( $field['wrapper_class'] ) . '"><label for="' . esc_attr( $field['id'] ) . '">' . wp_kses_post( $field['label'] ) . '</label><select id="' . esc_attr( $field['id'] ) . '" name="' . esc_attr( $field['name'] ) . '" class="' . esc_attr( $field['class'] ) . '" multiple="multiple">';

    foreach ( $field['options'] as $key => $value ) {
        echo '<option value="' . esc_attr( $key ) . '" ' . ( in_array( $key, $field['value'] ) ? 'selected="selected"' : '' ) . '>' . esc_html( $value ) . '</option>';
    }

    echo '</select> ';

    if ( ! empty( $field['description'] ) ) {
        if ( isset( $field['desc_tip'] ) && false !== $field['desc_tip'] ) {
            echo '<img class="help_tip" data-tip="' . esc_attr( $field['description'] ) . '" src="' . esc_url( WC()->plugin_url() ) . '/assets/images/help.png" height="16" width="16" />';
        } else {
            echo '<span class="description">' . wp_kses_post( $field['description'] ) . '</span>';
        }
    }

    echo '</p>';

}

if ( ! function_exists( 'directorist_validate_plan' ) ) {
    function directorist_validate_plan( $plan_id, $post_id, $order_id, $listing_type, $user_id = '' ) {
        $error           = [];
        $data            = [];
        $need_payment    = false;
        $activated_order = $order_id;
        $plan_type       = package_or_PPL( $plan_id );
        $user_id         = $user_id ? $user_id : get_current_user_id();

        if ( 'package' === package_or_PPL( $plan_id ) ) {
            $plan_purchased = subscribed_package_or_PPL_plans( $user_id, 'completed', $plan_id );
        } else {
            $plan_purchased = subscribed_package_or_PPL_plans( $user_id, 'completed', $plan_id, $post_id );
        }
        $order      = ! empty( $plan_purchased ) && is_object( $plan_purchased ) ? $plan_purchased[0]->ID : $plan_purchased;

        $order_id = ! empty( $activated_order ) ? $activated_order : $order;

        $remaining = plans_remaining( $plan_id, $order_id );
        $featured  = $remaining['featured'];
        $regular   = $remaining['regular'];

        $package_length = directorist_plan_lifetime( $plan_id );
        $package_length = $package_length ? $package_length : '1';
        // Current time
        $start_date = get_the_date( '', $order_id );
        $expired_date = '';

        if ( directorist_validate_date( $start_date ) ) {
            $date = new DateTime( $start_date );
            $date->add( new DateInterval( "P{$package_length}D" ) ); // set the interval in days
            $expired_date = $date->format( 'Y-m-d H:i:s' );
        }
        
        $current_d      = current_time( 'mysql' );
        $remaining_days = ( $expired_date > $current_d ) ? ( floor( strtotime( $expired_date ) / ( 60 * 60 * 24 ) ) - floor( strtotime( $current_d ) / ( 60 * 60 * 24 ) ) ) : 0; //calculate the number of days remaining in a plan

        $regular_exit  = ( 'Unlimited' !== $regular ) && empty( $regular ) ? true : false;
        $featured_exit = ( 'Unlimited' !== $featured ) && empty( $featured ) ? true : false;

        if (  ( $regular_exit && $featured_exit ) || ( $remaining_days < 0 ) ) {
            $msg = __( 'You have crossed the limit! Please try again', 'directorist-woocommerce-pricing-plans' );
            if (  ( 'pay_per_listng' != $plan_type ) ) {
                update_post_meta( $order_id, '_order_status', 'exit' );
                $need_payment = true;
            }
        } else {
            if (  ( 'regular' === $listing_type ) && ( 'package' === $plan_type ) ) {
                if ( $regular_exit ) {
                    $msg = __( 'You have already crossed your limit for regular listing, please try again.', 'directorist-woocommerce-pricing-plans' );
                    array_push( $error, $msg );
                }
            }

            if (  ( 'featured' === $listing_type ) && ( 'package' === $plan_type ) ) {
                if ( $featured_exit ) {
                    $msg = __( 'You have already crossed your limit for featured listing, please try again', 'directorist-woocommerce-pricing-plans' );
                    array_push( $error, $msg );
                }
            }
        }

        // return $error;

        if ( $error ) {
            $data['error_msg'] = $error;
            $data['error']     = true;
            return $data;
        }

        $skip_payment = false;
        $listing_id   = $post_id;

        $old_plan_id    = get_post_meta( $listing_id, '_fm_plans', true );
        $plan_id        = $plan_id ? $plan_id : $old_plan_id;
        $directory_type = get_post_meta( $listing_id, '_directory_type', true );
        $edit_l_status  = get_term_meta( $directory_type, 'edit_listing_status', true );
        $order_plan     = get_post_meta( $order_id, '_listing_id', true );
        $order_plan     = ! empty( $order_plan ) ? [ $order_plan ] : [];
        
        if( ! empty( $listing_id ) ){
            array_push( $order_plan, $listing_id );
        }

        if ( directorist_direct_purchase() && ( 'package' !== $plan_type ) && empty( $order_plan ) && $plan_purchased ) {
            $skip_payment = true;
            update_post_meta( $order_id, '_listing_id', $order_plan );
        }

        if (  ( 'package' === $plan_type ) && $plan_purchased ) {
            update_post_meta( $order_id, '_listing_id', $order_plan );
        }
        update_post_meta( $listing_id, '_plan_order_id', $order_id );
        update_post_meta( $listing_id, '_listing_order_id', $order_id );
        update_post_meta( $listing_id, '_fm_plans', $plan_id );

        WC()->cart->empty_cart();
		WC()->session->set( 'cart', [] );
		WC()->cart->add_to_cart( directoirst_wc_plan_auto_renewal( $plan_id ) ? directoirst_wc_plan_auto_renewal( $plan_id ) : $plan_id );

        $checkout_url = directorist_wc_checkout_url( $plan_id, $listing_id );

        // return [
        //     'order_id' =>  $order_id,
        //     'need_payment' =>  $need_payment,
        // ];

        if ( ! $order_id || $need_payment ) {
            $data['redirect_url'] = $checkout_url;
            $data['need_payment'] = true;

            wp_update_post( [
                'ID'          => $listing_id,
                'post_status' => 'pending',
            ] );
        }

        wp_update_post( [
            'ID'          => $listing_id,
            'post_status' => $edit_l_status,
            'post_date'   => $current_d,
        ] );

        update_post_meta( $listing_id, '_listing_status', 'post_status' );

        $is_never_expaired = get_post_meta( $plan_id, 'fm_length_unl', true );
        if ( $is_never_expaired ) {
            update_post_meta( $listing_id, '_never_expire', '1' );
        } else {
            update_post_meta( $listing_id, '_never_expire', 0 );
            update_post_meta( $listing_id, '_expiry_date', $expired_date );
        }

        if ( 'featured' == $listing_type ) {
            update_post_meta( $listing_id, '_featured', '1' );
        } else {
            update_post_meta( $listing_id, '_featured', '' );
        }

        update_post_meta( $listing_id, '_need_to_refresh', '1' );
        // for dev
        do_action( 'atbdp_plan_assigned', $listing_id );

        // update the claim status
        $fm_claim = get_post_meta( $plan_id, '_fm_claim', true );
        if ( ! empty( $fm_claim ) ) {
            update_post_meta( $listing_id, '_claimed_by_admin', 1 );
        }

        if ( 'pay_per_listng' === package_or_PPL( $plan_id ) ) {

            if ( PPL_with_featured( $plan_id ) ) {
                update_post_meta( $listing_id, '_featured', '1' );
            }
            // return [
            //     'plan_purchased' => $plan_purchased,
            // ];
            if ( ! $plan_purchased ) {
                wp_update_post( [
                    'ID'          => $listing_id,
                    'post_status' => 'pending',
                ] );
                $data['redirect_url'] = $checkout_url;
                $data['need_payment'] = true;
                return $data;
            }
        }

        // $payment_status = Directorist\Helper::get_listing_payment_status( $listing_id );
        // $rejectable_payment_status = [ 'failed', 'cancelled', 'refunded' ];
        // $need_payment = ( empty( $payment_status ) || in_array( $payment_status, $rejectable_payment_status ) ) ? true : false;

        $payment_status = swbd_get_listing_wc_payment_status( $listing_id );

        $need_payment = in_array( $payment_status, ['pending', 'processing', 'on-hold'] );

        // return [
        //     'payment_status' => $payment_status,
        //     'need_payment' => $need_payment,
        //     'data' => $data,
        // ];

        if ( $need_payment && ! $skip_payment ) {
            $data['redirect_url'] = $checkout_url;
            $data['need_payment'] = true;

            wp_update_post( [
                'ID'          => $listing_id,
                'post_status' => 'pending',
            ] );
        }

        return $data;

    }
}

/**
 * @return boolean      return true means need not to collect money
 * @since 1.4.0
 */
if ( ! function_exists( 'dwpp_need_to_charge_with_plan' ) ) {
    function dwpp_need_to_charge_with_plan() {
        // sanitize form values
        $post_id               = (int) $_POST["post_id"];
        $plan_id               = isset( $_POST["plan_id"] ) ? (int) ( $_POST["plan_id"] ) : '';
        $user_id               = isset( $_POST["user_id"] ) ? (int) ( $_POST["user_id"] ) : get_current_user_id();
        $activated_plan        = subscribed_package_or_PPL_plans( $user_id, 'completed', $plan_id );
        $order_id              = ! empty( $activated_plan ) ? (int) $activated_plan[0]->ID : '';
        $user_featured_listing = listings_data_with_plan( $user_id, '1', $plan_id, $order_id );
        $user_regular_listing  = listings_data_with_plan( $user_id, '0', $plan_id, $order_id );
        $num_regular           = get_post_meta( $plan_id, 'num_regular', true );
        $num_featured          = get_post_meta( $plan_id, 'num_featured', true );
        $featured_listing      = get_post_meta( $plan_id, 'is_featured_listing', true );
        $listing_type          = isset( $_POST["listing_type"] ) ? esc_attr( $_POST["listing_type"] ) : ''; //store the plan meta
        $plan_type             = package_or_PPL( $plan_id );
        // ok lets check is user selected plan is package
        if ( 'package' === $plan_type ) {
            if ( empty( $activated_plan ) ) {
                if ( 'featured' === $listing_type ) {
                    update_post_meta( $post_id, '_need_featured', 1 );
                }
                update_post_meta( $post_id, '_need_to_refresh', 1 );
                //need to collect money form claimer
                return false;
            } else {
                $order_id               = ! empty( $activated_plan ) && is_object( $activated_plan ) ? $activated_plan[0]->ID : $activated_plan;
                $featured               = get_post_meta( $post_id, '_featured', true );
                $total_regular_listing  = $num_regular - ( '0' === $featured ? $user_regular_listing + 1 : $user_regular_listing );
                $total_featured_listing = $num_featured - ( '1' === $featured ? $user_featured_listing + 1 : $user_featured_listing );
                $total_regular_listing  = max( $total_regular_listing, 0 );
                $total_featured_listing = max( $total_featured_listing, 0 );
                $subscribed_date        = get_the_date( '', $order_id );
                $package_length         = get_post_meta( $plan_id, 'fm_length', true );
                $regular_unl            = get_post_meta( $plan_id, 'num_regular_unl', true );
                $featured_unl           = get_post_meta( $plan_id, 'num_featured_unl', true );
                $package_length         = $package_length ? $package_length : '1';
                // Current time
                $start_date = ! empty( $subscribed_date ) ? $subscribed_date : '';
                // Calculate new date
                $date = new DateTime( $start_date );
                $date->add( new DateInterval( "P{$package_length}D" ) ); // set the interval in days
                $expired_date   = $date->format( 'Y-m-d H:i:s' );
                $current_d      = current_time( 'mysql' );
                $remaining_days = ( $expired_date > $current_d ) ? ( floor( strtotime( $expired_date ) / ( 60 * 60 * 24 ) ) - floor( strtotime( $current_d ) / ( 60 * 60 * 24 ) ) ) : 0; //calculate the number of days remaining in a plan
                if (  (  (  ( 0 >= $total_regular_listing ) && empty( $regular_unl ) ) && (  ( 0 >= $total_featured_listing ) ) && empty( $featured_unl ) ) || ( $remaining_days <= 0 ) ) {
                    //if user exit the plan allowance the change the status of that order to cancelled
                    if ( class_exists( 'woocommerce' ) ) {
                        if (  ( 'pay_per_listng' != $plan_type ) ) {
                            $order = new WC_Order( $order_id );
                            $order->update_status( 'cancelled', 'order_note' );
                        }
                    }
                }

                $plan_meta = get_post_meta( $plan_id );

                $data = [];
                $data = [];
                // $data['test'] = (($plan_meta['num_featured'][0] < $total_featured_listing) || (0 === $total_featured_listing));
                // $data['plan_allowed'] = $plan_meta['num_featured'][0];
                // $data['consumed'] = $total_featured_listing;
                // $data['available'] = (int)$plan_meta['num_featured'][0] > (int)$total_featured_listing;
                if (  ( 'regular' === $listing_type ) && ( 'package' === $plan_type ) ) {
                    if (  (  ( $plan_meta['num_regular'][0] < $total_regular_listing ) || ( 0 >= $total_regular_listing ) ) && empty( $plan_meta['num_regular_unl'][0] ) ) {
                        $msg               = __( 'You have already crossed your limit for regular listing, please try again.', 'directorist-woocommerce-pricing-plans' );
                        $data['error_msg'] = $msg;
                    } else {
                        update_post_meta( $post_id, '_featured', '' );
                    }
                }
                if (  ( 'featured' === $listing_type ) && ( 'package' === $plan_type ) ) {
                    if (  (  ( $plan_meta['num_featured'][0] < $total_featured_listing ) || ( 0 === $total_featured_listing ) ) && empty( $plan_meta['num_featured_unl'][0] ) ) {
                        $msg               = __( 'You have already crossed your limit for featured listing, please try again', 'directorist-woocommerce-pricing-plans' );
                        $data['error_msg'] = $msg;
                    } else {
                        update_post_meta( $post_id, '_featured', 1 );
                    }
                }
                if ( $data ) {
                    return $data;
                }

                $new_l_status = get_directorist_option( 'new_listing_status', 'pending' );
                wp_update_post( [
                    'ID'          => $post_id,
                    'post_status' => $new_l_status,
                ] );

                update_post_meta( $post_id, '_plan_order_id', $order_id );
                update_post_meta( $post_id, '_listing_status', 'post_status' );
                update_post_meta( $order_id, '_listing_id', $post_id );
                $package_length = get_post_meta( $plan_id, 'fm_length', true );
                $package_length = $package_length ? $package_length : '1';
                // Current time
                $current_d = current_time( 'mysql' );
                // Calculate new date
                $date = new DateTime( $current_d );
                $date->add( new DateInterval( "P{$package_length}D" ) ); // set the interval in days
                $expired_date      = $date->format( 'Y-m-d H:i:s' );
                $is_never_expaired = get_post_meta( $plan_id, 'fm_length_unl', true );
                if ( $is_never_expaired ) {
                    update_post_meta( $post_id, '_never_expire', '1' );
                } else {
                    update_post_meta( $post_id, '_expiry_date', $expired_date );
                }
                //ok user has change the plan package
                return true;
            }
        } else {
            //pay per listing so collect money
            update_post_meta( $post_id, '_need_to_refresh', 1 );
            if ( ! empty( $featured_listing ) ) {
                update_post_meta( $post_id, '_need_featured', 1 );
            }
            return false;
        }

    }
}

/**
 * @param $order_id     WooCommerce order id
 * @param $plan_id      Order carried the plan
 *
 * @since 1.1.9
 * //get the listings with the order meta '_need_to_refresh' and if found any order referring the same listing. Yep, refresh it
 * @package Directorist
 */
if ( ! function_exists( 'dwpp_need_listing_to_refresh' ) ) {
    function dwpp_need_listing_to_refresh( $user_id = null, $listing_id = null, $order_id = null ) {

        // update listing accordingt to the plan of the iisting
        $plan_id    = get_post_meta( $listing_id, '_fm_plans', true );

        if( ! $plan_id ) {
            return;
        }

        $order_plan = get_post_meta( $order_id, '_fm_plans', true );
        $plan_id    = $plan_id ? $plan_id : $order_plan;
        update_post_meta( $listing_id, '_plan_order_id', $order_id );

        update_post_meta( $order_id, '_fm_plan_ordered', $plan_id );

        update_post_meta( $order_id, '_listing_id', $listing_id );
        update_post_meta( $listing_id, '_listing_status', 'post_status' );
        $package_length = get_post_meta( $plan_id, 'fm_length', true );
        $package_length = $package_length ? $package_length : '1';
        // Current time
        $current_d = current_time( 'mysql' );
        // Calculate new date
        $date = new DateTime( $current_d );
        $date->add( new DateInterval( "P{$package_length}D" ) ); // set the interval in days
        $expired_date      = $date->format( 'Y-m-d H:i:s' );
        $is_never_expaired = get_post_meta( $plan_id, 'fm_length_unl', true );
        if ( $is_never_expaired ) {
            update_post_meta( $listing_id, '_never_expire', '1' );
        } else {
            update_post_meta( $listing_id, '_expiry_date', $expired_date );
        }
        $new_l_status = get_directorist_option( 'new_listing_status', 'pending' );
        // wp_update_post(array(
        //     'ID'    =>  $listing_id,
        //     'post_status'   =>  $new_l_status,
        //     ));

        $token_refresh = get_post_meta( $listing_id, '_refresh_renewal_token', true );
        if ( $token_refresh ) {
            update_post_meta( $listing_id, '_refresh_renewal_token', 0 );
            update_post_meta( $listing_id, '_renewal_token', 0 );
        }

        $featured_listing = get_post_meta( $listing_id, '_need_featured', true );
        if ( ! empty( $featured_listing ) || PPL_with_featured( $plan_id ) ) {
            update_post_meta( $listing_id, '_featured', 1 );
        }

    }
}

if ( ! function_exists( 'dwpp_get_used_free_plan' ) ) {
    function dwpp_get_used_free_plan( $plan_id, $user_id ) {
        if ( ! $user_id ) {
            return true;
        }

        $used_free_plan = get_user_meta( get_current_user_id(), '_used_free_plan', true );
        $plan           = ! empty( $used_free_plan ) ? (int) $used_free_plan[0] : '';
        if ( $plan === $plan_id ) {
            $list_status = get_post_status( $used_free_plan[1] );
            if (  ( 'trash' === $list_status ) || ! $list_status ) {
                return true;
            } else {
                return false;
            }
        } else {
            return true;
        }

    }
}

function dwpp_create_required_pages() {
    $options     = get_option( 'atbdp_option' );
    $page_exists = get_option( 'atbdp_plan_page_create' );
    // $op_name is the page option name in the database.
    // if we do not have the page id assigned in the settings with the given page option name, then create an page
    // and update the option.
    $id = [];
    if ( ! $page_exists ) {
        $id = wp_insert_post(
            [
                'post_title'     => 'Select Your Plan',
                'post_content'   => '[directorist_pricing_plans]',
                'post_status'    => 'publish',
                'post_type'      => 'page',
                'comment_status' => 'closed',
            ]
        );
    }
    // if we have new options then lets update the options with new option values.
    if ( $id ) {
        update_option( 'atbdp_plan_page_create', 1 );
        $options['pricing_plans'] = (int) $id;
        update_option( 'atbdp_option', $options );

    }
    ;
}
/**
 * @since 1.3.9
 * @param init $listing_id
 * @return bool true | false
 */
if ( ! function_exists( 'has_plan' ) ) {
    function has_plan( $listing_id ) {
        $plan   = get_post_meta( $listing_id, '_fm_plans', true );
        $result = ( empty( $plan ) || ( 'null' === $plan ) ) ? false : true;
        return $result;
    }
}

/**
 * @since 1.7.5
 */

if ( ! function_exists( 'plans_remaining' ) ) {
    function plans_remaining( $plan_id = '', $order_id = '' ) {

        $data = [];
        if ( ! $plan_id ) {return '';}
        $user_id = isset( $_POST['user_id'] ) ? $_POST['user_id'] : get_current_user_id();

        $num_regular      = get_post_meta( $plan_id, 'num_regular', true );
        $num_featured     = get_post_meta( $plan_id, 'num_featured', true );
        $num_featured_unl = get_post_meta( $plan_id, 'num_featured_unl', true );
        $num_regular_unl  = get_post_meta( $plan_id, 'num_regular_unl', true );

        $user_featured_listing = listings_data_with_plan( $user_id, '1', $plan_id, $order_id );
        $user_regular_listing  = listings_data_with_plan( $user_id, '0', $plan_id, $order_id );

        // $data = [
        //     'regular'   => $user_regular_listing,
        //     'featured'  => $user_featured_listing,
        // ];
        // return $data;
        // var_dump([
        //     'featured' => $user_featured_listing,
        //     'regular' => $user_regular_listing,
        //     'user_id' => $user_id,
        //     'plan_id' => $plan_id,
        //     'order_id' => $order_id,
        // ]);

        $total_regular_listing  = (int)$num_regular - (int)$user_regular_listing;
        $total_featured_listing = (int)$num_featured - (int)$user_featured_listing;
        $total_regular_listing  = max( $total_regular_listing, 0 );
        $total_featured_listing = max( $total_featured_listing, 0 );

        if ( ! $num_regular_unl ) {
            $regular = $total_regular_listing;
        } else {
            $regular = 'Unlimited';
        }

        if ( ! $num_featured_unl ) {
            $featured = $total_featured_listing;
        } else {
            $featured = 'Unlimited';
        }

        $data = [
            'regular'  => $regular,
            'featured' => $featured,
        ];

        return apply_filters( 'directorist_plan_remaining', $data );
    }
}

if ( ! function_exists( 'public_plans' ) ) {
    function public_plans() {
        global $product;
        $meta_queries = [];
        $query_args   = [
            'post_type'      => 'product',
            'posts_per_page' => -1,
            'tax_query'      => [
                [
                    'taxonomy' => 'product_type',
                    'field'    => 'slug',
                    'terms'    => 'listing_pricing_plans',
                ],
            ],
        ];
        $meta_queries[] = [
            'relation' => 'OR',
            [
                'key'     => '_hide_from_plans',
                'compare' => 'NOT EXISTS',
            ],
            [
                'key'     => '_hide_from_plans',
                'value'   => 1,
                'compare' => '!=',
            ],
        ];

        $meta_queries       = apply_filters( 'atbdp_plan_meta_query', $meta_queries );
        $count_meta_queries = count( $meta_queries );
        if ( $count_meta_queries ) {
            $query_args['meta_query'] = ( $count_meta_queries > 1 ) ? array_merge( [ 'relation' => 'AND' ], $meta_queries ) : $meta_queries;
        }
        $atbdp_query = new WP_Query( $query_args );
        if ( $atbdp_query->have_posts() ) {
            return $atbdp_query->posts;
        } else {
            return [];
        }
    }
}

// dwpp_get_template
function dwpp_get_template( $template_file, $args = [] ) {
    if ( is_array( $args ) ) {
        extract( $args );
    }

    $theme_template  = '/directorist-woocommerce-pricing-plans/' . $template_file . '.php';
    $plugin_template = DWPP_TEMPLATES_DIR . $template_file . '.php';

    if ( file_exists( get_stylesheet_directory() . $theme_template ) ) {
        $file = get_stylesheet_directory() . $theme_template;
    } elseif ( file_exists( get_template_directory() . $theme_template ) ) {
        $file = get_template_directory() . $theme_template;
    } else {
        $file = $plugin_template;
    }

    if ( file_exists( $file ) ) {
        include $file;
    }
}

function dwpp_add_listing_page_link_with_plan( $plan_id, $active_order, $active_plan ) {

    $active_orders = directorist_active_orders( $plan_id );
    if ( count( $active_orders ) > 1 ) {

        foreach ( $active_orders as $order ) {
            $valid_order = directorist_valid_order( $order, $plan_id );
            if ( ! $valid_order ) {

                $active_orders = array_diff( $active_orders, [$order] );
            }
        }
    }

    $order_id = ! empty( $active_orders[0] ) ? $active_orders[0] : '';

    if( directoirst_wc_plan_auto_renewal( $plan_id ) ) {
        $subscription_plan_id = directoirst_wc_plan_auto_renewal( $plan_id );
        $active_subscription = wcs_get_subscriptions([
            'customer_id' => get_current_user_id(),
            'product_id'  => $subscription_plan_id,
            'subscription_status'  => 'active',
        ]);

        if ( $active_subscription ) {

            $order_id = wp_get_post_parent_id( array_key_first( $active_subscription ) );

        }
        
    }

    $link     = home_url();
    $id       = get_directorist_option( 'add_listing_page' );
    if ( $id ) {
        $args = [
            'directory_type' => isset( $_GET['directory_type'] ) ? $_GET['directory_type'] : default_directory_type(),
            'plan'           => $plan_id,
        ];

        if ( ! empty( $order_id ) && ( 'pay_per_listng' !== package_or_PPL( $plan_id ) ) ) {
            $args['order'] = $order_id;
        }

        if ( directorist_direct_purchase() && ! $active_plan ) {
            return directorist_wc_checkout_url( $plan_id );
        } else {
            $link = get_permalink( $id );
        }

        $link = add_query_arg( $args, $link );

    }

    return apply_filters( 'atbdp_add_listing_page_url', $link );
}

function directorist_direct_purchase() {
    $direct_purchase = get_directorist_option( 'plan_direct_purchase', false );
    return apply_filters( 'directorist_direct_purchase', $direct_purchase );
}

function directorist_plans_dashboard_data( $data = 'package' ) {
    $user_id = get_current_user_id();
    if ( ! class_exists( 'WooCommerce' ) ) {
        return false;
    }

    $filters = [
        'post_type'   => 'shop_order',
        'post_status' => 'any',
        'numberposts' => -1,
        'meta_query'  => [
            'relation' => 'AND',
            [
                'key'     => '_customer_user',
                'value'   => $user_id,
                'compare' => '=',
            ],
            [
                'key'     => '_fm_plan_ordered',
                'compare' => 'EXISTS',
            ],
        ],
    ];

    $loop = new WP_Query( $filters );
    if ( 'package' === $data ) {
        return $loop;
    }
    $plan_type              = [];
    $all_order_ids          = [];
    $subscribed_package_ids = [];
    $order_data             = [];
    while ( $loop->have_posts() ) {
        $loop->the_post();
        $all_order_ids[] = $loop->post->ID;
        $order           = new WC_Order( $loop->post->ID );
        foreach ( $order->get_items() as $key => $lineItem ) {

            $order_data[]          = $lineItem->get_data();
            $subscribed_package_id = $lineItem->get_data()['product_id'];
            $plan_type[]           = get_post_meta( $subscribed_package_id, 'plan_type', true );
            array_push( $subscribed_package_ids, $subscribed_package_id );
        }
    }
    wp_reset_postdata();

    if ( 'order_ids' === $data ) {
        return $all_order_ids;
    }

    if ( 'package_ids' === $data ) {
        return $subscribed_package_ids;
    }
}

if ( ! function_exists( 'atbdp_plan_allows_booking' ) ) {
    /**
     * It checks is user activated booking and is the purchased plan included that feature.
     * @return bool It returns true if the above mentioned exists.
     */
    function atbdp_plan_allows_booking( $plan_id = '' ) {
        // Check if Booking is activated
        if ( ! class_exists( 'BD_Booking' ) ) {return false;}

        // lets check the plan allowances
        $selected_plan_id = ! empty( $plan_id ) ? $plan_id : selected_plan_id();
        $booking          = selected_plan_meta( $selected_plan_id, '_fm_booking' );

        return $booking;
    }
}

function directorist_active_orders_without_listing( $plan_id = '', $order_statuses = '' ) {
    $status = [ "wc-completed", "wc-processing" ];
    $args = [
        'post_type'   => 'shop_order',
        'post_status' => $status,
        'numberposts' => -1,
        'fields'      => 'ids',
        'meta_query'  => [
            'relation' => 'AND',
            [
                'key'     => '_fm_plan_ordered',
                'value'   => $plan_id,
                'compare' => '=',
            ],
            [
                'key'     => '_customer_user',
                'value'   => get_current_user_id(),
                'compare' => '=',
            ],
            [
                'relation' => 'OR',
                [
                    'key'     => '_listing_id',
                    'value'   => '0',
                    'compare' => '=',
                ],
                [
                    'key'     => '_listing_id',
                    'value'   => '',
                    'compare' => '=',
                ],
            ],
        ],
    ];

    $active_plan = new WP_Query( $args );

    return $active_plan->have_posts();
}

if ( ! class_exists( 'directorist_plan_lifetime' ) ) {
    function directorist_plan_lifetime( $plan_id ) {

        $lifetime = get_post_meta( $plan_id, 'fm_length', true );
        $subscription_plan = directoirst_wc_plan_auto_renewal( $plan_id );
        if( $subscription_plan ) {
            
            $fm_length          = get_post_meta( $subscription_plan, '_subscription_period_interval', true );
            $recurrence_period  = get_post_meta( $subscription_plan, '_subscription_period', true );

            switch ( $recurrence_period ) {
                case ( 'month' ):
                    $lifetime = $fm_length * 30;
                    break;
        
                case ( 'year' ):
                    $lifetime = $fm_length * 365;
                    break;
        
                case ( 'week' ):
                    $lifetime = $fm_length * 7;
                    break;
        
                case ( 'day' ):
                    $lifetime = $fm_length;
                    break;
        
                default:
                    $lifetime = $fm_length;
                }
        }

        return (int) $lifetime;
    }
}

function directoirst_wc_plan_auto_renewal( $plan_id ) {
    $recurring = get_post_meta( $plan_id, '_enable_subscription', true );
    $linked_subscription = get_post_meta( $plan_id, '_linked_subscription', true );

    if( $recurring && $linked_subscription ) {
        return $linked_subscription;
    }

    return false;
}

if ( ! function_exists( 'directorist_active_orders' ) ) {
    function directorist_active_orders( $plan_id = '', $user_id = '' ) {

        // update_post_meta( '211', '_order_status', '');

        $user_id = $user_id ? $user_id : get_current_user_id();
        if ( empty( $user_id ) ) {
            return [];
        }
        $status = [ "wc-completed", "wc-processing" ];

        $args = [
            'post_type'   => 'shop_order',
            'post_status' => $status,
            'numberposts' => -1,
            'fields'      => 'ids',
        ];

        $meta = [];

        $meta['plan_status'] = [
            'relation' => 'AND',
            [
                'key'     => '_fm_plan_ordered',
                'value'   => $plan_id,
                'compare' => '=',
            ],
            [
                'key'     => '_customer_user',
                'value'   => $user_id,
                'compare' => '=',
            ],
        ];

        // $meta['order_status'] = [
        //     'relation' => 'OR',
        //     array(
        //         'key' => '_order_status',
        //         'value' => 'exit',
        //         'compare' => '!=',
        //     ),
        //     array(
        //         'key' => '_order_status',
        //         'compare' => 'NOT EXISTS',
        //     ),
        // ];

        $metas = count( $meta );
        if ( $metas ) {
            $args['meta_query'] = ( $metas > 1 ) ? array_merge( [ 'relation' => 'AND' ], $meta ) : $meta;
        }

        $orders = new WP_Query( $args );

        if ( $orders->have_posts() ) {
            return $orders->posts;
        } else {
            return [];
        }
    }
}

if ( ! function_exists( 'directorist_wc_checkout_url' ) ) {

    function directorist_wc_checkout_url( $plan_id, $listing_id = '' ) {

        if( ! is_admin() ){
            WC()->cart->empty_cart();
            WC()->session->set( 'cart', [] );
            WC()->cart->add_to_cart( directoirst_wc_plan_auto_renewal( $plan_id ) ? directoirst_wc_plan_auto_renewal( $plan_id ) : $plan_id );
        }

        $checkout_url = wc_get_checkout_url();

        if ( ! empty( $listing_id ) ) {
            $checkout_url = add_query_arg( [ 'atbdp_listing_id' => $listing_id, 'plan' => $plan_id  ], wc_get_checkout_url() );
        }

        return $checkout_url;
    }
}

if ( ! function_exists( 'directorist_valid_order' ) ) {

    function directorist_valid_order( $order_id, $plan_id ) {
        $balance  = plans_remaining( $plan_id, $order_id );
        $featured = ! empty( $balance['featured'] ) ? $balance['featured'] : '';
        $regular  = ! empty( $balance['regular'] ) ? $balance['regular'] : '';

        if ( empty( $featured ) && empty( $regular ) ) {
            return false;
        }

        return true;
    }
}

if ( ! function_exists( 'directorist_validate_date' ) ) {

    function directorist_validate_date( $str ) {

        if ( ! is_string( $str ) ) {
            return false;
        }

        $stamp = strtotime( $str );

        if ( ! is_numeric( $stamp ) ) {
            return false;
        }

        if ( checkdate( date( 'm', $stamp ), date( 'd', $stamp ), date( 'Y', $stamp ) ) ) {
            return true;
        }
        return false;
    }
}

if ( ! function_exists( 'directorist_recurring_plans' ) ) {
    function directorist_recurring_plans() {
        $args = [
            'post_type'      => 'product',
            'posts_per_page' => -1,
            'status'         => 'publish',
            'meta_key'       => '_enable_subscription',
            'meta_value'     => 'yes',
            'fields'         => 'ids',
            'tax_query'      => [
                [
                    'taxonomy' => 'product_type',
                    'field'    => 'slug',
                    'terms'    => 'listing_pricing_plans',
                ],
            ],
        ];

        $atbdp_query = new WP_Query( $args );
        if ( $atbdp_query->have_posts() ) {
            return $atbdp_query->posts;
        } else {
            return [];
        }
    }
}

/**
 * @3.1.4
 * @return string Icon with HTML element
 */

if( ! function_exists( 'directorist_plan_features' ) ) {
    function directorist_plan_features( $features ) {
        $icon  = $features ? 'fas fa-check' : 'fas fa-times';
        $class = $features ? 'directorist_green' : 'directorist_red';
        return directorist_icon( $icon, true, $class );
    }
}