<?php
defined('ABSPATH') || die('Direct access is not allowed.');
/**
 * @since 3.0
 * @package Directorist
 */
if (!class_exists('Directorist_Subscription')) :

    class Directorist_Subscription
    {
        public function __construct()
        {
            add_action( 'woocommerce_checkout_subscription_created', [ $this, 'woocommerce_checkout_subscription_created' ], 10, 3 );
            add_action( 'woocommerce_subscription_status_changed', [ $this, 'woocommerce_subscription_status_changed' ], 10, 4 );
            add_action( 'woocommerce_scheduled_subscription_trial_end', [ $this, 'woocommerce_scheduled_subscription_trial_end' ] );

            add_filter( 'directorist_update_listings_expired_status_query_arguments', [ $this, 'update_expired_listings'] );
        }

        public function woocommerce_scheduled_subscription_trial_end( $subscription_id ) {
            $sub_boject  = wcs_get_subscription( $subscription_id );
            $listing_ids = get_post_meta( $subscription_id, '_listing_id', true );

            if( $sub_boject ) {
                $status = $sub_boject->get_status();
                if( 'active' !== $status ) {
                    $this->failed( $listing_ids );
                }
            }
        }

        public function woocommerce_subscription_status_changed( $id, $old_status, $new_status, $subscription ) {
            
            $listing_ids = get_post_meta( $id, '_listing_id', true );

            if( 'active' === $old_status ) {
                $this->failed( $listing_ids );
            }
            if( 'active' === $new_status && 'pending' !== $old_status ) {
                $this->paid( $listing_ids );
            }

        }

        public function woocommerce_checkout_subscription_created( $subscription, $order, $recurring_cart ) {

            // update the subscription for the first time order
            $order_items = $subscription->get_items();
            $subscription_id = $subscription->get_id();
            $parent_order_id = $subscription->get_parent_id();
            $listing_id    = get_post_meta( $parent_order_id, '_listing_id', true );
            // Loop through order items
            foreach ( $order_items as $item_id => $item ) {
                // To get the subscription variable product ID and simple subscription  product ID
                $product_id = $item->get_product_id();
                break;
            }

            $linked_plan = get_post_meta( $product_id, '_linked_pricing_plan', true );
            update_post_meta( $parent_order_id, '_linked_subscription', $subscription_id );
            update_post_meta( $subscription_id, '_linked_pricing_plan', $linked_plan );
            update_post_meta( $subscription_id, '_listing_id', [ $listing_id ] );

        }

        private function failed( $listing_ids ){
            $current_d = current_time('mysql');
            foreach( $listing_ids as $listing_id ) {
                
                update_post_meta($listing_id, '_listing_status', 'expired');

                wp_update_post(array(
                    'ID'            =>  $listing_id,
                    'post_status'   =>  apply_filters( 'directorist_auto_renewed_failed_listing_status', 'private', $listing_id ),
                ));
            }
            
        }

        private function paid( $listing_ids ){
            
            foreach( $listing_ids as $listing_id ) {

                update_post_meta($listing_id, '_listing_status', 'post_status');

                update_post_meta($listing_id, '_renewal_reminder_sent', '');

                $plan_id =  get_post_meta($listing_id, '_fm_plans', true);
                $package_length = directorist_plan_lifetime( $plan_id );
                $package_length = $package_length ? $package_length : '1';

                $current_d = current_time('mysql');
                $date = new DateTime($current_d);
                $date->add(new DateInterval("P{$package_length}D")); // set the interval in days
                $expired_date = $date->format('Y-m-d H:i:s');
                $is_never_expaired = get_post_meta($plan_id, 'fm_length_unl', true);

                if ($is_never_expaired) {
                    update_post_meta($listing_id, '_never_expire', '1');
                } else {
                    update_post_meta($listing_id, '_expiry_date', $expired_date);
                }

                wp_update_post(array(
                    'ID'            =>  $listing_id,
                    'post_status'   =>  apply_filters( 'directorist_auto_renewed_success_listing_status', 'publish', $listing_id ),
                ));
            }
        }

    }
endif;