<?php
/*
 * Class: Business Directory Multiple Image = DWPP
 * */
if (!class_exists('DWPP_Settings')) :
    class DWPP_Settings
    {
        public function __construct()
        {
            add_filter('atbdp_license_settings_controls', array($this, 'dwpp_license_settings_controls'));
            add_filter('atbdp_dashboard_field_setting', array($this, 'dwpp_settings_to_ext_general_fields'));

            add_filter( 'atbdp_listing_type_settings_field_list', array( $this, 'atbdp_listing_type_settings_field_list' ) );
            add_filter( 'atbdp_extension_fields', array( $this, 'atbdp_extension_fields' ) );
            add_filter( 'atbdp_pages_settings_fields', array( $this, 'atbdp_pages_settings_fields' ) );
            add_filter( 'atbdp_extension_settings_submenu', array( $this, 'atbdp_extension_settings_submenus' ) );
            add_filter( 'atbdp_monetization_settings_submenu', array( $this, 'atbdp_listing_settings_monetization_general_sections' ) );
        }

        public function atbdp_listing_type_settings_field_list( $pricing_fields ) {
            $pricing_fields['woo_pricing_plans_enable'] = [
                'label'             => __('WooCommerce Pricing Plans', 'directorist-woocommerce-pricing-plans'),
                'type'              => 'toggle',
                'value'             => true,
                'description'       => __('You can disable it for users.', 'directorist-woocommerce-pricing-plans'),
            ];
            $pricing_fields['skip_plan_page'] = [
                'label'             => __( 'Skip Plan Page for Paid Users', 'directorist-woocommerce-pricing-plans' ),
                'type'              => 'toggle',
                'value'             => false,
            ];
            $pricing_fields['plan_direct_purchase'] = [
                'type'              => 'toggle',
                'label'             => __('Direct Plan Purchase', 'directorist-woocommerce-pricing-plans'),
                'value'             => false,
            ];
            $pricing_fields['restrict_listing_deletion'] = [
                'type'              => 'toggle',
                'label'             => __('Restrict Listing Deletion', 'directorist-woocommerce-pricing-plans'),
                'description'       => __('User can\'t delete their listing if the listing is assigned with a plan.', 'directorist-woocommerce-pricing-plans'),
                'value'             => true,
            ];
            $pricing_fields['pricing_plans'] = [
                'label'             => __('Pricing Plans Page', 'directorist-woocommerce-pricing-plans'),
                'type'              => 'select',
                'description'       => sprintf(__('Following shortcode must be in the selected page %s', 'directorist-woocommerce-pricing-plans'), '<strong style="color: #ff4500;">[directorist_pricing_plans]</strong>'),
                'value'             => atbdp_get_option('pricing_plans', 'atbdp_general'),
                'showDefaultOption' => true,
                'options'           => $this->get_pages_vl_arrays(),
            ];
            
            return $pricing_fields;
        }

        public function atbdp_extension_settings_submenus( $submenu ) {
            $submenu['pricing_plan_submenu'] = [
                'label' => __('Pricing Plans', 'directorist-woocommerce-pricing-plans'),
                'icon' => '<i class="fa fa-money-check-alt"></i>',
                'sections' => apply_filters( 'atbdp_woo_pricing_plan_settings_controls', [
                    'general_section' => [
                        'title' => __('Pricing Plans Settings', 'directorist-woocommerce-pricing-plans'),
                        'description' => __('You can Customize all the settings of Pricing Plans Extension here', 'directorist-woocommerce-pricing-plans'),
                        'fields'      =>  [ 'skip_plan_page', 'plan_direct_purchase', 'restrict_listing_deletion' ],
                    ],
                ] ),
            ];
    
            return $submenu;
        }

        public function atbdp_listing_settings_monetization_general_sections( $sections )
        {
            if( get_directorist_option( 'enable_featured_listing' ) ){

                $options = get_option('atbdp_option');
                
                $options['enable_featured_listing'] = '';
                update_option('atbdp_option', $options);
                
            }
            
            unset($sections['featured_listings']);
            return $sections;
        }

        public function atbdp_extension_fields(  $fields ) {
            $fields[] = ['woo_pricing_plans_enable'];
            return $fields;
        }

        public function atbdp_pages_settings_fields(  $fields ) {
            $fields[] = ['pricing_plans'];
            return $fields;
        }

         /**
         * @since 1.1.2
         */
        public function dwpp_settings_to_ext_general_fields($settings_submenus)
        {
            /*lets add a submenu of our extension*/

            $setting1 = array(
                'type' => 'toggle',
                'name' => 'user_active_package',
                'label' => __('Display Packages Tab', 'directorist-woocommerce-pricing-plans'),
                'default' => 1,
            );
            $setting2 = array(
                'type' => 'toggle',
                'name' => 'user_order_history',
                'label' => __('Display Order History Tab', 'directorist-woocommerce-pricing-plans'),
                'default' => 1,
            );
            $setting3 = array(
                'type' => 'toggle',
                'name' => 'change_plan',
                'label' => __('Display Plan Change Link', 'directorist-woocommerce-pricing-plans'),
                'default' => 1,
            );

            array_push($settings_submenus, $setting1, $setting2, $setting3);
            return $settings_submenus;
        }

        public function dwpp_license_settings_controls($default)
        {
            $status = get_option('directorist_woo_pricing_license_status');
            if (!empty($status) && ($status !== false && $status == 'valid')) {
                $action = array(
                    'type' => 'toggle',
                    'name' => 'woo_pricing_deactivated',
                    'label' => __('Action', 'directorist-woocommerce-pricing-plans'),
                    'validation' => 'numeric',
                );
            } else {
                $action = array(
                    'type' => 'toggle',
                    'name' => 'woo_pricing_activated',
                    'label' => __('Action', 'directorist-woocommerce-pricing-plans'),
                    'validation' => 'numeric',
                );
            }
            $new = apply_filters('atbdp_woo_pricing_license_controls', array(
                'type' => 'section',
                'title' => __('WooCommerce Pricing Plans', 'directorist-woocommerce-pricing-plans'),
                'description' => __('You can active your Pricing Plans extension here.', 'directorist-woocommerce-pricing-plans'),
                'fields' => apply_filters('atbdp_woo_pricing_license_settings_field', array(
                    array(
                        'type' => 'textbox',
                        'name' => 'woo_pricing_license',
                        'label' => __('License', 'directorist-woocommerce-pricing-plans'),
                        'description' => __('Enter your Pricing Plans extension license', 'directorist-woocommerce-pricing-plans'),
                        'default' => '',
                    ),
                    $action
                )),
            ));
            $settings = apply_filters('atbdp_licence_menu_for_woo_pricing_plans', true);
            if ($settings) {
                array_push($default, $new);
            }
            return $default;
        }


    function get_pages_vl_arrays()
    {
        $pages = get_pages();
        $pages_options = array();
        if ($pages) {
            foreach ($pages as $page) {
                $pages_options[] = array('value' => $page->ID, 'label' => $page->post_title);
            }
        }

        return $pages_options;
    }
    }
endif;