<?php
defined('ABSPATH') || die('Direct access is not allowed.');
/**
 * @since 1.7.4
 * @package Directorist
 */
if (!class_exists('DWPP_Ajax_Handler')) :

    class DWPP_Ajax_Handler
    {
        public function __construct()
        {
            add_action('wp_ajax_dwpp_submit_changing_plan', array($this, 'dwpp_submit_changing_plan'));
            add_action('wp_ajax_nopriv_dwpp_submit_changing_plan', array($this, 'dwpp_submit_changing_plan'));
            add_action('wp_ajax_plan_allowances', array($this, 'plan_allowances'));
            add_action('wp_ajax_nopriv_plan_allowances', array($this, 'plan_allowances'));
            add_action('wp_ajax_plan_allowances_on_user_selection', array($this, 'plan_allowances_on_user_selection'));

            add_action('wp_ajax_dynamic_admin_listing_form_and_allowances', array($this, 'dynamic_admin_listing_form_and_allowances'));
            add_action('wp_ajax_atpp_gifting_plan', array($this, 'atpp_gifting_plan'));

            add_action( 'wp_ajax_directorist_plan_dynamic_fields', array( $this, 'directorist_plan_dynamic_fields' ) );

            add_action( 'wp_ajax_dwpp_changing_plan', array( $this, 'dwpp_changing_plan' ) );
            add_action( 'wp_ajax_atbdp_dynamic_plan', array( $this, 'atbdp_dynamic_plan' ) );

            add_action( 'wp_ajax_select_active_order', array( $this, 'select_active_order' ) );
            add_action( 'wp_ajax_nopriv_select_active_order', array( $this, 'select_active_order' ) );

            add_action( 'wp_ajax_guest_customer', array( $this, 'guest_customer' ) );
            add_action( 'wp_ajax_nopriv_guest_customer', array( $this, 'guest_customer' ) );

            add_action( 'wp_ajax_plan_direct_purchase', array( $this, 'plan_direct_purchase' ) );

        }

        public function plan_direct_purchase(){

            $plan_id    = !empty( $_POST['plan_id'] ) ? $_POST['plan_id'] : '';
            $data['error'] = false;

            if( ! empty( $plan_id ) ){
				WC()->cart->empty_cart();
            	WC()->session->set( 'cart', [] );
                WC()->cart->add_to_cart( directoirst_wc_plan_auto_renewal( $plan_id ) ? directoirst_wc_plan_auto_renewal( $plan_id ) : $plan_id );
				$checkout_url = wc_get_checkout_url();
                $data['redirect_url'] = $checkout_url;
            }
            
            wp_send_json( $data );
        }
        public function guest_customer(){

            $email      = !empty( $_POST['email'] ) ? $_POST['email'] : '';
            $plan_id    = !empty( $_POST['plan_id'] ) ? $_POST['plan_id'] : '';
            $data['error'] = false;

            if( ! empty( $email ) ){
                $response = atbdp_guest_submission( $email );
                if( ! empty( $response['error'] ) ){

                    wp_send_json( $response );

                }else{

                    WC()->cart->empty_cart();
                    WC()->session->set( 'cart', [] );
                    WC()->cart->add_to_cart( directoirst_wc_plan_auto_renewal( $plan_id ) ? directoirst_wc_plan_auto_renewal( $plan_id ) : $plan_id );

                    $data['redirect_url'] = directorist_wc_checkout_url( $plan_id );

                    wp_send_json( $data );
                }
            }else{
                $data['error'] = true;
                $data['error_msg'] = __( 'Email is required', 'directorist-woocommerce-pricing-plans' );

            }
            wp_send_json( $data );
        }

        public function select_active_order(){

            $plan_id        = !empty( $_POST['plan_id'] ) ? $_POST['plan_id'] : '';
            $order_id       = !empty( $_POST['order_id'] ) ? $_POST['order_id'] : '';
            $general_label  = !empty( $_POST['general_label'] ) ? $_POST['general_label'] : '';
            $featured_label = !empty( $_POST['featured_label'] ) ? $_POST['featured_label'] : '';
            $label          = !empty( $_POST['label'] ) ? $_POST['label'] : '';

            $remaining  = plans_remaining( $plan_id, $order_id );
            $featured   = $remaining['featured'];
            $regular    = $remaining['regular'];

            // let's update order status
            $regular_exit       = ( 'Unlimited' !== $regular ) && empty( $regular ) ? true : false;
            $featured_exit      = ( 'Unlimited' !== $featured ) && empty( $featured ) ? true : false;

            if( $regular_exit && $featured_exit ){
                update_post_meta( $order_id, '_order_status', 'exit' );
            }

            ob_start();

            ?>
            <div class="directorist-listing-type dpp-selected-order-listing-type">
                <h4 class="directorist-option-title"><?php echo esc_attr( $label ); ?></h4>
                <input type="hidden" name="activated_order" value="<?php echo esc_attr( $order_id ); ?>">
                <div class="directorist-listing-type_list">
                    <?php
                    if ( 'Unlimited' === $regular ) {
                    ?>
                        <div class="directorist-input-group --atbdp_inline">
                            <input id="regular" type="radio" class="atbdp_radio_input" name="listing_type" value="regular" checked>
                            <label for="regular"><?php echo esc_attr( $general_label ); ?>
                                <span class="atbdp_make_str_green"><?php _e(" (Unlimited)", 'directorist-woocommerce-pricing-plans') ?></span>
                            </label>
                        </div>
                    <?php } else { ?>
                        <div class="directorist-input-group --atbdp_inline">
                            <input id="regular" type="radio" class="atbdp_radio_input" name="listing_type" value="regular" checked>
                            <label for="regular"><?php echo esc_attr( $general_label ); ?>
                                <span class="<?php echo $regular > 0 ? 'atbdp_make_str_green' : 'atbdp_make_str_red' ?>">
                                    <?php echo '(' . $regular . __(' Remaining', 'directorist-woocommerce-pricing-plans') . ')'; ?></span>
                            </label>
                        </div>
                    <?php } ?>

                    <?php
                    if ( 'Unlimited' === $featured ) {
                    ?>
                        <div class="directorist-input-group --atbdp_inline">
                            <input id="featured" type="radio" class="atbdp_radio_input" name="listing_type" value="featured">
                            <label for="featured" class="featured_listing_type_select">
                                <?php echo esc_attr( $featured_label ); ?>
                                <span class="atbdp_make_str_green"><?php _e(" (Unlimited)", 'directorist-woocommerce-pricing-plans') ?></span>
                            </label>
                        </div>
                    <?php
                    } else { ?>
                        <div class="directorist-input-group --atbdp_inline">
                            <input id="featured" type="radio" class="atbdp_radio_input" name="listing_type" value="featured">
                            <label for="featured" class="featured_listing_type_select">
                                <?php echo esc_attr( $featured_label ); ?>
                                <span class="<?php echo $featured > 0 ? 'atbdp_make_str_green' : 'atbdp_make_str_red' ?>">
                                    <?php echo '(' . $featured . __(' Remaining', 'directorist-woocommerce-pricing-plans') . ')'; ?></span>
                            </label>
                        </div>
                    <?php } ?>
                </div>
            </div>

            <?php

            $response = ob_get_clean();
            wp_send_json( $response );
        }

        public function atbdp_dynamic_plan() {
            $directory_type = isset( $_POST['directory_type'] ) ? $_POST['directory_type'] : '';
            $listing_id     = isset( $_POST['listing_id'] ) ? $_POST['listing_id'] : '';
            $user_id        = isset( $_POST['user_id'] ) ? $_POST['user_id'] : '';
            $current_val    = get_post_meta( $listing_id, '_fm_plans', true );

            $meta_queries = array();
            $args = array(
                'post_type' => 'product',
                'tax_query' => array(
                    array(
                        'taxonomy' => 'product_type',
                        'field' => 'slug',
                        'terms' => 'listing_pricing_plans',
                    ),
                ),
            );
            if( ! empty( $directory_type ) ) {
                $meta_queries['directory_type'] = [
                    'key'            => '_assign_to_directory',
                    'value'          => $directory_type,
                    'compare'        => '=',
                ];
            }
            $meta_queries = apply_filters('atbdp_plan_meta_query', $meta_queries);
            $count_meta_queries = count( $meta_queries );
            if( $count_meta_queries ) {
                $args['meta_query'] = ( $count_meta_queries > 1 ) ? array_merge( array('relation' => 'AND'), $meta_queries ) : $meta_queries;
            }
            $atbdp_query = new WP_Query( $args );

            ob_start();
            $this->dynamic_plans( $atbdp_query, $current_val, $user_id );
            $template = ob_get_clean();

            wp_send_json( $template );
        }

        public function dynamic_plans( $atbdp_query, $current_val, $user_id = '' ){
            $user_id        = !empty( $user_id ) ? $user_id : get_current_user_id();
            if ($atbdp_query->have_posts()) {
                global $post;
                $plans = $atbdp_query->posts;?>
                    <div class="directorist-admin-form-plan-selection">

                    </div>
                    <label for="select_plans"><?php echo __('Select Plan', 'directorist-woocommerce-pricing-plans'); ?></label>
                    <div class="directorist-admin-form-plan-selection__content">
                        <select name="admin_plan">
                            <option value="null"><?php echo __('- Select -', 'directorist-woocommerce-pricing-plans'); ?></option>
                            <?php
                            foreach ($plans as $key => $value) {
                                $class = apply_filters('atbdp_admin_plan_select_option_class', 'listing_plan', $value->ID);
                                $active_plan = subscribed_package_or_PPL_plans($user_id, 'completed', $value->ID);
                                $plan_metas = get_post_meta($value->ID);
                                $plan_type = esc_attr($plan_metas['plan_type'][0]);
                                $active = '';
                                if ('package' === $plan_type && $active_plan) {
                                    $active = ' <span class="atbd_badge atbd_badge_open">' . __(' - Active', 'directorist-woocommerce-pricing-plans') . '</span>';
                                }
                                ?>
                                <option class="<?php echo $class.' '.$plan_type ?>" value="<?php echo $value->ID; ?>" <?php echo selected($value->ID, $current_val); ?>><?php echo $value->post_title.$active; ?></option>
                                <?php
                            }

                            ?>
                        </select>
                        <span class="directorist_loader"></span>
                    </div>
                    <div id="directorist-allowances"></div>
                    <div id="dcl-claim-submit-notification"></div>
                    <div id="dcl-claim-warning-notification"></div>
                    <div class="directorist-admin-form-plan-action">
                        <a target="_blank" href="<?php echo esc_url(ATBDP_Permalink::get_fee_plan_page_link()); ?>" class="button atpp_plans"><?php echo __('Details', 'directorist-woocommerce-pricing-plans'); ?></a>
                        <a href="#" id="confirm_plan" class="button"><?php echo __('Save', 'directorist-woocommerce-pricing-plans'); ?></a>
                    </div>

                <?php
            }
        }

        public function dwpp_changing_plan() {
            $listingID = ! empty( $_POST['listingID'] ) ? $_POST['listingID'] : '';
            $directory_type = get_post_meta( $listingID, '_directory_type', true );
            ob_start();
            ?>
            <div class="dcl_pricing_plan">
                <?php
                $meta_queries = array();
                $query_args = array(
                    'post_type' => 'product',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'product_type',
                            'field' => 'slug',
                            'terms' => 'listing_pricing_plans',
                        ),
                    ),
                );

                $meta_queries[] = array(
                    'relation' => 'OR',
                    array(
                        'key' => '_hide_from_plans',
                        'compare' => 'NOT EXISTS',
                    ),
                    array(
                        'key' => '_hide_from_plans',
                        'value' => 1,
                        'compare' => '!=',
                    ),
                );
                if( ! empty( $directory_type ) ) {
                    $meta_queries['directory_type'] = [
                        'key'            => '_assign_to_directory',
                        'value'          => $directory_type,
                        'compare'        => '=',
                    ];
                }
                $meta_queries = apply_filters('atbdp_plan_meta_query', $meta_queries);
                $count_meta_queries = count($meta_queries);
                if ($count_meta_queries) {
                    $query_args['meta_query'] = ($count_meta_queries > 1) ? array_merge(array('relation' => 'AND'), $meta_queries) : $meta_queries;
                }

                $atbdp_query = new WP_Query($query_args);

                if ($atbdp_query->have_posts()) {
                    $plans = $atbdp_query->posts;
                    ?>
                    <label for="select_plans"><?php esc_html_e( 'Select Plan', 'directorist-woocommerce-pricing-plans' )?></label><hr>
                    <?php
                    foreach ($plans as $key => $value) {
                        
                        $unl            = __('Unlimited', 'directorist-woocommerce-pricing-plans');
                        $active_plan    = subscribed_package_or_PPL_plans(get_current_user_id(), 'completed', $value->ID);
                        $listingID = ! empty( $_POST['listingID'] ) ? $_POST['listingID'] : '';
                        $current_plan = get_post_meta($listingID, '_fm_plans', true);
                        $checked = $current_plan == $value->ID ? 'checked="checked"' : '';
                        $plan_id        = $value->ID;
                        $recurring      = get_post_meta( $plan_id, '_enable_subscription', true );
                        $linked_subscription = get_post_meta( $plan_id, '_linked_subscription', true );
                        $plan_type      = get_post_meta( $plan_id, 'plan_type', true );
                        $sale_price     = get_post_meta( $plan_id, '_sale_price', true );
                        $regular_price  = get_post_meta( $plan_id, '_regular_price', true );
                        $fm_price       = !empty( $sale_price ) ? esc_attr( $sale_price ) : esc_attr( $regular_price );
                        $fm_length      = get_post_meta( $plan_id, 'fm_length', true );
                        $fm_length_unl  = get_post_meta( $plan_id, 'fm_length_unl', true );
                        $num_regular    = get_post_meta( $plan_id, 'num_regular', true );
                        $num_regular_unl = get_post_meta( $plan_id, 'num_regular_unl', true );
                        $num_featured   = get_post_meta( $plan_id, 'num_featured', true );
                        $num_featured_unl = get_post_meta( $plan_id, 'num_featured_unl', true );
                        $regular        = (empty($num_regular_unl) ? $num_regular : $unl) . __(' regular & ', 'directorist-woocommerce-pricing-plans');
                        $featured       = (empty($num_featured_unl) ? $num_featured : $unl) . __(' featured listings', 'directorist-woocommerce-pricing-plans');
                        $fresh_order    = directorist_active_orders_without_listing( $value->ID );
						$active         = '';
						if ( $fresh_order || ('package' === $plan_type && $active_plan) ) {
							$active = ' <span class="atbd_badge atbd_badge_open">' . __(' - Active', 'directorist-woocommerce-pricing-plans') . '</span>';
						}
                        $price_text = ( $fm_length > 1 ) ? $fm_length . ' ' . __( 'days', 'directorist-woocommerce-pricing-plans' ) : __( 'day', 'directorist-woocommerce-pricing-plans' );

                        if ($fm_length_unl) {
                            $price_text = __('Lifetime', 'directorist-woocommerce-pricing-plans');
                        }

                        if( class_exists( 'WC_Subscriptions_Product' ) && $recurring && $linked_subscription ) {

                            $length                 = get_post_meta( $linked_subscription, '_subscription_period_interval', true );
                            $subscription_period    = get_post_meta( $linked_subscription, '_subscription_period', true );
                            switch( $subscription_period ) {
                                case 'day';
                                $price_text = ($length > 1) ? $length . ' ' . __( 'days', 'directorist-woocommerce-pricing-plans' ) : $length . ' ' . __( 'day', 'directorist-woocommerce-pricing-plans' );
                                break;
        
                                case 'week';
                                $price_text = ($length > 1) ? $length . ' ' . __( 'weeks', 'directorist-woocommerce-pricing-plans' ) : $length . ' ' . __( 'week', 'directorist-woocommerce-pricing-plans' );
                                break;
        
                                case 'month';
                                $price_text = ($length > 1) ? $length . ' ' . __( 'months', 'directorist-woocommerce-pricing-plans' ) : $length . ' ' . __( 'month', 'directorist-woocommerce-pricing-plans' );
                                break;
        
                                case 'year';
                                $price_text = ($length > 1) ? $length . ' ' . __( 'years', 'directorist-woocommerce-pricing-plans' ) : $length . ' ' . __( 'year', 'directorist-woocommerce-pricing-plans' );
                                break;
        
                            }
                            $fm_length      = directorist_plan_lifetime( $linked_subscription );
                            $regular_price  = get_post_meta( $linked_subscription, '_subscription_price', true );
                            $sale_price     = get_post_meta( $linked_subscription, '_sale_price', true );
                            $fm_price       = !empty( $sale_price ) ? esc_attr( $sale_price ) : esc_attr( $regular_price );
                            $regular_price  = get_post_meta( $linked_subscription, '_subscription_price', true );
                            $fresh_order = directorist_active_orders_without_listing( $linked_subscription );

                        }
                        
                        ?>
                        <input type="radio" class="new_plan_id" name="new_plan" id="<?php echo esc_html( $plan_id ); ?>" value="<?php echo esc_html( $plan_id ); ?>" <?php echo $checked; ?>>
                        <label for="<?php echo esc_html( $plan_id ); ?>"><?php echo esc_html( $value->post_title ); ?></label>
                        
                        <?php echo $active; 
                        ?>
                        <br>
                        <p class="atbd_plan_core_features">
                            <span class="apc_price"><?php echo $fm_price ? wc_price( $fm_price ) : __('Free', 'directorist-woocommerce-pricing-plans'); ?></span>
                            <span>
                                <?php echo $price_text ? $price_text : ''; ?>
                            </span>
                            <span><?php echo ($plan_type === 'package' ? __('Package', 'directorist-woocommerce-pricing-plans') : __('Pay Per Listing', 'directorist-woocommerce-pricing-plans')); ?></span>
                            <?php if( $plan_type === 'package' ):?>
                                <span><?php echo $regular . $featured; ?></span>
                            <?php endif;?>
                        </p>
                        <hr>
                        <?php                    
                    }
                }
                ?>
            </div>
            <?php
            $template = ob_get_clean();
            wp_send_json( array(
                'template' => $template
            ) );
        }

        public function directorist_plan_dynamic_fields() {
            $term_id = ! empty( $_POST['listing_type'] ) ? sanitize_text_field( $_POST['listing_type'] ) : '';
            $post_id = ! empty( $_POST['post_id'] ) ? sanitize_text_field( $_POST['post_id'] ) : '';

            $data = [
                'default_type'   => $term_id,
                'post'           => get_post( $post_id ),
             ];
            ob_start();
            DWPP_WC_Controller::dynamic_plan_fields( $data );
            $template = ob_get_clean();
            wp_send_json( $template );
        }

            /**
         * @since 1.6.6
         */

        public function dynamic_admin_listing_form_and_allowances()
        {
            $allowances = '';
            $plan_id        = isset($_POST['plan_id']) ? $_POST['plan_id'] : '';
            $user_id        = isset($_POST['user_id']) ? $_POST['user_id'] : '';
            if( $plan_id == 'null' ) die();
            if( 'package' !== package_or_PPL( $plan_id ) ) die;
		    $post_id    	= sanitize_text_field( $_POST['post_id'] );
            $featured       = get_post_meta( $post_id, '_featured', true );
            $listing_type   = $featured ? 'featured' : 'regular';
            $old_order       = get_post_meta($post_id, '_plan_order_id', true);

            $active_orders = directorist_active_orders( $plan_id, $user_id );

            if( count( $active_orders ) > 1 ){

                foreach( $active_orders as $order ){
                    $valid_order = directorist_valid_order( $order, $plan_id );
                    if( ! $valid_order ){

                        $active_orders = array_diff($active_orders, [$order]);
                    }
                }
            }

            $order_id =  !empty( $active_orders ) ? $active_orders[0] : '';
            $order_id = $old_order ? $old_order : $order_id;

            $remaining  = plans_remaining( $plan_id, $order_id, $user_id );
            $featured   = $remaining['featured'];
            $regular    = $remaining['regular'];

            // wp_send_json([
            //     'order_id' => $order_id,
            //     'remaining' => $remaining,
            //     'active_orders' => $active_orders,
            // ]);


            ob_start();
            if( count( $active_orders ) > 1 ){ ?>

                <div class="dpp-order-select-wrapper">
                    <form action="">
                        <div class="directorist-form-group">
                            <div class="directorist-form-label"><span><?php echo __( 'Active Orders', 'directorist-woocommerce-pricing-plans' )?></span></div>

                            <div class="directorist-dropdown dpp-order-select-dropdown" data-label="<?php esc_attr_e( 'Select active order', 'directorist-woocommerce-pricing-plans'); ?>" data-general_label="<?php esc_attr_e( 'General', 'directorist-woocommerce-pricing-plans');  ?>" data-featured_label="<?php esc_attr_e( 'Featured', 'directorist-woocommerce-pricing-plans'); ?>">
                                <select name="activated_order" class="select_active_order">
                                    <option value=""><?php echo __( 'Select an order', 'directorist-woocommerce-pricing-plans' )?></option>
                                    <?php
                                        foreach( $active_orders as $order ){
                                            $plan_id = get_post_meta( $order, '_fm_plan_ordered'. true );?>
                                            <option <?php echo selected($order, $order_id); ?> value="<?php echo $order; ?>"><?php echo '#' . esc_attr( $order ); ?></option>
                                        <?php }?>
                                </select>
                            </div>


                        </div>
                    </form>

                </div>


            <?php }else{
                ?>
                <div class="directorist-listing-type">
                    <h4 class="directorist-option-title"><?php _e('Choose Listing Type', 'directorist-woocommerce-pricing-plans') ?></h4>
                    <div class="directorist-listing-type_list">
                        <?php
                        if ( 'Unlimited' === $regular ) {
                        ?>
                            <div class="directorist-input-group --atbdp_inline">
                                <input id="regular" <?php echo ($listing_type == 'regular') ? 'checked' : ''; ?> type="radio" class="atbdp_radio_input" name="listing_type" value="regular" checked>
                                <label for="regular"><?php _e(' Regular listing', 'directorist-woocommerce-pricing-plans') ?>
                                    <span class="atbdp_make_str_green"><?php _e(" (Unlimited)", 'directorist-woocommerce-pricing-plans') ?></span>
                                </label>
                            </div>
                        <?php } else { ?>
                            <div class="directorist-input-group --atbdp_inline">
                                <input id="regular" <?php echo $featured == 0 ? 'disabled' : ($listing_type == 'regular' ? 'checked' : ''); ?> type="radio" class="atbdp_radio_input" name="listing_type" value="regular" checked>
                                <label for="regular"><?php _e(' Regular listing', 'directorist-woocommerce-pricing-plans') ?>
                                    <span class="<?php echo $regular > 0 ? 'atbdp_make_str_green' : 'atbdp_make_str_red' ?>">
                                        <?php echo '(' . $regular . __(' Remaining', 'directorist-woocommerce-pricing-plans') . ')'; ?></span>
                                </label>
                            </div>
                        <?php } ?>

                        <?php
                        if ( 'Unlimited' === $featured ) {
                        ?>
                            <div class="directorist-input-group --atbdp_inline">
                                <input id="featured" type="radio" class="atbdp_radio_input" <?php echo ($listing_type == 'featured') ? 'checked' : ''; ?> name="listing_type" value="featured">
                                <label for="featured" class="featured_listing_type_select">
                                    <?php _e(' Featured listing', 'directorist-woocommerce-pricing-plans') ?>
                                    <span class="atbdp_make_str_green"><?php _e(" (Unlimited)", 'directorist-woocommerce-pricing-plans') ?></span>
                                </label>
                            </div>
                        <?php
                        } else { ?>
                            <div class="directorist-input-group --atbdp_inline">
                                <input id="featured" type="radio" <?php echo $featured == 0 ? 'disabled' : ($listing_type == 'featured' ? 'checked' : ''); ?> class="atbdp_radio_input" name="listing_type" value="featured">
                                <label for="featured" class="featured_listing_type_select">
                                    <?php _e(' Featured listing', 'directorist-woocommerce-pricing-plans') ?>
                                    <span class="<?php echo $featured > 0 ? 'atbdp_make_str_green' : 'atbdp_make_str_red' ?>">
                                        <?php echo '(' . $featured . __(' Remaining', 'directorist-woocommerce-pricing-plans') . ')'; ?></span>
                                </label>
                            </div>
                        <?php } ?>
                    </div>
                </div>
                <?php
            }
            $allowances = ob_get_clean();

            wp_send_json_success( array(
                'allowances'            => $allowances,
            ) );

        }

        public function atpp_gifting_plan()
        {

            $data           = array('error' => 0);
            $order_id       = isset($_POST["order_id"]) ? (int) ($_POST["order_id"]) : '';
            $post_id        = isset($_POST["post_id"]) ? (int) ($_POST["post_id"]) : '';
            $plan_id        = isset($_POST["plan_id"]) ? (int) ($_POST["plan_id"]) : '';
            $user_id        = isset($_POST['user_id']) ? $_POST['user_id'] : '';
            $listing_type   = isset($_POST["listing_type"]) ? esc_html($_POST["listing_type"]) : '';

            if( ( $plan_id === 'null' ) || empty( $plan_id ) ){
                update_post_meta( $post_id, '_fm_plans', '' );
                $data['message'] = __('Plan changed successfully!', 'directorist-woocommerce-pricing-plans');
                wp_send_json( $data );
            }

            $response     = directorist_validate_plan( $plan_id, $post_id, $order_id, $listing_type, $user_id );

            if( !empty( $response['need_payment'] ) ){

                do_action('atbdp_plan_assigned', $post_id);
                // process the order for the gifted plan
                //process the order for the gifted plan
                $address = array();
                $args = array(
                    'customer_id' => $user_id,
                    'status' => 'completed',
                );
                $order = wc_create_order($args);
                $order->add_product(wc_get_product($plan_id)); //(get_product with id and next is for quantity)
                $order->set_address($address, 'billing');
                $order->calculate_totals();

                $order_id = $order->id;

                // save required data as order post meta
                update_post_meta($order_id, '_listing_id', [ $post_id ]);
                update_post_meta($post_id, '_plan_order_id', $order_id);
                update_post_meta($order_id, '_fm_plan_ordered', $plan_id);
                $data['message'] = __('Successfully assigned!', 'directorist-woocommerce-pricing-plans');
                wp_send_json( $data );

            }

            if( !empty( $response['error'] ) ){
                $data['validation_error'] = $response['error_msg'];
            }else{
                do_action('atbdp_plan_assigned', $post_id);
                $data['message'] = __('Plan changed successfully!', 'directorist-woocommerce-pricing-plans');
            }

            wp_send_json( $data );

        }

        public function plan_allowances_on_user_selection()
        {

            $directory_type = !empty( $_POST['directory_type'] ) ? sanitize_text_field( $_POST['directory_type'] ) : default_directory_type();
		    $post_id    	= !empty( $_POST['post_id'] ) ? sanitize_text_field( $_POST['post_id'] ) : '';
            $user_id        = !empty( $_POST['user_id'] ) ? sanitize_text_field( $_POST['user_id'] ) : '';
            $current_val    = get_post_meta( $post_id, '_fm_plans', true );

            if (isset($post_id) && get_post_status($post_id)) {
                $args = array('ID' => $post_id, 'post_author' => $user_id);
                // update the post, which calls save_post again
                wp_update_post($args);
            }

            $meta_queries = array();
            $args = array(
                'post_type' => 'product',
                'tax_query' => array(
                    array(
                        'taxonomy' => 'product_type',
                        'field' => 'slug',
                        'terms' => 'listing_pricing_plans',
                    ),
                ),
            );
            if( ! empty( $directory_type ) ) {
                $meta_queries['directory_type'] = [
                    'key'            => '_assign_to_directory',
                    'value'          => $directory_type,
                    'compare'        => '=',
                ];
            }
            $meta_queries = apply_filters('atbdp_plan_meta_query', $meta_queries);
            $count_meta_queries = count( $meta_queries );
            if( $count_meta_queries ) {
                $args['meta_query'] = ( $count_meta_queries > 1 ) ? array_merge( array('relation' => 'AND'), $meta_queries ) : $meta_queries;
            }
            $atbdp_query = new WP_Query( $args );

            ob_start();
            $this->dynamic_plans( $atbdp_query, $current_val, $user_id );
            $template = ob_get_clean();

            wp_send_json( $template );
        }

        /**
         * @since 1.3.4
         */

        public function plan_allowances()
        {
            $data       = [];
            $plan_id    = isset($_POST['plan_id']) ? $_POST['plan_id'] : '';
            $post_id    = isset($_POST['post_id']) ? $_POST['post_id'] : '';
            $order_id   = get_post_meta($post_id, '_plan_order_id', true);
            $order_plan_id = get_post_meta( $order_id, '_fm_plans', true );
            $active_orders = directorist_active_orders( $plan_id );
            $active_orders = ! empty( $active_orders ) ? $active_orders[0] : [];
            $order_id   = ( $order_plan_id != $plan_id ) ? $active_orders : $order_id;

            // wp_send_json([
            //     'plan_id' => $plan_id,
            //     'post_id' => $post_id,
            //     'order_id' => $order_id,
            //     'order_plan_id' => $order_plan_id,
            //     'asdasd' => $active_orders ,
            // ]);

            if( 'package' !== package_or_PPL( $plan_id ) ){
                wp_send_json( $data );
            }

            $remaining  = plans_remaining( $plan_id, $order_id );

            $featured   = $remaining['featured'];
            $regular    = $remaining['regular'];

            if( count( $active_orders ) > 1 ){

                foreach( $active_orders as $order ){
                    $valid_order = directorist_valid_order( $order, $plan_id );
                    if( ! $valid_order ){

                        $active_orders = array_diff($active_orders, [$order]);
                    }
                }
            }

            if(  count( $active_orders ) > 1  ){
                ?>

                <div class="dpp-order-select-wrapper">
                    <form action="">
                        <div class="directorist-form-group">
                            <div class="directorist-form-label"><span><?php echo __( 'Active Orders', 'directorist-woocommerce-pricing-plans' )?></span></div>

                            <div class="directorist-dropdown dpp-order-select-dropdown" data-label="<?php esc_attr_e( 'Select active order', 'directorist-woocommerce-pricing-plans'); ?>" data-general_label="<?php esc_attr_e( 'General', 'directorist-woocommerce-pricing-plans');  ?>" data-featured_label="<?php esc_attr_e( 'Featured', 'directorist-woocommerce-pricing-plans'); ?>">
                                <a href="" class="directorist-dropdown-toggle"><span class="directorist-dropdown-toggle__text"><?php echo __( 'Select an order', 'directorist-woocommerce-pricing-plans' )?></span></a>
                                <div class="directorist-dropdown-option">
                                    <ul>
                                        <?php
                                        foreach( $active_orders as $order ){
                                            $plan_id = get_post_meta( $order, '_fm_plan_ordered'. true );
                                            ?>
                                            <li><a href="" data-value="<?php echo $order; ?>"><?php echo '#' . esc_attr( $order ); ?></a></li>
                                            <?php
                                        }
                                        ?>
                                    </ul>
                                </div>
                            </div>


                        </div>
                    </form>

                </div>


            <?php }else{
            ob_start();
            ?>
            <div class="directorist-listing-type">
                <?php $listing_type = !empty($listing_info['listing_type']) ? $listing_info['listing_type'] : ''; ?>

                <h4 class="directorist-option-title"><?php _e('Choose Listing Type', 'directorist-woocommerce-pricing-plans') ?></h4>
                <div class="directorist-listing-type_list">
                    <?php
                    if ( 'Unlimited' === $regular ) {
                    ?>
                        <div class="directorist-input-group --atbdp_inline">
                            <input id="regular" <?php echo ($listing_type == 'regular') ? 'checked' : ''; ?> type="radio" class="atbdp_radio_input" name="listing_type" value="regular" checked>
                            <label for="regular"><?php _e(' Regular listing', 'directorist-woocommerce-pricing-plans') ?>
                                <span class="atbdp_make_str_green"><?php _e(" (Unlimited)", 'directorist-woocommerce-pricing-plans') ?></span>
                            </label>
                        </div>
                    <?php } else { ?>
                        <div class="directorist-input-group --atbdp_inline">
                            <input id="regular" <?php echo $featured == 0 ? 'disabled' : '' ?> <?php echo ($listing_type == 'regular') ? 'checked' : ''; ?> type="radio" class="atbdp_radio_input" name="listing_type" value="regular" checked>
                            <label for="regular"><?php _e(' Regular listing', 'directorist-woocommerce-pricing-plans') ?>
                                <span class="<?php echo $regular > 0 ? 'atbdp_make_str_green' : 'atbdp_make_str_red' ?>">
                                    <?php echo '(' . $regular . __(' Remaining', 'directorist-woocommerce-pricing-plans') . ')'; ?></span>
                            </label>
                        </div>
                    <?php } ?>

                    <?php
                    if ( 'Unlimited' === $featured ) {
                    ?>
                        <div class="directorist-input-group --atbdp_inline">
                            <input id="featured" type="radio" class="atbdp_radio_input" <?php echo ($listing_type == 'featured') ? 'checked' : ''; ?> name="listing_type" value="featured">
                            <label for="featured" class="featured_listing_type_select">
                                <?php _e(' Featured listing', 'directorist-woocommerce-pricing-plans') ?>
                                <span class="atbdp_make_str_green"><?php _e(" (Unlimited)", 'directorist-woocommerce-pricing-plans') ?></span>
                            </label>
                        </div>
                    <?php
                    } else { ?>
                        <div class="directorist-input-group --atbdp_inline">
                            <input id="featured" type="radio" <?php echo $featured == 0 ? 'disabled' : '' ?> <?php echo ($listing_type == 'featured') ? 'checked' : ''; ?> class="atbdp_radio_input" name="listing_type" value="featured">
                            <label for="featured" class="featured_listing_type_select">
                                <?php _e(' Featured listing', 'directorist-woocommerce-pricing-plans') ?>
                                <span class="<?php echo $featured > 0 ? 'atbdp_make_str_green' : 'atbdp_make_str_red' ?>">
                                    <?php echo '(' . $featured . __(' Remaining', 'directorist-woocommerce-pricing-plans') . ')'; ?></span>
                            </label>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <?php
            }
            $data['html'] = ob_get_clean();

            wp_send_json( $data );
        }



        public function dwpp_submit_changing_plan()
        {

            $data           = array('error' => 0);
            $order_id       = isset($_POST["order_id"]) ? (int) ($_POST["order_id"]) : '';
            $post_id        = isset($_POST["post_id"]) ? (int) ($_POST["post_id"]) : '';
            $plan_id        = isset($_POST["plan_id"]) ? (int) ($_POST["plan_id"]) : '';
            $listing_type   = isset($_POST["listing_type"]) ? esc_html($_POST["listing_type"]) : '';

            $assinged_plan = get_post_meta( $post_id, '_fm_plans', true );
            $listing_status = get_post_meta( $post_id, '_listing_status', true );
            if( ( $plan_id == $assinged_plan ) && ( 'expired' !== $listing_status ) ) {
                dwpp_need_listing_to_refresh( get_current_user_id(), $post_id, $order_id );
                $data['validation_error'] = __( 'This plan is already assigned, try a diffrent one.', 'directorist-woocommerce-pricing-plan' );
                wp_send_json( $data );
            }

            if( ( $plan_id === 'null' ) || empty( $plan_id ) ){
                update_post_meta( $post_id, '_fm_plans', '' );
                $data['message'] = __('Plan changed successfully!', 'directorist-woocommerce-pricing-plans');
                wp_send_json( $data );
            }
            // wp_send_json($_POST);

            $response     = directorist_validate_plan( $plan_id, $post_id, $order_id, $listing_type );
            // wp_send_json( $response );

            if( !empty( $response['need_payment'] ) ){
                $data['checkout_url'] = $response['redirect_url'];
                $data['take_payment'] = 'plan';
            }

            if( !empty( $response['error'] ) ){
                $data['validation_error'] = $response['error_msg'];
            }else{
                dwpp_need_listing_to_refresh( '', $post_id, $order_id );
                do_action('atbdp_plan_assigned', $post_id);
                $data['message'] = __('Plan changed successfully!', 'directorist-woocommerce-pricing-plans');
            }

            wp_send_json( $data );

        }

    }
endif;
