<?php
/*
 * Class: Business Directory Multiple Image = DWPP
 * */
if (!class_exists('DWPP_Admin_Notices')) :
    class DWPP_Admin_Notices
    {
        public function __construct()
        {
            add_action('init', array($this, 'dwpp_load_classes'), 9);

        }

           /**
     * Instantiate classes when woocommerce is activated
     */
    public function dwpp_load_classes()
    {
        if (!class_exists('WooCommerce')) {
            add_action('admin_notices', array($this, 'need_woocommerce'));
            return;
        }
        if (!class_exists('Directorist_Base')) {
            add_action('admin_notices', array($this, 'need_directorist'));
            return;
        }
    }


    
    /**
     * WooCommerce not active notice.
     *
     * @return string Fallack notice.
     */

    public function need_directorist()
    {
        $error = sprintf(__('Directorist - WooCommerce Pricing Plans requires %sDirectorist%s to be installed & activated!', 'directorist-woocommerce-pricing-plans'), '<a target="_blank" href="http://wordpress.org/extend/plugins/directorist/">', '</a>');

        $message = '<div class="error notice is-dismissible"><p>' . $error . '</p></div>';
        //deactivate_plugins(plugin_basename( __FILE__ ));

        echo $message;
    }


    /**
     * WooCommerce not active notice.
     *
     * @return string Fallack notice.
     */

    public function need_woocommerce()
    {
        $error = sprintf(__('Directorist - WooCommerce Pricing Plans requires %sWooCommerce%s to be installed & activated!', 'directorist-woocommerce-pricing-plans'), '<a target="_blank" href="http://wordpress.org/extend/plugins/woocommerce/">', '</a>');

        $message = '<div class="error notice is-dismissible"><p>' . $error . '</p></div>';
        //deactivate_plugins(plugin_basename( __FILE__ ));

        echo $message;
    }

    }
endif;
