jQuery(document).ready(function () {
    jQuery('#dwpp_woo_metaboxes').hide();
    jQuery('.options_group.pricing').addClass('show_if_listing_pricing_plans').show();
    jQuery('._dwpp_listings_limit_field ').hide();
    jQuery('._dwpp_unl_listings_field').hide();
    jQuery('._dwpp_hide_listings_field').hide();
    jQuery('._dwpp_featured_limit_field').hide();
    jQuery('._dwpp_unl_featured_field').hide();
    jQuery('._dwpp_hide_featured_field').hide();

    jQuery('#product-type').on('change', function () {
        if (jQuery(this).val() == 'listing_pricing_plans') {
            jQuery('.inventory_options').addClass('show_if_listing_pricing_plans').show();
            jQuery('#inventory_product_data ._sold_individually_field').parent().addClass('show_if_listing_pricing_plans').show();
            jQuery('#inventory_product_data ._sold_individually_field').addClass('show_if_listing_pricing_plans').show();
            jQuery('#dwpp_woo_metaboxes').show();
        } else {
            jQuery('#dwpp_woo_metaboxes').hide();
        }
    });
    jQuery('#product-type').trigger('change');

    var selectedVal = jQuery('[name="_dwpp_plan_type"]:checked').val();
    //get the plan type
    jQuery('._dwpp_listings_limit_field').hide();
    jQuery('._dwpp_featured_limit_field').hide();
    jQuery('[name="_dwpp_plan_type"]').on('click', function () {

        //hide unnecessary fields if click on PPL
        if (jQuery(this).val() === 'package') {
            alert('Please Make sure to add number of Regular and Featured listings in this package');
            jQuery('._dwpp_listings_limit_field ').fadeIn(300);
            jQuery('._dwpp_unl_listings_field').fadeIn(300);
            jQuery('._dwpp_hide_listings_field').fadeIn(300);
            jQuery('._dwpp_featured_limit_field').fadeIn(300);
            jQuery('._dwpp_unl_featured_field').fadeIn(300);
            jQuery('._dwpp_hide_featured_field').fadeIn(300);
            jQuery('._dwpp_featured_field').fadeOut(300);
            jQuery('._dwpp_featured').hide();
            jQuery('._dwpp_hide_listing_featured_field').hide();


        } else {
            jQuery('._dwpp_listings_limit_field ').fadeOut(300);
            jQuery('._dwpp_unl_listings_field').fadeOut(300);
            jQuery('._dwpp_hide_listings_field').fadeOut(300);
            jQuery('._dwpp_featured_limit_field').fadeOut(300);
            jQuery('._dwpp_unl_featured_field').fadeOut(300);
            jQuery('._dwpp_hide_featured_field').fadeOut(300);
            jQuery('._dwpp_featured_field').fadeIn(300);
            jQuery('._dwpp_featured').fadeIn(300);
            jQuery('._dwpp_hide_listing_featured_field').fadeIn(300);
        }
    });

    if (selectedVal === 'pay_per_listng') {
        jQuery('._dwpp_listings_limit_field ').hide();
        jQuery('._dwpp_unl_listings_field').hide();
        jQuery('._dwpp_hide_listings_field').hide();
        jQuery('._dwpp_featured_limit_field').hide();
        jQuery('._dwpp_unl_featured_field').hide();
        jQuery('._dwpp_hide_featured_field').hide();
        jQuery('._dwpp_featured_field').fadeIn(300);
    }
    if (selectedVal === 'package') {
        jQuery('._dwpp_listings_limit_field ').show();
        jQuery('._dwpp_unl_listings_field').show();
        jQuery('._dwpp_hide_listings_field').show();
        jQuery('._dwpp_featured_limit_field').show();
        jQuery('._dwpp_unl_featured_field').show();
        jQuery('._dwpp_hide_featured_field').show();
        jQuery('._dwpp_featured_field').hide();
        jQuery('._dwpp_featured').hide();
        jQuery('._dwpp_hide_listing_featured_field').hide();
    }

    var $ = jQuery;

    $('#is_listing_featured').hide();
    var package = $('#package');
    var pay_per_listing = $('#pay_per_listng');
    var pay_per_package = $('#pay_per_package');
    var plan_tax_area = $('.plan_tax_area');

    $('body').on('change', 'input[name="plan_type"]', function () {
        if ($(this).val() == "package") {

            $(this).prop("checked", false);
            let target_class = $(this).data('target');
            $('.' + target_class).toggleClass('active');
        } else if ($(this).val() == "pay_per_listng") {

            $('#regular_listing').fadeOut(300);
            $('#featured_listing').fadeOut(300);
            $('#is_listing_featured').fadeIn(300);
        }
    });

    // Auto Subscription
    let autoSubsCheckbox = $('.directorist-auto-subscription .directorist-switch-Yn input[type=checkbox]');
    let linkSubscription = $('.directorist-input-box .directorist-link-subscription');
    let linkDuration = $('.directorist-input-box .directorist-listing-duration');
    let wooPricingInput = $('.product_data .woocommerce_options_panel .pricing input');
    let wooProductType = $('#woocommerce-product-data #product-type[name="product-type"]');
    $(autoSubsCheckbox).on('change', function (event) {
        if ($(this).prop('checked')) {
            $(linkSubscription).addClass('directorist-visible');
            $(linkDuration).addClass('directorist-hidden');
            $(wooPricingInput).attr("disabled", true);
            if ($(wooProductType).val() === 'listing_pricing_plans') {
                $(wooPricingInput).attr("disabled", true);
            }
        } else {
            $(linkSubscription).removeClass('directorist-visible');
            $(linkDuration).removeClass('directorist-hidden');
            $(wooPricingInput).attr("disabled", false);
        }
    });

    $(wooProductType).on('change', function (event) {
        if ($(this).val() === 'listing_pricing_plans' && $(autoSubsCheckbox).prop('checked')) {
            $(wooPricingInput).attr("disabled", true);
        } else {
            $(wooPricingInput).attr("disabled", false);
        }
    });

    if ($(autoSubsCheckbox).prop('checked')) {
        $(linkSubscription).addClass('directorist-visible');
        $(wooPricingInput).attr("disabled", true);

        if ($(wooProductType).val() === 'listing_pricing_plans') {
            $(wooPricingInput).attr("disabled", true);
        }
    } else {
        $(linkSubscription).removeClass('directorist-visible');
        $(wooPricingInput).attr("disabled", false);
    }

    // load admin add listing form
    const directory_type = $('select[name="directory_type"]').val();

    if (directory_type) {
        admin_listing_form(directory_type);
    }
    $('body').on('change', 'select[name="directory_type"]', function () {
        admin_listing_form($(this).val());
    });

    function admin_listing_form(directory_type) {
        $.ajax({
            type: 'post',
            url: woo_pricing_admin_js.ajaxurl,
            data: {
                action: 'atbdp_dynamic_plan',
                directory_type: directory_type,
                listing_id: $('#directiost-listing-fields_wrapper').data('id'),
                user_id: $('select[name=post_author_override]').val(),

            },
            success(response) {
                if (response) {
                    $('.directorist-admin-form-plan-container')
                        .empty()
                        .html(response);
                }
            },
        });
    }

    // Switch Control
    $('body').on('click', '.directorist-switch-Yn', function () {
        if ($(this).children('input').is(':checked')) {
            $(this).siblings('.directorist-switch-Yn-content').addClass('directorist-visible');
            $(this).parent('td').siblings('td').children('.directorist-switch-Yn-content').addClass('directorist-visible');
        } else {
            $(this).siblings('.directorist-switch-Yn-content').removeClass('directorist-visible');
            $(this).parent('td').siblings('td').children('.directorist-switch-Yn-content').removeClass('directorist-visible');
        }
    });

    // Renew Check
    $('body').on('change', '#directorist_auto-renew-check', function () {
        if ($(this).is(':checked')) {
            $(this).closest('.directorist-renew-check-content').addClass('directorist-auto-renew-active');
        } else {
            $(this).closest('.directorist-renew-check-content').removeClass('directorist-auto-renew-active');
        }
    });


    // Input Control
    $('body').on('click', '.directorist-input-control', function () {
        if ($(this).children('input').is(':checked')) {
            $(this).siblings('.directorist-handle-input').removeClass('directorist-visible');
        } else {
            $(this).siblings('.directorist-handle-input').addClass('directorist-visible');
        }
    });

    // Price Set
    $('body').on('click', '.directorist_free-plan #free_plan', function () {
        if ($(this).is(':checked')) {
            $(this).parent('.directorist_free-plan').siblings('.directorist_tax-wrap, .directorist_price-input').fadeOut();
        } else {
            $(this).parent('.directorist_free-plan').siblings('.directorist_tax-wrap, .directorist_price-input').fadeIn();
        }
    });


    $('body').on('click', '.atpp_modal-ok', function (e) {
        e.preventDefault();

        $('#pay_per_package').prop("checked", true);
        $('.atpp_seelct-plan-modal').removeClass('active');
        $('.atbdp-directory-delete-cancel-link').removeClass('atpp_cptm-modal-toggle');

        let target_class = $(this).data('target');
        $('.' + target_class).removeClass('active');
        $('#regular_listing').fadeIn(300);
        $('#featured_listing').fadeIn(300);
        $('#is_listing_featured').fadeOut(300);
    });

    $('body').on('click', '.atpp_modal-cancel', function (e) {
        e.preventDefault();

        $('#pay_per_listng').prop("checked", true);
        let target_class = $(this).data('target');
        $('.' + target_class).removeClass('active');
    });


    window.onload = function () {
        var selectedVal = "";
        var selected = $("input[type='radio'][name='plan_type']:checked");
        if (selected.length > 0) {
            selectedVal = selected.val();
        }
        if (selectedVal === 'pay_per_listng') {
            $('#regular_listing').fadeOut();
            $('#featured_listing').fadeOut();
            $('#is_listing_featured').fadeIn(300);
        } else if (selectedVal === 'package') {
            $('#regular_listing').show();
            $('#featured_listing').show();
            $('#is_listing_featured').hide();
        }

        //Pricing Width on Resize Fixed
        if ($('#fm_plans_container').innerWidth() < 768) {
            $('#fm_plans_container .atbd_plans_row .atbd_plan_col').addClass('atbd_plan_col--res-fix');
        }

        // Switch Control
        $('.directorist-switch-Yn').each((index, element) => {
            if ($(element).children('input').is(':checked')) {
                $(element).siblings('.directorist-switch-Yn-content').addClass('directorist-visible');
                $(element).parent('td').siblings('td').children('.directorist-switch-Yn-content').addClass('directorist-visible');
            } else {
                $(element).siblings('.directorist-switch-Yn-content').removeClass('directorist-visible');
                $(element).parent('td').siblings('td').children('.directorist-switch-Yn-content').removeClass('directorist-visible');
            }
        });

        // Renew Check
        $('#directorist_auto-renew-check').each((index, element) => {
            if ($(element).is(':checked')) {
                $(element).closest('.directorist-renew-check-content').addClass('directorist-auto-renew-active');
            } else {
                $(element).closest('.directorist-renew-check-content').removeClass('directorist-auto-renew-active');
            }
        });

        // Input Control
        $('.directorist-input-control').each((index, element) => {
            if ($(element).children('input').is(':checked')) {
                $(element).siblings('.directorist-handle-input').removeClass('directorist-visible');
            } else {
                $(element).siblings('.directorist-handle-input').addClass('directorist-visible');
            }
        });
        // Price Set
        $('.directorist_free-plan #free_plan').each((index, element) => {
            if ($(element).is(':checked')) {
                $(element).parent('.directorist_free-plan').siblings('.directorist_tax-wrap, .directorist_price-input').fadeOut();
            } else {
                $(element).parent('.directorist_free-plan').siblings('.directorist_tax-wrap, .directorist_price-input').fadeIn();
            }
        });
    };

    // load dynamic field
    $('body').on('change', 'input[name=assign_to_directory]', function () {
        var form_data = new FormData();
        var listing_type = $(this).val();
        var post_id = $('input[name="post_id"]').val();
        form_data.append('action', 'directorist_plan_dynamic_fields');
        form_data.append('post_id', post_id);
        form_data.append('listing_type', listing_type);
        $.ajax({
            method: 'POST',
            processData: false,
            contentType: false,
            url: woo_pricing_admin_js.ajaxurl,
            data: form_data,
            beforeSend: function () {
                $('#directorist-type-preloader').show();
            },
            success: function (response) {
                $('.directorist-plan-dynamic-field').empty().append(response);
            },
            error: function (error) {
                //console.log(error);
            },
            complete: function () {
                $('#directorist-type-preloader').hide();
            }
        });
    });

    /* Description character limit: WPEditor */
    function checkTextareaLimit(textEditorSelector, type) {
        textEditorDoms = document.querySelectorAll(`${textEditorSelector}`);
        if (textEditorDoms.length) {
            textEditorDoms.forEach((textEditorElment) => {

                if (type === "editor") {
                    if(document.getElementById('directorist_listing_content_max') === null){
                        return;
                    }
                    var textEditorElmentId = textEditorElment.querySelector('textarea').id;
                    var textareaMaxChar = document.getElementById('directorist_listing_content_max').value;
                } else if (type === "textarea") {
                    if ( ! textEditorElment.getAttribute("maxlength") || ( textEditorElment.getAttribute("maxlength") === null ) ) {
                        return;
                    }
                    var textEditorElmentId = textEditorElment.id;
                    var textareaMaxChar = Number(textEditorElment.getAttribute("maxlength"));
                    textEditorElment.setAttribute("maxlength", textareaMaxChar);
                }

                var remainingCharCount = textareaMaxChar;
                remainingDom = document.createElement('p');
                remainingDom.classList.add('directorist-remaining-count');
                remainingDom.innerText = plan_validator.remaining_text + " " + textareaMaxChar;
                textEditorElment.insertAdjacentElement('afterend', remainingDom);
                var maxCharAlertDom = document.createElement('p');
                maxCharAlertDom.classList.add('directorist-textarea-max-alert');
                maxCharAlertDom.innerText = plan_validator.max_exit;
                /* get editor text contents character & word counts */
                function getStats(id) {
                    if (type === "editor") {
                        var body = tinymce.get(id).getBody(),
                            text = tinymce.trim(body.innerText || body.textContent)
                    } else if (type === "textarea") {
                        var text = textEditorElment.value
                    }
                    return {
                        chars: text.length,
                        words: text.split(/[\w\u2019\'-]+/).length
                    };
                }
                /* append alert */
                function appendAlert() {
                    if (!maxCharAlertDom.length) {
                        if (type === "editor") {
                            textEditorElment.nextSibling.insertAdjacentElement('afterend', maxCharAlertDom)
                        } else {
                            textEditorElment.nextSibling.insertAdjacentElement('afterend', maxCharAlertDom);
                        }
                    }
                }
                if (type === "editor") {
                    tinymce.activeEditor.on('keypress', function (e) {
                        if (remainingCharCount > 0) {
                            textEditorElment.nextSibling.innerText = `${plan_validator.remaining_text} ${textareaMaxChar - getStats(textEditorElmentId).chars}`;
                        }

                        /* append/remove max limit alert */
                        if (getStats(textEditorElmentId).chars >= textareaMaxChar) {
                            appendAlert()
                            e.preventDefault();
                        } else if (getStats(textEditorElmentId).chars < textareaMaxChar + 2) {
                            maxCharAlertDom.remove();
                        }
                    });
                    tinymce.activeEditor.on('keydown', function (e) {
                        if (e.keyCode == 8) {
                            /* remove alert */
                            if (getStats(textEditorElmentId).chars < textareaMaxChar + 2) {
                                maxCharAlertDom.remove();
                            }
                            setTimeout(() => {
                                if (getStats(textEditorElmentId).chars === 0) {
                                    remainingCharCount = textareaMaxChar;
                                    textEditorElment.nextSibling.innerText = `${plan_validator.remaining_text} ${textareaMaxChar}`;
                                }
                                let remChar = getStats(textEditorElmentId).chars;
                                let remCharCount = textareaMaxChar - remChar;
                                textEditorElment.nextSibling.innerText = `${plan_validator.remaining_text} ${remCharCount}`;
                            }, 0);
                            if (remainingCharCount >= 0 && remainingCharCount < textareaMaxChar) {
                                remainingCharCount++;
                                textEditorElment.nextSibling.innerText = `${plan_validator.remaining_text} ${remainingCharCount}`;
                            }
                        }
                    });
                    tinymce.activeEditor.on('paste', function (e) {
                        var currentText = tinymce.activeEditor.contentDocument.body.innerText;
                        let currentTextSanitize = currentText.replace(/%MCEPASTEBIN%/g, '');
                        var textLength = textareaMaxChar - currentTextSanitize.length + 3;
                        let clipTextLength = e.clipboardData.getData('text').length;
                        remainingCharCount = textareaMaxChar - (clipTextLength + currentTextSanitize.trim().length);
                        textEditorElment.nextSibling.innerText = `${plan_validator.remaining_text} ${remainingCharCount}`;
                        if (clipTextLength >= textLength) {
                            var sliceCopiedData = e.clipboardData.getData('text').slice(0, textLength);
                            tinymce.activeEditor.contentDocument.body.innerText = currentTextSanitize.trim() + ' ' + sliceCopiedData;
                            appendAlert();
                            remainingCharCount = 0;
                            textEditorElment.nextSibling.innerText = `${plan_validator.remaining_text} 0`;
                            e.preventDefault();
                        } else {
                            if (maxCharAlertDom.length) {
                                maxCharAlertDom.remove();
                            }
                        }
                    });
                    tinymce.activeEditor.on('cut', function (e) {
                        setTimeout(() => {
                            if (getStats(textEditorElmentId).chars === 0) {
                                remainingCharCount = textareaMaxChar;
                                textEditorElment.nextSibling.innerText = `${plan_validator.remaining_text} ${textareaMaxChar}`;
                            }
                            let remChar = getStats(textEditorElmentId).chars;
                            let remCharCount = textareaMaxChar - remChar;
                            textEditorElment.nextSibling.innerText = `${plan_validator.remaining_text} ${remCharCount}`;
                        }, 100);
                        if (remainingCharCount >= 0 && remainingCharCount < textareaMaxChar) {
                            remainingCharCount++;
                            textEditorElment.nextSibling.innerText = `${plan_validator.remaining_text} ${remainingCharCount}`;
                        }
                    });
                } else {
                    function letterCountWithAlert() {
                        if (remainingCharCount > 0) {
                            let remainingNumber = textareaMaxChar - getStats(textEditorElmentId).chars;
                            if (remainingNumber < 0) {
                                remainingNumber = 0;
                            }
                            textEditorElment.closest('.directorist-form-group').querySelector('.directorist-remaining-count').innerText = `${plan_validator.remaining_text} ${remainingNumber}`;
                        }
                        /* append/remove max limit alert */
                        if (getStats(textEditorElmentId).chars >= textareaMaxChar) {
                            appendAlert()
                        } else if (getStats(textEditorElmentId).chars < textareaMaxChar + 2) {
                            maxCharAlertDom.remove();
                        }
                    }
                    textEditorElment.addEventListener('keydown', function () {
                        letterCountWithAlert();
                    });
                    textEditorElment.addEventListener('keyup', function () {
                        letterCountWithAlert();
                    });
                    textEditorElment.addEventListener('paste', function () {
                        setTimeout(() => {
                            letterCountWithAlert();
                        }, 100);
                    });
                    textEditorElment.addEventListener('cut', function () {
                        setTimeout(() => {
                            letterCountWithAlert();
                        }, 100);
                    });
                    textEditorElment.addEventListener('focus', function () {
                        let editorSliceText = textEditorElment.value.slice(0, textareaMaxChar);
                        textEditorElment.value = editorSliceText;
                        letterCountWithAlert();
                    });
                }
            });
        }
    }

    checkTextareaLimit('#wp-listing_content-wrap', 'editor');
    checkTextareaLimit('.directorist-custom-field-textarea textarea', 'textarea');
    checkTextareaLimit('.directorist-form-description-field textarea.directorist-form-element', 'textarea');
});