<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Blogger;

class User extends \Google\Model
{
  /**
   * @var string
   */
  public $about;
  protected $blogsType = UserBlogs::class;
  protected $blogsDataType = '';
  public $blogs;
  /**
   * @var string
   */
  public $created;
  /**
   * @var string
   */
  public $displayName;
  /**
   * @var string
   */
  public $id;
  /**
   * @var string
   */
  public $kind;
  protected $localeType = UserLocale::class;
  protected $localeDataType = '';
  public $locale;
  /**
   * @var string
   */
  public $selfLink;
  /**
   * @var string
   */
  public $url;

  /**
   * @param string
   */
  public function setAbout($about)
  {
    $this->about = $about;
  }
  /**
   * @return string
   */
  public function getAbout()
  {
    return $this->about;
  }
  /**
   * @param UserBlogs
   */
  public function setBlogs(UserBlogs $blogs)
  {
    $this->blogs = $blogs;
  }
  /**
   * @return UserBlogs
   */
  public function getBlogs()
  {
    return $this->blogs;
  }
  /**
   * @param string
   */
  public function setCreated($created)
  {
    $this->created = $created;
  }
  /**
   * @return string
   */
  public function getCreated()
  {
    return $this->created;
  }
  /**
   * @param string
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * @param string
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * @param string
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * @param UserLocale
   */
  public function setLocale(UserLocale $locale)
  {
    $this->locale = $locale;
  }
  /**
   * @return UserLocale
   */
  public function getLocale()
  {
    return $this->locale;
  }
  /**
   * @param string
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * @param string
   */
  public function setUrl($url)
  {
    $this->url = $url;
  }
  /**
   * @return string
   */
  public function getUrl()
  {
    return $this->url;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(User::class, 'Google_Service_Blogger_User');
