<?php

use DHGI\App\Http\Controllers\ContactController;
use DHGI\App\Http\Controllers\FormController;
use DHGI\App\Http\Controllers\ListController;
use DHGI\App\Http\Controllers\ResponseController;
use DHGI\App\Http\Controllers\SummaryController;
use DHGI\App\Http\Controllers\TagController;
use DHGI\WpMVC\Routing\Route;

Route::group(
    'listing-owner', function() {
        Route::get( 'lists', [ListController::class, 'index'] );
        Route::group(
            'form', function() {
                Route::group(
                    '{id}', function() {
                        Route::get( 'tags', [FormController::class, 'tags'] );
                        Route::post( 'status', [FormController::class, 'update_status'] );
                        Route::post( 'rename', [FormController::class, 'update_title'] );
                        Route::group(
                            'summary', function() {
                                Route::get( 'element', [SummaryController::class, 'element'] );
                                Route::get( '/', [SummaryController::class, 'index'] );
                            }
                        );
                        Route::delete( 'element/option', [FormController::class, 'delete_element_option'] );
                        Route::delete( 'element/answer', [FormController::class, 'delete_element'] );
                    }
                );
                Route::post( 'auto-save', [FormController::class, 'auto_save'] );
                Route::delete( '/', [FormController::class, 'delete_bulk_form'] );
                Route::post( '/status', [FormController::class, 'update_bulk_status'] );
                Route::get( 'select', [FormController::class, 'select'] );
                Route::post( 'media', [FormController::class, 'insert_media'] );
                Route::resource( '/', FormController::class );
            }
        );

        Route::resource( 'tag', TagController::class, ['items' => ['show']] );

        Route::group(
            'response', function () {
                Route::get( '/', [ResponseController::class, 'index'] );
                Route::get( 'form', [ResponseController::class, 'form'] );
                Route::post( 'setup/tag', [ResponseController::class, 'setup_tag'] );
                Route::group(
                    '{id}', function() {
                        Route::delete( '/', [ResponseController::class, 'delete'] );
                        Route::post( 'read', [ResponseController::class, 'update_read'] );
                        Route::post( 'archive', [ResponseController::class, 'update_archive_status'] );
                    }
                );
            } 
        );

        if ( function_exists( "helpgent_pro" ) ) {
            Route::group(
                'contact', function() {
                    Route::get( '/', [ContactController::class, 'index'] );
                    Route::post( '/export', [ContactController::class, 'export'] );
                    Route::get( '/forms', [ContactController::class, 'forms'] );
                }
            );
        }
    }, ['auth']
);