<?php

defined( 'ABSPATH' ) || exit;

use DHGI\WpMVC\DependentManager\Manager;
use DHGI\App\Helpers\EDDSLPluginUpdater;
use DHGI\WpMVC\App;

/**
 * Plugin Name:       Directorist - HelpGent Integration
 * Description:       This is an extension of Directorist to allow listing author to communicate with their customers
 * Version:           2.0.4
 * Requires at least: 6.0
 * Requires PHP:      7.4
 * Tested up to:      6.2
 * Author:            WpWax
 * Author URI:        https://wpwax.com/
 * License:           GPL v3 or later
 * License URI:       http://www.gnu.org/licenses/gpl-3.0.html
 * Text Domain:       directorist-helpgent-integration
 * Domain Path:       /languages
 */

require_once __DIR__ . '/vendor/vendor-src/autoload.php';

final class DirectoristHelpGentIntegration
{
    public static DirectoristHelpGentIntegration $instance;

    public static function instance(): DirectoristHelpGentIntegration {
        if ( empty( self::$instance ) ) {
            self::$instance = new self;
        }
        return self::$instance;
    }

    public function load() {

        $active_plugins = wp_get_active_and_valid_plugins();

        if ( ! in_array( WP_PLUGIN_DIR . "/helpgent/helpgent.php", $active_plugins, true ) || ! in_array( WP_PLUGIN_DIR . "/directorist/directorist-base.php", $active_plugins, true ) ) {
            return;
        }

        $application = App::instance();

        $application->boot( __FILE__, __DIR__ );

        if ( is_admin() ) {
            add_action( 'init', [ $this, 'plugin_updater' ] );
        }

        /**
         * Fires once activated plugins have loaded.
         */
        add_action(
            'plugins_loaded', function () use ( $application ): void {

                do_action( 'before_load_dhgi' );

                if ( defined( 'HELPGENT_DEPENDENCY_VERSION' ) ) {
                    $dependent_manager = new Manager( HELPGENT_DEPENDENCY_VERSION, '1.0.1', "HelpGent", "Directorist HelpGent Integration" );

                    if ( ! $dependent_manager->is_compatible() ) {
                        return;
                    }
                }

                require_once __DIR__ . '/app/Helpers/helper.php';

                $application->load();

                do_action( 'after_load_dhgi' );
            },
            11
        );
    }

    public function plugin_updater() : void {
        /**
         * @var \DHGI\WpMVC\Config $config
         */
        $config = App::$instance::$config;

        new EDDSLPluginUpdater(
            $config->get( 'licensing.licensing_api' ), 
            App::$plugin_root_file, 
            [
                'version' => $config->get( 'app.version' ),
                'license' => '',
                'item_id' => $config->get( 'licensing.product_id' ),
                'author'  => $config->get( 'licensing.author' ),
                'url'     => home_url(),
                'beta'    => false, // Set to true if you wish customers to receive update notifications of beta releases
            ]
        );
    }
}

DirectoristHelpGentIntegration::instance()->load();
