<?php

defined( 'ABSPATH' ) || exit;

use DHGI\App\Http\Middleware\Auth;
use DHGI\App\Http\Middleware\EnsureIsUserAdmin;
use DHGI\App\Providers\MenuServiceProvider;
use DHGI\App\Providers\Admin\DirectoristSettingsServiceProvider;
use DHGI\App\Providers\EmailNotificationServiceProvider;
use DHGI\WpMVC\App;

return [
    'version'                 => get_plugin_data( App::$plugin_root_file )['Version'],

    'rest_api'                => [
        'namespace' => 'dhgi',
        'versions'  => []
    ],

    'ajax_api'                => [
        'namespace' => 'dhgi',
        'versions'  => []
    ],

    'providers'               => [
        MenuServiceProvider::class,
        DirectoristSettingsServiceProvider::class,
        EmailNotificationServiceProvider::class
    ],

    'admin_providers'         => [],

    'middleware'              => [
        'auth'  => Auth::class,
        'admin' => EnsureIsUserAdmin::class,
    ],

    'migration_db_option_key' => 'dhgi_migrations',

    'migrations'              => []
];