<?php

namespace DHGI\App\Providers\Admin;

use DHGI\WpMVC\Contracts\Provider;

class DirectoristSettingsServiceProvider implements Provider {
    public function boot() {    
        add_filter( 'atbdp_listing_type_settings_field_list', [ $this, 'register_fields' ] );
        add_filter( 'atbdp_extension_settings_submenu', [ $this, 'register_extension_submenu' ] );
    }

    public function register_fields( $fields = [] ) {
        $is_pro_active = dhgi_is_pro_active();

        $fields['hgd_max_video_duration'] = [
            'label'       => __( 'Max Video Length', 'directorist-helpgent-integration' ),
            'type'        => 'number',
            'value'       => dhgi_get_default_settings( 'max_video_duration' ),
            'min'         => 1,
            'max'         => $is_pro_active ? 0 : 2,
            'description' => __( 'Max video length in minute', 'directorist-helpgent-integration' ),
        ];

        $fields['hgd_max_voice_duration'] = [
            'label'       => __( 'Max Voice Length', 'directorist-helpgent-integration' ),
            'type'        => 'number',
            'value'       => dhgi_get_default_settings( 'max_voice_duration' ),
            'min'         => 1,
            'max'         => $is_pro_active ? 0 : 2,
            'description' => __( 'Max voice length in minute', 'directorist-helpgent-integration' ),
        ];

        $fields['hgd_max_upload_size'] = [
            'label' => __( 'Max Upload Size', 'directorist-helpgent-integration' ),
            'type'  => 'number',
            'value' => dhgi_get_default_settings( 'max_upload_size' ),
            'min'   => 1,
            'max'   => $is_pro_active ? 0 : 300,
        ];

        $fields['hgd_max_upload_size_unit'] = [
            'label'   => __( 'Max Upload Size Unit', 'directorist-helpgent-integration' ),
            'type'    => 'select',
            'options' => [
                [ 'value' => 'kb', 'label' => 'KB' ],
            ],
            'value'   => dhgi_get_default_settings( 'max_upload_size_unit' ),
        ];

        $fields['hgd_video_resolution'] = [
            'label'   => __( 'Video Resolution', 'directorist-helpgent-integration' ),
            'type'    => 'select',
            'options' => dhgi_get_resolution_options( $is_pro_active ? 0 : 720 ),
            'value'   => dhgi_get_default_settings( 'hgd_video_resolution' ),
        ];

        $fields['hgd_form_bubble_position'] = [
            'label'   => __( 'Form Bubble Position', 'directorist-helpgent-integration' ),
            'type'    => 'select',
            'options' => [
                [ 'value' => 'right', 'label' => 'Right' ],
                [ 'value' => 'left', 'label' => 'Left' ],
            ],
            'value'   => dhgi_get_default_settings( 'form_bubble_position' ),
        ];

        $fields['hgd_form_bubble_offset_x'] = [
            'label'       => __( 'Form Bubble Position Offset X', 'directorist-helpgent-integration' ),
            'type'        => 'number',
            'value'       => dhgi_get_default_settings( 'form_bubble_offset_x' ),
            'description' => __( 'Offset X in pixel', 'directorist-helpgent-integration' ),
        ];

        $fields['hgd_form_bubble_offset_y'] = [
            'label'       => __( 'Form Bubble Position Offset Y', 'directorist-helpgent-integration' ),
            'type'        => 'number',
            'value'       => dhgi_get_default_settings( 'form_bubble_offset_y' ),
            'description' => __( 'Offset Y in pixel', 'directorist-helpgent-integration' ),
        ];

        $fields['hgd_form_bubble_size'] = [
            'label'   => __( 'Form Bubble Size', 'directorist-helpgent-integration' ),
            'type'    => 'select',
            'options' => [
                [ 'value' => 'small', 'label' => 'Small' ],
                [ 'value' => 'medium', 'label' => 'Medium' ],
                [ 'value' => 'large', 'label' => 'Large' ],
            ],
            'value'   => dhgi_get_default_settings( 'form_bubble_size' ),
        ];

        $fields['hgd_allowed_email'] = [
            'label'       => __( 'Email Notification Limit Per Listing Owner (Per Day)', 'directorist-helpgent-integration' ),
            'type'        => 'number',
            'value'       => dhgi_get_default_settings( 'allowed_email' ),
            'min'         => 0,
            'description' => __( '0 means no limit', 'directorist-helpgent-integration' ),
        ];

        $fields['hgd_maximum_form_creation_limit'] = [
            'label'       => __( 'Maximum Form Creation Limit', 'directorist-helpgent-integration' ),
            'type'        => 'number',
            'min'         => 0,
            'value'       => dhgi_get_default_settings( 'maximum_form_creation_limit' ),
            'description' => __( '0 means no limit', 'directorist-helpgent-integration' ),
        ];

        $fields['hgd_display_the_lead'] = [
            'label'       => __( 'Display the "Lead"', 'directorist-helpgent-integration' ),
            'type'        => 'toggle',
            'value'       => dhgi_get_default_settings( 'display_the_lead' ),
            'description' => __( 'All leads collected from the “contact info” element will be stored here', 'directorist-helpgent-integration' ),
        ];

        if ( $is_pro_active ) {
            $fields['hgd_max_upload_size_unit']['options'][] = [ 'value' => 'mb', 'label' => 'MB' ];
        }

        return $fields;
    }

    public function register_extension_submenu( $submenu = [] ) {
        $submenu['helpgent_settings'] = [
            'label'    => __( 'HelpGent', 'directorist-helpgent-integration' ),
            'icon'     => '<i class="fa fa-video"></i>',
            'sections' => [
                'media_settings'       => [
                    'title'  => __( 'Media Settings', 'directorist-helpgent-integration' ),
                    'fields' => [
                        'hgd_max_video_duration',
                        'hgd_max_voice_duration',
                        'hgd_max_upload_size',
                        'hgd_max_upload_size_unit',
                        'hgd_video_resolution',
                    ],
                ],
                'form_bubble_settings' => [
                    'title'  => __( 'Form Bubble Settings', 'directorist-helpgent-integration' ),
                    'fields' => [
                        'hgd_form_bubble_position',
                        'hgd_form_bubble_offset_x',
                        'hgd_form_bubble_offset_y',
                        'hgd_form_bubble_size',
                    ],
                ],
                'additional_settings'  => [
                    'title'  => __( 'Additional Settings', 'directorist-helpgent-integration' ),
                    'fields' => [
                        'hgd_allowed_email',
                        'hgd_maximum_form_creation_limit',
                        'hgd_display_the_lead',
                    ],
                ],
            ],
        ];

        return $submenu;
    }
}