<?php

namespace DHGI\App\Http\Controllers;

use HelpGent\WpMVC\RequestValidator\Validator;
use HelpGent\App\Http\Controllers\Admin\SummaryController as HelpgentSummaryController;
use DHGI\App\Http\Controllers\Controller;
use WP_REST_Request;

class SummaryController extends Controller {
    public HelpgentSummaryController $controller;

    public FormController $form_repository;

    public function __construct( HelpgentSummaryController $controller, FormController $form_repository ) {
        $this->controller      = $controller;
        $this->form_repository = $form_repository;
    }

    public function index( Validator $validator, WP_REST_Request $wp_rest_request ) {
        $error = $this->form_repository->is_user_can_edit( $validator, $wp_rest_request );

        if ( is_array( $error ) ) {
            return $error;
        }
    
        return $this->controller->index( $validator, $wp_rest_request );
    }

    public function element( Validator $validator, WP_REST_Request $wp_rest_request ) {
        $error = $this->form_repository->is_user_can_edit( $validator, $wp_rest_request );

        if ( is_array( $error ) ) {
            return $error;
        }
    
        return $this->controller->element( $validator, $wp_rest_request );
    }
}