<?php

namespace DHGI\App\Http\Controllers;

use DHGI\App\Http\Controllers\Controller;
use DHGI\WpMVC\Routing\Response;
use HelpGent\WpMVC\RequestValidator\Validator;
use HelpGent\App\Http\Controllers\Admin\ResponseController as HelpGentResponseController;
use WP_REST_Request;
use HelpGent\App\Models\Form;

class ResponseController extends Controller {
    public HelpGentResponseController $controller;

    public function __construct( HelpGentResponseController $controller ) {
        $this->controller = $controller;
    }

    public function index( Validator $validator, WP_REST_Request $wp_rest_request ) {
        $error = $this->is_user_can_access_form( $validator, $wp_rest_request );

        if ( is_array( $error ) ) {
            return $error;
        }
        return $this->controller->index( $validator, $wp_rest_request );
    }

    public function form( Validator $validator, WP_REST_Request $wp_rest_request ) {
        $error = $this->is_user_can_access_form( $validator, $wp_rest_request );

        if ( is_array( $error ) ) {
            return $error;
        }
        return $this->controller->form( $validator, $wp_rest_request );
    }

    public function delete( Validator $validator, WP_REST_Request $wp_rest_request ) {
        $error = $this->is_user_can_access_response_form( $validator, $wp_rest_request );

        if ( is_array( $error ) ) {
            return $error;
        }
        return $this->controller->delete( $validator, $wp_rest_request );
    }

    public function setup_tag( Validator $validator, WP_REST_Request $wp_rest_request ) {
        $error = $this->is_user_can_access_response_form( $validator, $wp_rest_request, 'response_id' );

        if ( is_array( $error ) ) {
            return $error;
        }

        return $this->controller->setup_tag( $validator, $wp_rest_request );
    }

    public function update_read( Validator $validator, WP_REST_Request $wp_rest_request ) {
        $error = $this->is_user_can_access_response_form( $validator, $wp_rest_request );

        if ( is_array( $error ) ) {
            return $error;
        }

        return $this->controller->update_read( $validator, $wp_rest_request );
    }

    public function update_archive_status( Validator $validator, WP_REST_Request $wp_rest_request ) {
        $error = $this->is_user_can_access_response_form( $validator, $wp_rest_request );

        if ( is_array( $error ) ) {
            return $error;
        }

        return $this->controller->update_archive_status( $validator, $wp_rest_request );
    }

    public function is_user_can_access_response_form( Validator $validator, WP_REST_Request $wp_rest_request, $request_param = 'id' ) {
        $validator->validate(
            [
                $request_param => 'required|numeric'
            ]
        );

        if ( $validator->is_fail() ) {
            return Response::send(
                [
                    'messages' => $validator->errors
                ], 422
            );
        }

        $id       = $wp_rest_request->get_param( $request_param );
        $response = $this->controller->response_repository->get_by_id( $id );

        if ( ! $response ) {
            return Response::send(
                [
                    'message' => esc_html__( 'Response not found.', 'directorist-helpgent-integration' )
                ], 404
            );
        }

        $user = wp_get_current_user();
        $form = Form::query()->where( 'id', $response->form_id )->where( "created_by", $user->ID )->first();

        if ( ! $form ) {
            return Response::send(
                [
                    'message' => esc_html__( 'Form not found.', 'directorist-helpgent-integration' )
                ], 404
            );
        }
    }

    public function is_user_can_access_form( Validator $validator, WP_REST_Request $wp_rest_request ) {
        $validator->validate(
            [
                'form_id' => 'required|numeric',
            ]
        );

        if ( $validator->is_fail() ) {
            return Response::send(
                [
                    'messages' => $validator->errors
                ], 422
            );
        }

        $form = $this->controller->form_repository->get_by_id( $wp_rest_request->get_param( 'form_id' ) );

        if ( ! $form ) {
            return Response::send(
                [
                    'message' => esc_html__( 'Form not found.', 'directorist-helpgent-integration' )
                ], 404
            );
        }

        if ( wp_get_current_user()->ID !== intval( $form->created_by ) ) {
            return Response::send(
                [
                    'message' => esc_html__( 'Sorry, you are not authorized to access this form data.', 'directorist-helpgent-integration' )
                ], 500
            );
        }
    }
}