<?php

namespace DHGI\App\Http\Controllers;

use DHGI\App\Http\Controllers\Controller;
use DHGI\WpMVC\RequestValidator\Validator;
use DHGI\WpMVC\Routing\Response;
use DHGI\App\Models\Post;
use HelpGent\App\Repositories\FormRepository;
use WP_REST_Request;

class ListController extends Controller {
    public FormRepository $form_repository;

    public function __construct( FormRepository $form_repository ) {
        $this->form_repository = $form_repository;
    }

    public function index( Validator $validator, WP_REST_Request $wp_rest_request ) {
        $validator->validate(
            [
                'search' => 'string',
                'ids'    => 'array'
            ]
        );

        if ( $validator->is_fail() ) {
            return Response::send(
                [
                    'messages' => $validator->errors
                ], 422
            );
        }

        $ids = $wp_rest_request->get_param( 'ids' );

        if ( $wp_rest_request->has_param( 'ids' ) && ! helpgent_is_one_level_array( $ids ) ) {
            return Response::send(
                [
                    'messages' => [
                        'ids' => "Ids must be one level array"
                    ]
                ], 422
            );
        }

        $form_id = intval( $wp_rest_request->get_param( 'form_id' ) );

        if ( 0 !== $form_id ) {
            $form = $this->form_repository->get_by_id( $form_id );

            if ( ! $form ) {
                return Response::send(
                    [
                        'message' => esc_html__( "From not found", "directorist-helpgent-integration" )
                    ]
                );
            }

            $author_id = $form->created_by;
        } else {
            $author_id = helpgent_get_current_user()->get_id();
        }

        $ids    = $wp_rest_request->get_param( 'ids' );
        $search = $wp_rest_request->get_param( 'search' );
        $query  = Post::query()->where( 'post_type', 'at_biz_dir' )->where( 'post_author', $author_id );

        if ( ! empty( $ids ) ) {
            $query->where_in( 'id', $ids );
        } elseif ( ! empty( $search ) ) {
            $query->where( 'post_title', 'like', "%{$search}%" );
        }

        $query->select( 'ID as id', 'post_title as title' )->order_by_desc( 'id' );

        if ( empty( $ids ) ) {
            $lists = $query->pagination( 
                intval( $wp_rest_request->get_param( 'per_page' ) ),
                intval( $wp_rest_request->get_param( 'page' ) )
            );
        } else {
            $lists = $query->get();
        }

        $lists = array_map( fn( $list ) => [ 'value' => $list->id, 'label' =>  $list->title ], $lists );

        return Response::send( $lists );
    }
}