<?php

namespace DHGI\App\Http\Controllers;

use DHGI\App\Http\Controllers\Controller;
use HelpGentPro\App\Http\Controllers\Admin\ContactController as HelpGentContactController;
use HelpGentPro\WpMVC\RequestValidator\Validator;
use HelpGent\WpMVC\Database\Query\Builder;
use WP_REST_Request;

class ContactController extends Controller {
    public HelpGentContactController $controller;

    public function __construct( HelpGentContactController $controller ) {
        $this->controller = $controller;
    }

    public function index( Validator $validator, WP_REST_Request $wp_rest_request ) {
        add_filter( "helpgent_contact_query", [$this, "query"] );
        
        return $this->controller->index( $validator, $wp_rest_request );
    }

    public function export( Validator $validator, WP_REST_Request $wp_rest_request ) {
        add_filter( "helpgent_contact_export_query", [$this, "query"] );
        
        return $this->controller->export( $validator, $wp_rest_request );
    }

    public function forms( Validator $validator, WP_REST_Request $wp_rest_request ) {
        add_filter( 'helpgent_lead_forms_query', [$this, 'forms_query'] );
        add_filter( "helpgent_lead_forms_query_join_meta", "__return_true" );

        return $this->controller->forms( $validator, $wp_rest_request );
    }

    public function forms_query( Builder $query ) {
        return $query->where( 'form.created_by', wp_get_current_user()->ID )->where( "form_meta.meta_key", "directorist" );
    }

    public function query( Builder $query ) {
        $user_id = wp_get_current_user()->ID;
        return $query->where( "JSON_EXTRACT(contact.form_data, '$.is_directorist')", '1' )->where( "JSON_EXTRACT(contact.form_data, '$.created_by')", "{$user_id}" );
    }
}