<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace Directorist_Mailchimp_Integration;

use Directorist_Mailchimp_Integration\Mailchimp;

class Subscribe_After_Registration {

	public function __construct() {
		$this->hooks();
	}

	private function hooks() {

		$enable_mailchimp  = Helper::get_directorist_option( 'enalbe_mailchimp_for_directorist' );
		$user_registration = Helper::get_directorist_option( 'mailchmp_for_directorist_enable_subscribe_after_registration' );
		if ( ! $enable_mailchimp || ! $user_registration ) {
			return;
		}

		add_action( 'atbdp_before_user_registration_submit', array( $this, 'add_checkbox_before_user_registration_submit' ) );
		add_action( 'atbdp_before_processing_submitted_user_registration', array( $this, 'check_if_user_agree' ) );
	}

	public function add_checkbox_before_user_registration_submit() {

		$show_checkbox = Helper::get_directorist_option( 'mailchmp_for_directorist_ask_user_to_subscribe_checkbox_before_submit_button' );
		$label         = Helper::get_directorist_option( 'mailchmp_for_directorist_registation_button_before_text' );

		if ( ! $show_checkbox ) {
			return;
		}

		Helper::get_template_part( 'before-registration-checkbox', $label );
	}

	public function check_if_user_agree( $post ) {

		$show_checkbox = Helper::get_directorist_option( 'mailchmp_for_directorist_ask_user_to_subscribe_checkbox_before_submit_button' );
		if ( $show_checkbox ) {
			if ( ! isset( $post['mc_subscribe'] ) || empty( $post['mc_subscribe'] ) ) {
				return;
			}
		}

		add_action( 'atbdp_user_registration_completed', array( $this, 'add_member_to_list' ) );
	}

	public function add_member_to_list( $user_id ) {

		$user_info = get_userdata( $user_id );
		if ( ! $user_info->user_email ) {
			return;
		}

		$enable  = Helper::get_directorist_option( 'enalbe_mailchimp_for_directorist' );
		$api_key = Helper::get_directorist_option( 'mailchmp_for_directorist_api_key' );
		$server  = Helper::get_directorist_option( 'mailchmp_for_directorist_server' );
		$list_id = Helper::get_directorist_option( 'mailchmp_for_directorist_list_id' );

		if ( ! $enable ) {
			return;
		}

		if ( empty( $api_key ) || empty( $server ) || empty( $list_id ) ) {
			return;
		}

		$api_key = trim( $api_key );
		$server  = trim( $server );
		$list_id = trim( $list_id );

		$member_data = array(
			'email_address' => $user_info->user_email,
			'status'        => 'subscribed',
			'merge_fields'  => array(
				'FNAME' => $user_info->first_name ? $user_info->first_name : '',
				'LNAME' => $user_info->last_name ? $user_info->last_name : '',
			),
		);

		try {
			$e = Mailchimp::instance()->set_config( $api_key, $server )->lists->getListMember( $list_id, $member_data['email_address'] );
		} catch ( \Throwable $th ) {
			try {
				Mailchimp::instance()->set_config( $api_key, $server )->lists->addListMember( $list_id, $member_data );
			} catch ( \Throwable $th ) {
				// throw $th;
			}
		}
	}
}

new Subscribe_After_Registration();