<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace Directorist_Mailchimp_Integrationt;

use Directorist_Mailchimp_Integration\Helper;
use Directorist_Mailchimp_Integration\Mailchimp;

class Subscribe_After_Listing_Contact {

	public function __construct() {
		$this->hooks();
	}

	private function hooks() {

		$enable_mailchimp = Helper::get_directorist_option( 'enalbe_mailchimp_for_directorist' );
		$listing_contact  = Helper::get_directorist_option( 'mailchmp_for_directorist_enable_subscribe_listing_contact' );
		if ( ! $enable_mailchimp || ! $listing_contact ) {
			return;
		}

		add_action( 'atbdp_listing_contact_owner_submitted', array( $this, 'atbdp_listing_contact_owner_submitted' ) );
	}

	public function atbdp_listing_contact_owner_submitted() {

		if ( ! isset( $_POST['action'] ) && "atbdp_public_send_contact_email" != $_POST['action'] ) {
			return;
		}

		$email_address = isset( $_POST['email'] ) ? esc_html( $_POST['email'] ) : '';
		if ( ! $email_address ) {
			return;
		}

		$name          = isset( $_POST['name'] ) ? esc_html( $_POST['name'] ) : '';
		$double_opt_in = Helper::get_directorist_option( 'mailchmp_for_directorist_enable_subscribe_listing_contact_double_opt_in' );
		$status        = $double_opt_in ? 'pending' : 'subscribed';

		$member_data = array(
			'email_address' => $email_address,
			'status'        => $status,
			'merge_fields'  => array(
				'FNAME' => $name,
				'LNAME' => '',
			),
		);

		$this->add_member_to_list( $member_data );
	}

	public function add_member_to_list( $member_data ) {

		$enable  = Helper::get_directorist_option( 'enalbe_mailchimp_for_directorist' );
		$api_key = Helper::get_directorist_option( 'mailchmp_for_directorist_api_key' );
		$server  = Helper::get_directorist_option( 'mailchmp_for_directorist_server' );
		$list_id = Helper::get_directorist_option( 'mailchmp_for_directorist_list_id' );

		if ( ! $enable ) {
			return;
		}

		if ( empty( $api_key ) || empty( $server ) || empty( $list_id ) ) {
			return;
		}

		$api_key = trim( $api_key );
		$server  = trim( $server );
		$list_id = trim( $list_id );

		try {
			$e = Mailchimp::instance()->set_config( $api_key, $server )->lists->getListMember( $list_id, $member_data['email_address'] );
		} catch ( \Throwable $th ) {
			try {
				Mailchimp::instance()->set_config( $api_key, $server )->lists->addListMember( $list_id, $member_data );
			} catch ( \Throwable $th ) {
				// throw $th;
			}
		}

	}
}

new Subscribe_After_Listing_Contact();