<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace Directorist_Mailchimp_Integration;

class Settings_Manager {

	public function __construct() {
		add_filter( 'atbdp_listing_type_settings_field_list', array( $this, 'atbdp_listing_type_settings_field_list' ) );
		add_filter( 'atbdp_extension_settings_submenu', array( $this, 'atbdp_extension_settings_submenu' ) );
	}

	public function atbdp_listing_type_settings_field_list( $settings ) {

		// Auth
		$settings['enalbe_mailchimp_for_directorist'] = array(
			'label' => __( 'Enable Mailchimp', 'directorist-mailchimp-integration' ),
			'type'  => 'toggle',
			'value' => false,
		);
		$settings['mailchmp_for_directorist_api_key'] = array(
			'type'        => 'text',
			'label'       => __( 'API Key', 'directorist-mailchimp-integration' ),
			'description' => __( 'Find or generate your API key <a href="https://mailchimp.com/help/about-api-keys/?_ga=2.73511185.2059735660.1634230451-684003122.1634230450#Find_or_generate_your_API_key" target="_blank">here...</a>', 'directorist-mailchimp-integration' ),
			'placeholder' => 'ex: 5ac###############fc2-us19',
			'value'       => ' ',
			'show-if'     => array(
				'where'      => "enalbe_mailchimp_for_directorist",
				'conditions' => array(
					array( 'key' => 'value', 'compare' => '=', 'value' => true ),
				),
			),
			'rules'       => array(
				'required' => true,
			),
		);
		$settings['mailchmp_for_directorist_list_id'] = array(
			'type'        => 'text',
			'label'       => __( 'Audience ID', 'directorist-mailchimp-integration' ),
			'description' => __( 'Find your audience ID <a href="https://mailchimp.com/help/find-audience-id/" target="_blank">here...</a>', 'directorist-mailchimp-integration' ),
			'placeholder' => 'ex: 5bbcb2b42e',
			'value'       => ' ',
			'show-if'     => array(
				'where'      => "enalbe_mailchimp_for_directorist",
				'conditions' => array(
					array( 'key' => 'value', 'compare' => '=', 'value' => true ),
				),
			),
			'rules'       => array(
				'required' => true,
			),
		);
		$settings['mailchmp_for_directorist_server'] = array(
			'type'        => 'text',
			'label'       => __( 'Server', 'directorist-mailchimp-integration' ),
			'description' => __( 'To find the value for the <strong>server</strong>, log into your Mailchimp account and look at the URL in your browser. You’ll see something like <strong>https://us19.admin.mailchimp.com/</strong>, the <strong>us19</strong> part is the server prefix.', 'directorist-mailchimp-integration' ),
			'placeholder' => 'ex: us19',
			'value'       => ' ',
			'show-if'     => array(
				'where'      => "enalbe_mailchimp_for_directorist",
				'conditions' => array(
					array( 'key' => 'value', 'compare' => '=', 'value' => true ),
				),
			),
			'rules'       => array(
				'required' => true,
			),
		);

		// Subscribe After Registration
		$settings['mailchmp_for_directorist_enable_subscribe_after_registration'] = array(
			'label'       => __( 'Registration', 'directorist-mailchimp-integration' ),
			'description' => __( 'Enable Subscribe After Registration', 'directorist-mailchimp-integration' ),
			'type'        => 'toggle',
			'value'       => false,
		);
		$settings['mailchmp_for_directorist_ask_user_to_subscribe_checkbox_before_submit_button'] = array(
			'label'       => __( 'Show Checkbox', 'directorist-mailchimp-integration' ),
			'description' => __( 'Ask user to subscribe', 'directorist-mailchimp-integration' ),
			'type'        => 'toggle',
			'value'       => false,
			'show-if'     => array(
				'where'      => "mailchmp_for_directorist_enable_subscribe_after_registration",
				'conditions' => array(
					array( 'key' => 'value', 'compare' => '=', 'value' => true ),
				),
			),
		);
		$settings['mailchmp_for_directorist_registation_button_before_text'] = array(
			'type'        => 'text',
			'label'       => __( 'Checkbox Text', 'directorist-mailchimp-integration' ),
			'placeholder' => 'ex: Subscribe to our newsletter',
			'value'       => 'Subscribe to our newsletter',
			'show-if'     => array(
				'where'      => "mailchmp_for_directorist_ask_user_to_subscribe_checkbox_before_submit_button",
				'conditions' => array(
					array( 'key' => 'value', 'compare' => '=', 'value' => true ),
				),
			),
			'rules'       => array(
				'required' => true,
			),
		);

		// Listing Contact
		$settings['mailchmp_for_directorist_enable_subscribe_listing_contact'] = array(
			'label'       => __( 'Contact Listing Owner', 'directorist-mailchimp-integration' ),
			'description' => __( 'Enable Subscribe after Contact Listing Owner', 'directorist-mailchimp-integration' ),
			'type'        => 'toggle',
			'value'       => false,
		);
		$settings['mailchmp_for_directorist_enable_subscribe_listing_contact_double_opt_in'] = array(
			'label'       => __( 'Enable double opt-in', 'directorist-mailchimp-integration' ),
			'description' => __( 'Send contacts an opt-in confirmation email when they subscribe to your audience.', 'directorist-mailchimp-integration' ),
			'type'        => 'toggle',
			'value'       => false,
			'show-if'     => array(
				'where'      => "mailchmp_for_directorist_enable_subscribe_listing_contact",
				'conditions' => array(
					array( 'key' => 'value', 'compare' => '=', 'value' => true ),
				),
			),
		);

		return $settings;
	}

	public function atbdp_extension_settings_submenu( $settings ) {

		$settings['mailchimp_for_directorist'] = array(
			'label'    => __( 'Mailchimp', 'directorist-mailchimp-integration' ),
			'icon'     => '<i class="fab fa-mailchimp directorist_info"></i>',
			'sections' => array(
				'auth'                         => array(
					'fields' => array(
						'enalbe_mailchimp_for_directorist',
						'mailchmp_for_directorist_api_key',
						'mailchmp_for_directorist_list_id',
						'mailchmp_for_directorist_server',
					),
				),
				'subscribe_after_registration' => array(
					'fields' => array(
						'mailchmp_for_directorist_enable_subscribe_after_registration',
						'mailchmp_for_directorist_ask_user_to_subscribe_checkbox_before_submit_button',
						'mailchmp_for_directorist_registation_button_before_text',
					),
				),
				'subscribe_listing_contact'    => array(
					'fields' => array(
						'mailchmp_for_directorist_enable_subscribe_listing_contact',
						'mailchmp_for_directorist_enable_subscribe_listing_contact_double_opt_in',
					),
				),
			),
		);

		return $settings;
	}
}

new Settings_Manager;