<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace Directorist_Mailchimp_Integration;

class Mailchimp {

	public static $instance;

	public static function instance() {

		if ( null == self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	public function set_config( $api_key, $server ) {
		$mailchimp = new \MailchimpMarketing\ApiClient();
		$mailchimp->setConfig(
			array(
				'apiKey' => $api_key,
				'server' => $server,
			)
		);

		return $mailchimp;
	}
}