<?php
/**
 * Plugin Name: Directorist - Mailchimp Integration
 * Plugin URI: https://directorist.com/product/directorist-mailchimp-integration
 * Description: This is an extension for Directorist plugin. It allows you to create mailing listing using Mailchimp.
 * Version: 1.0
 * Author: wpWax
 * Author URI: https://wpwax.com
 * License: GPLv2 or later
 * Text Domain: directorist-mailchimp-integration
 * Domain Path: /languages
 */

// Prevent direct access to the file
defined( 'ABSPATH' ) || die( 'No direct script access allowed!' );

if ( ! class_exists( 'Directorist_Mailchimp_Integration' ) ) {

	final class Directorist_Mailchimp_Integration {

		private static $instance;
		public static $base_dir;
		public static $base_url;

		public static function instance() {

			if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Directorist_Mailchimp_Integration ) ) {
				self::$instance = new Directorist_Mailchimp_Integration();
				self::$instance->init();
			}

			return self::$instance;
		}

		private function __construct() {}

		private function init() {
			add_action( 'plugins_loaded', array( $this, 'load_textdomain' ), 20 );

			self::$base_dir = plugin_dir_path( __FILE__ );
			self::$base_url = plugin_dir_url( __FILE__ );

			$this->includes();
		}

		public function load_textdomain() {
			load_plugin_textdomain( 'directorist-mailchimp-integration', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
		}

		public function includes() {
			require_once self::$base_dir . '/includes/class-helper.php';
			require_once self::$base_dir . '/includes/class-settings-manager.php';
			require_once self::$base_dir . '/vendor/autoload.php';
			require_once self::$base_dir . '/includes/class-mailchimp.php';
			require_once self::$base_dir . '/includes/class-subscribe-after-listing-contact.php';
			require_once self::$base_dir . '/includes/class-subscribe-after-registration.php';
		}
	}

	/**
	 * @return object|Directorist_Mailchimp_Integration
	 * @since 1.0
	 */
	function Directorist_Mailchimp_Integration() {
		return Directorist_Mailchimp_Integration::instance();
	}

	// Instantiate Directorist_Mailchimp_Integration, when Directorist plugin is active
	if ( in_array( 'directorist/directorist-base.php', (array) get_option( 'active_plugins' ) ) ) {
		Directorist_Mailchimp_Integration();
	}
}