<?php
    // Exit if accessed directly
    if ( ! defined( 'ABSPATH' ) )
	    exit;
?>

<div class="user-refund__modal at-modal atm-fade" id="dcl-claim-modal">
    <div class="user-refund__modal--content atm-contents-inner">
        <div class="user-refund__part">
            <a href="#" class="at-modal-close">
                <span aria-hidden="true">×</span>
            </a>
            <form enctype="multipart/form-data" action="#" method="post" id="bdb_user_refund_form" class="directorist-refund-submit__form" novalidate="">
                <div class="user-refund__form">
                    <div class="directorist-form-group form-group-amount">
                        <label for="bdb_user_refund_amount">
                            <?php esc_html_e( 'Refundable Amount', 'directorist-booking' ); ?>
                            <?php directorist_icon( 'las la-info-circle' ); ?>
                            <span class="amount-info-text"></span>
                        </label> 
                        <input id="bdb_user_refund_amount" class="directorist-form-element" placeholder="<?php esc_attr_e( 'Refund Amount', 'directorist-booking' ); ?>" name="amount_demo" type="text" value="" maxlength="245" required="required" disabled>
                    </div>
                    <div class="directorist-form-group form-group-reason">
                        <label for="bdb_user_refund_reason"><?php esc_html_e( 'Refund Reason', 'directorist-booking' ); ?><span class="asterisk">*</span></label> 
                        <textarea id="bdb_user_refund_reason" class="directorist-form-element" name="refund_reason" cols="30" rows="10" maxlength="65525" required="required"></textarea>
                    </div>
                    <div class="directorist-form-group form-group-details">
                        <label for="bdb_user_payment_details"><?php esc_html_e( 'Payment Details', 'directorist-booking' ); ?><span class="asterisk">*</span></label> 
                        <textarea id="bdb_user_payment_details" class="directorist-form-element" name="payment_details" cols="30" rows="10" maxlength="65525" required="required"></textarea>
                    </div>
                    <input type="hidden" name="refund_booking_id" />
                    <input type="hidden" name="refund_user_name" />
                    <input type="hidden" name="refund_booking_author" />
                    <input type="hidden" name="refund_owner_id" />
                    <input type="hidden" name="refund_listing_id" />
                    <input type="hidden" name="refund_commission_id" />
                    <input type="hidden" name="amount" />
                    <p class="refund-form-notice"><?php esc_html_e( 'Please fill the required fields', 'directorist-booking' ); ?>*</p>
                    <div class="directorist-form-group form-group-submit directorist-mb-0">
                        <button name="bdb_user_refund_submit" type="submit" id="bdb_user_refund_submit" class="directorist-btn directorist-btn-primary" value="Submit">
                            <?php esc_html_e( 'Submit Refund Request', 'directorist-booking' ); ?>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>