<?php
/**
 * @author  wpWax
 * @since   6.6
 * @version 7.4.0
 */

use \Directorist\Helper;

if ( ! defined( 'ABSPATH' ) ) exit;

$listings_per_page = get_directorist_option( 'user_listings_per_page', 9 );

$args = array(
	'post_type'      => 'bdb_refund',
	'post_status' 	 => array( 'publish', 'pending' ),
	'posts_per_page' => (int) $listings_per_page,
);

$query = new \WP_Query( $args );

if ( $query->have_posts() ) {

	while ( $query->have_posts() ) {
		$query->the_post();

		$amount            = get_post_meta( get_the_ID(), '_amount' );
		$refund_reason     = get_post_meta( get_the_ID(), '_refund_reason' );
		$payment_details   = get_post_meta( get_the_ID(), '_payment_details' );
		$refund_booking_id = get_post_meta( get_the_ID(), '_refund_booking_id' );
		$refund_user_name  = get_post_meta( get_the_ID(), '_refund_user_name' );
		$refund_listing_id = get_post_meta( get_the_ID(), '_refund_listing_id' );
		$refund_status     = get_post_meta( get_the_ID(), '_refund_status' );
		$refund_owner_id   = get_post_meta( get_the_ID(), '_refund_owner_id' );

		$get_booking  = BD_Booking()->bdb_booking_database::get_booking_by_id( $refund_booking_id[0] );
		$booking_date   = ! empty( $get_booking['created'] ) ? date( get_option( 'date_format' ), strtotime( $get_booking['created'] ) ) : '';
		?>

		<?php if( get_current_user_id() == $refund_owner_id[0] ) { ?>

			<tr data-id="<?php the_ID(); ?>">

				<td>
					<div class="directorist-listing-table-listing-info">

						<div class="directorist-listing-table-listing-info__content">

							<h4 class="directorist-title">
								<a href="<?php echo esc_url( get_the_permalink( $refund_listing_id ) ); ?>">
									<?php echo get_the_title( $refund_listing_id[0] ); ?>
								</a>
							</h4>

							<?php Helper::listing_price(); ?>

						</div>

					</div>
				</td>

				
				<td>
					<span class="directorist-listing-plan">
						<?php echo esc_html( $refund_user_name[0] ); ?>
					</span>
				</td>

				<td>
					<span class="directorist-listing-booked">
						<?php echo ! empty( $booking_date ) ? esc_html( $booking_date ) : ''; ?>
					</span>
				</td>

				<td>
					<span class="directorist-listing-refunded">
						<?php echo get_the_date(); ?>
					</span>
				</td>
				

				<td><span class="directorist-ex-plan"><?php echo wp_kses_post( $refund_reason[0] ); ?></span></td>

				<td><?php echo wp_kses_post( $payment_details[0] ); ?></td>
				
				<td>
				<?php 
					if( 'on_hold' == $refund_status[0] ) {
						printf( '<b>%s</b>', __( 'On Hold', 'directorist-booking' ) ); 
					} elseif( 'admin_processing' == $refund_status[0] ) {
						printf( '<b>%s</b><br/><i>%s</i>', __( 'Processing', 'directorist-booking' ), __( 'The refund is being processed by admin', 'directorist-booking' ) ); 
					} elseif( 'paid' == $refund_status[0] ) {
						printf( '<b>%s</b>', __( 'Paid', 'directorist-booking' ) ); 
					}
				?>
				</td>
				
				<?php if( 'on_hold' == $refund_status[0] ) { ?>

					<td>
						<div class="directorist-actions">

						<a class="directorist-dropdown-item directorist-btn directorist-btn-success bdb-refund-approve" data-id="<?php echo get_the_ID(); ?>" href=""><?php esc_html_e( 'Approve', 'directorist-booking' ); ?></a>
						
						<a class="directorist-dropdown-item directorist-btn directorist-btn-danger bdb-refund-decline" data-id="<?php echo get_the_ID(); ?>" href=""><?php esc_html_e( 'Decline', 'directorist-booking' ); ?></a>


						</div>
					</td>
					
				<?php } ?>

			</tr>

		<?php } else {
			echo sprintf( '<tr><td colspan="5">%s</td></tr>', esc_html__( 'No items found', 'directorist-booking' ) );
		}
	}
	wp_reset_postdata();
}
else {
	echo sprintf( '<tr><td colspan="5">%s</td></tr>', esc_html__( 'No items found end', 'directorist' )  );
}
