<?php
/**
 * @author  wpWax
 * @since   5.6.3
 * @version 1.0
 */

if ( ! defined( 'ABSPATH' ) ) exit;

$refund_desc   = get_post_meta( $listing_id, '_refund_policy', true );
$refund_rules  = get_post_meta( $listing_id, '_refund_rules', true );
$enable_refund = get_post_meta( $listing_id, '_enable_refund', true );
?>

<!-- Refund policy -->
<div class="directorist-refund-policy-switch">
    <div class="directorist-switch directorist-checkbox-primary">
        <input type="checkbox" name="enable_refund" id="enable_refund" class="directorist-switch-input" <?php echo ( 'on' === $enable_refund ) ? 'checked' : ''; ?> >
        <label for="enable_refund" class="directorist-switch-label">
            <?php esc_html_e( 'Refund System', 'directorist-booking' ); ?>
            <?php directorist_icon( 'las la-info-circle' ); ?>
            <span class="enable_refund_description">
                <?php echo _e( 'Enable it to allow refund requests for booked products and services', 'directorist-booking' ); ?>
            </span>
        </label>
    </div>
</div>

<div class="directorist-booking-refund-policy-wrapper">

    <div class="refund-policy">
        <textarea name="refund_policy" id="refund-policy" class="directorist-form-element" rows="6" placeholder="<?php echo esc_html__( 'Example: Refunds are accepted within 40 days of the payment. Get a full refund if you request it within 7 days of the payment.', 'directorist-booking' ); ?>"><?php echo esc_textarea( $refund_desc ); ?></textarea>
    </div>

    <div class="directorist-form-group booking-refund-rules">

        <div class="booking-refund-rules-wrapper">
            <?php
            if( ! empty( $refund_rules ) ) :

                $day                = is_array( $refund_rules['day'] ) ? $refund_rules['day'] : array( $refund_rules['day'] );
                $amount             = is_array( $refund_rules['amount'] ) ? $refund_rules['amount'] : array( $refund_rules['amount'] );

                foreach( $day as $index => $refund_day ) {
                    $refund_lists[] = array(
                        'day'         => $refund_day,
                        'amount'      => $amount[ $index ],
                    );
                }
                ?>

                <?php foreach( $refund_lists as $index => $refund_list  ) : ?>

                    <div class="booking-refund-rules-single">

                        <div class="input-group mb-3 booking-refund-rules-single__day">
                            <input type="number" min="0" class="form-control directorist-form-element" placeholder="<?php _e( 'Refund days', 'directorist-booking' ); ?>" aria-label="<?php _e( 'Refund days', 'directorist-booking' ); ?>" aria-describedby="basic-addon2" name="refund_rules[day][<?php echo $index; ?>]" value="<?php echo $refund_list['day']; ?>">
                            <div class="input-group-append">
                                <span class="input-group-text" id="basic-addon2">
                                    <?php _e('Days', 'directorist-booking') ?>
                                </span>
                            </div>
                        </div>

                        <div class="input-group mb-3 booking-refund-rules-single__amount">
                            <input type="number" min="0" class="form-control directorist-form-element" placeholder="<?php _e( 'Refund amount in percent', 'directorist-booking' ); ?>" aria-label="<?php _e( 'Refund amount in percent', 'directorist-booking' ); ?>" aria-describedby="basic-addon2" name="refund_rules[amount][<?php echo $index; ?>]" value="<?php echo $refund_list['amount']; ?>">
                            <div class="input-group-append">
                                <span class="input-group-text" id="basic-addon2">%</span>
                            </div>
                        </div>

                        <div class="booking-refund-rules-single__remove">
                            <a href="#" class="booking-refund-rules-remove remove-btn"><?php directorist_icon( 'la la-trash' ); ?></a>
                        </div>
                    </div>

                <?php endforeach; ?>

            <?php else : ?>

                <div class="booking-refund-rules-single">

                <div class="input-group mb-3 booking-refund-rules-single__day">
                            <input type="number" min="0" class="form-control directorist-form-element" placeholder="<?php _e( 'Refund days', 'directorist-booking' ); ?>" aria-label="<?php _e( 'Refund days', 'directorist-booking' ); ?>" aria-describedby="basic-addon2" name="refund_rules[day][0]">
                            <div class="input-group-append">
                                <span class="input-group-text" id="basic-addon2">Days</span>
                            </div>
                        </div>

                        <div class="input-group mb-3 booking-refund-rules-single__amount">
                            <input type="number" min="0" class="form-control directorist-form-element" placeholder="<?php _e( 'Refund amount in percent', 'directorist-booking' ); ?>" aria-label="<?php _e( 'Refund amount in percent', 'directorist-booking' ); ?>" aria-describedby="basic-addon2" name="refund_rules[amount][0]">
                            <div class="input-group-append">
                                <span class="input-group-text" id="basic-addon2">%</span>
                            </div>
                        </div>

                    <div class="booking-refund-rules-single__remove">
                        <a href="#" class="booking-refund-rules-remove remove-btn">
                            <?php directorist_icon( 'la la-trash' ); ?>
                        </a>
                    </div>

                </div>

            <?php endif; ?>

        </div>

        <a href="#" class="add-btn booking-refund_rules-add">
            <?php echo esc_html__( 'Add New', 'directorist-booking' ); ?>
        </a>

    </div>

</div>
