<?php
use Directorist\Helper;
if('owner reservations' == $value['comment']){
    return;
}
$class                     = array();
$tag                       = array();
$show_approve              = false;
$show_reject               = false;
$show_refund               = false;
$booking_confirmation_page = bdb_booking_confirmation_page();
$query_var                 = add_query_arg( 'booking-id', $value['ID'], $booking_confirmation_page );
$enable_payment            = get_post_meta( $value['listing_id'], '_bdb_payment_booking', true );
$enable_refund             = get_post_meta( $value['listing_id'], '_enable_refund', true );
$refund_desc               = get_post_meta( $value['listing_id'], '_refund_policy', true );
$booking_payment_type      = get_directorist_option( 'booking_payment_type', 'directorist' );
$first_name                = json_decode( $value['comment'] )->first_name ? json_decode( $value['comment'] )->first_name : '';
if( ! empty( $value['order_id'] ) && 'woocommerce' == $booking_payment_type ) {
    $wcc_order = wc_get_order( $value['order_id'] );
}
//var_dump( $value );
if( ! empty( $wcc_order ) && 'woocommerce' == $booking_payment_type ) {
    $wcc_order_status = $wcc_order->get_status();
}

$user = get_userdata($value['owner_id']);
$username = $user->user_login;

$commission_args = array(
    'post_type' => 'bdb_commission',
    'meta_query' => array(
        array(
            'key' => '_username',
            'value' => $username,
            'compare' => '='
        ),
    ),
);
$commission_query = new WP_Query( $commission_args );

if( $commission_query->have_posts() ) {
    $commission_id = $commission_query->post->ID;
}

$refund_rules     = get_post_meta( $value['listing_id'], '_refund_rules', true );
$day              = isset( $refund_rules['day'] ) ? $refund_rules['day'] : [];
$amount           = isset( $refund_rules['amount'] ) ? $refund_rules['amount'] : [];
$day_amount_array = array_combine( $day, $amount );                              //create array(day => amount)

ksort( $day_amount_array ); //sort by array key

$booking_date = $value['created'];
$time         = time() - strtotime( $booking_date );  // check booking duration

$amount_in_percent = [];
foreach( $day_amount_array as $day => $amount ) {
    if ( gmdate("d", $time) <= $day ) {
        $amount_in_percent[] = $amount;
        break;
    }
}

$amount = ( $value['price'] / 100 ) * end( $amount_in_percent );
$refund_amount = Helper::formatted_price( $amount );

switch ( $value['status'] ) {
    case 'waiting' :
        $class[] = 'waiting-booking';
        $tag[]   = '<span class="directorist-booking-status directorist-badge directorist-badge-warning directorist-booking-status-pending">' . esc_html__( 'Waiting', 'directorist-booking' ) . '</span>';

        if( ( $value['price'] > 0 && ! empty( $enable_payment ) && ! empty( $value['order_id'] ) && 'directorist' == $booking_payment_type) || ( $value['price'] > 0 && ! empty( $enable_payment ) && 'woocommerce' == $booking_payment_type && 'pending' != $wcc_order_status ) ){
            $tag[] = '<span class="directorist-booking-status directorist-badge directorist-badge-light directorist-booking-status-unpaid">'.esc_html__('Processing Payment', 'directorist-booking').'</span>';
        }

        // if( ( $value['price'] > 0 && ! empty( $enable_payment ) && empty( $value['order_id'] ) && 'directorist' == $booking_payment_type ) || ( $value['price'] > 0 && ! empty( $enable_payment ) && 'woocommerce' == $booking_payment_type && 'pending' == $wcc_order_status ) ) {
        //     $tag[] = '<a href=' . $query_var . '><span class="directorist-booking-status directorist-badge directorist-booking-status-pay-now">'.esc_html__('Pay Now', 'directorist-booking').'</span></a>';
        // }

        if( ( $value['price'] > 0 && ! empty( $enable_payment ) && empty( $value['order_id'] ) && 'directorist' == $booking_payment_type ) || ( $value['price'] > 0 && ! empty( $enable_payment ) && 'woocommerce' == $booking_payment_type && 'pending' == $wcc_order_status ) ) {
            $tag[] = '<span class="directorist-booking-status directorist-badge directorist-badge-danger directorist-booking-status-unpaid">'.esc_html__('Unpaid', 'directorist-booking').'</span>';
        }

        $show_approve = true;
        $show_reject = true;
        $show_delete = false;
        break;

    case 'confirmed' :

        $class[] = 'approved-booking';
        $tag[]   = '<span  class="directorist-badge directorist-badge-success directorist-booking-status-approved">'.esc_html__('Approved', 'directorist-booking').'</span>';

        if( ( $value['price'] > 0 && ! empty( $enable_payment ) && ! empty( $value['order_id'] ) && 'directorist' == $booking_payment_type ) || ( $value['price'] > 0 && ! empty( $enable_payment ) && 'woocommerce' == $booking_payment_type && 'pending' != $wcc_order_status ) ){
            $tag[] = '<span class="directorist-booking-status directorist-badge directorist-badge-light directorist-booking-status-unpaid">'.esc_html__('Processing Payment', 'directorist-booking').'</span>';
        }

        if( ( $value['price'] > 0 && ! empty( $enable_payment ) && empty( $value['order_id'] ) && 'directorist' == $booking_payment_type ) || ( $value['price'] > 0 && ! empty( $enable_payment ) && 'woocommerce' == $booking_payment_type && 'pending' == $wcc_order_status ) ) {
            $tag[] = '<a href=' . $query_var . '><span class="directorist-booking-status directorist-badge directorist-booking-status-pay-now">'.esc_html__('Pay Now', 'directorist-booking').'</span></a>';
        }

        if( ( $value['price'] > 0 && ! empty( $enable_payment ) && empty( $value['order_id'] ) && 'directorist' == $booking_payment_type ) || ( $value['price'] > 0 && ! empty( $enable_payment ) && 'woocommerce' == $booking_payment_type && 'pending' == $wcc_order_status ) ) {
            $tag[] = '<span class="directorist-booking-status directorist-badge directorist-badge-light directorist-booking-status-unpaid">'.esc_html__('Unpaid', 'directorist-booking').'</span>';
        }
        
        $show_approve = false;
        $show_reject = true;
        $show_delete = false;
        break;

    case 'paid' :

        $refund_req = new WP_Query( array( 
            'post_type'   => 'bdb_refund',
            'post_status' => 'pending',
            'meta_query'  => array(
                array(
                   'key'     => '_refund_booking_id',
                   'value'   => ! empty( $value['ID'] ) ? (int) $value['ID'] : '',
                   'compare' => '='
                )
             )
        ) );

        $class[] = 'approved-booking';
        $tag[] = '<span class="directorist-booking-status directorist-badge directorist-badge-success directorist-booking-status-approved">'.esc_html__('Approved', 'directorist-booking').'</span>';

        if( $value['price'] > 0 ){
            $tag[] = '<span class="directorist-booking-status directorist-badge directorist-badge-primary directorist-booking-status-paid">'.esc_html__('Paid', 'directorist-booking').'</span>';
        }

        if( $refund_req->have_posts() ) {
            $tag[] = '<span class="directorist-booking-status directorist-badge directorist-badge-danger directorist-booking-status-paid">'.esc_html__('Processing Refund', 'directorist-booking').'</span>';
        }

        $show_approve = false;
        $show_reject  = false;
        $show_delete  = false;
        if( ! $refund_req->have_posts() && ! empty( $amount ) && ! empty( $enable_refund ) ){
            $show_refund  = true;
        }
        break;

    case 'cancelled' :

        $refund_req = new WP_Query( array( 
            'post_type'   => 'bdb_refund',
            'post_status' => 'publish',
            'meta_query'  => array(
                array(
                   'key'     => '_refund_booking_id',
                   'value'   => ! empty( $value['ID'] ) ? (int) $value['ID'] : '',
                   'compare' => '='
                )
             )
        ) );

        $class[] = 'canceled-booking';
        $tag[] = '<span class="directorist-booking-status directorist-badge directorist-badge-danger directorist-booking-status-rejected">'.esc_html__('Cancelled', 'directorist-booking').'</span>';

        if( $refund_req->have_posts() ){
            $tag[] = '<span class="directorist-booking-status directorist-badge directorist-badge-danger directorist-booking-status-paid">'.esc_html__('Refunded', 'directorist-booking').'</span>';
        }

        $show_approve = false;
        $show_reject  = false;
        $show_delete  = true;
        break;

    default:
        # code...
        break;
}
$author_pro_pic_id  = get_user_meta($value['bookings_author'], 'pro_pic', true);
$author_profile_pic = wp_get_attachment_image_src($author_pro_pic_id, 'thumbnail');
$listing_img_id     = get_post_meta($value['listing_id'], '_listing_prv_img', true);
if(!empty($listing_img_id)) {
    $listing_img = wp_get_attachment_image_src($listing_img_id, 'thumbnail');
}
$default_image_src = get_directorist_option('default_preview_image', ATBDP_PUBLIC_ASSETS . 'images/grid.jpg');
$listing_type      = get_post_meta($value['listing_id'],'_bdb_booking_type',true);
$booking_type      = get_directorist_option( 'booking_type', array( 'service', 'rent', 'booking' ) );
$booking_type      = !empty($booking_type) ? $booking_type : 'service';
$listing_type      = ( !empty($listing_type) && 'undefined' !== $listing_type ) ? $listing_type : $booking_type;
?>
<div class="directorist-booking-single <?php echo implode(' ',$class); ?>" id="booking-list-<?php echo esc_attr($value['ID']);?>">
    <div class="directorist-list-box-listing">
        <div class="directorist-list-box-listing__img"><a href="<?php echo get_permalink($value['listing_id']); ?>"><?php
                if(empty($listing_img_id)) { ?>

                <?php   } else { ?>
                <img src="<?php echo esc_url($listing_img[0]); ?>" alt="Listing Image">
                <?php }
                ?></a>
        </div>
        <div class="directorist-list-box-listing__content">
            <div class="directorist-inner">
                <div class="directorist-inner__top directorist-flex">
                    <h3 id="title" class="directorist-inner__h3title">
                        <a href="<?php echo get_permalink($value['listing_id']); ?>" class="directorist-inner__h3title--link">
                            <?php echo get_the_title($value['listing_id']); ?>
                        </a>
                    </h3>

                    <div class="directorist-booking-status-list">
                        <?php echo implode(' ',$tag); ?>
                    </div>
                </div>

                <div class="directorist-inner__booking-wrapper">
                    <?php if( 'event' != $listing_type ) { ?>
                    <div class="directorist-inner__booking-list">
                        <h5 class="directorist-inner__h5title"><?php esc_html_e('Booking Date:', 'directorist-booking'); ?></h5>
                        <ul class="directorist-booking-list">
                            <?php
                        //get post type to show proper date
                        //$listing_type = 'service';

                        if($listing_type == 'rent') { ?>
                            <li class="directorist-highlighted" id="date">
                                <?php echo date(get_option( 'date_format' ), strtotime($value['date_start'])); ?> -
                                <?php echo date(get_option( 'date_format' ), strtotime($value['date_end'])); ?></li>
                            <?php } else if( $listing_type == 'service' ) { ?>
                            <li class="directorist-highlighted" id="date">
                                <?php echo date(get_option( 'date_format' ), strtotime($value['date_start'])); ?>
                                <?php esc_html_e('at','directorist-booking'); ?> <?php
                                if( $value['date_start'] != $value['date_end'] ) {
                                    echo date(get_option('time_format'), strtotime($value['date_start'])); ?> - <?php echo date(get_option('time_format'), strtotime($value['date_end']));
                                } else {
                                    echo date(get_option('time_format'), strtotime($value['date_start']));
                                }

                                ?></li>
                            <?php } else { //event?>
                            <li class="directorist-highlighted" id="date">
                                <?php echo date(get_option( 'date_format' ), strtotime($value['date_start'])); ?>
                                <?php esc_html_e('at','directorist-booking'); ?>
                                <?php echo date(get_option( 'time_format' ), strtotime($value['date_start'])); ?>
                            </li>
                            <?php }
                        ?>

                        </ul>
                    </div>
                    <?php } ?>
                    <?php $details = json_decode($value['comment']);
                if (
                    (isset($details->childrens) && $details->childrens > 0)
                    ||
                    (isset($details->adults) && $details->adults > 0)
                    ||
                    (isset($details->tickets) && $details->tickets > 0)
                ) { ?>
                    <div class="directorist-inner__booking-list">
                        <h5 class="directorist-inner__h5title"><?php esc_html_e('Booking Details:', 'directorist-booking'); ?></h5>
                        <ul class="directorist-booking-list">
                            <li class="directorist-highlighted" id="details">
                                <?php
                                if( isset($details->childrens) && $details->childrens > 0) : ?>
                                <?php printf( _n( '%d Child', '%s Children', $details->childrens, 'directorist-booking' ), $details->childrens ) ?>
                                <?php endif; ?>
                                <?php if( isset($details->adults)  && $details->adults > 0) : ?>
                                <?php printf( _n( '%d Guest', '%s Guests', trim($details->adults,' Person'), 'directorist-booking' ), trim($details->adults,' Person') ) ?>
                                <?php endif; ?>
                                <?php if( isset($details->tickets)  && $details->tickets > 0) : ?>
                                <?php printf( _n( '%d Ticket', '%s Tickets', $details->tickets, 'directorist-booking' ), $details->tickets ) ?>
                                <?php endif; ?>
                            </li>
                        </ul>
                    </div>
                    <?php } ?>

                    <?php
                $currency = get_directorist_option('g_currency', 'USD');
                $currency_postion = get_directorist_option('g_currency_position', 'before');
                $currency_symbol = atbdp_currency_symbol($currency);

                /*if($value['price']): */?>
                    <!--
                    <div class="directorist-inner__booking-list">
                        <h5 class="directorist-inner__h5title"><?php /*esc_html_e('Price:', 'directorist-booking'); */?></h5>
                        <ul class="directorist-booking-list">
                            <li class="directorist-highlighted" id="price">
                                <?php /*if($currency_postion == 'before') { echo $currency_symbol.' '; }  */?>
                                <?php /*echo $value['price']; */?>
                                <?php /*if($currency_postion == 'after') { echo ' '.$currency_symbol; }  */?></li>
                        </ul>
                    </div>
                --><?php /*endif; */?>

                    <div class="directorist-inner__booking-list">

                        <h5 class="directorist-inner__h5title"><?php esc_html_e('Client:', 'directorist-booking'); ?></h5>
                        <ul class="directorist-booking-list" id="client">
                            <?php if( isset($details->first_name) || isset($details->last_name) ) : ?>
                            <li id="name"><?php if(isset($details->first_name)) echo $details->first_name; ?>
                                <?php if(isset($details->last_name)) echo $details->last_name; ?></li>
                            <?php endif; ?>
                            <?php if( isset($details->email)) : ?><li id="email"><a
                                    href="mailto:<?php echo esc_attr($details->email) ?>"><?php echo $details->email; ?></a>
                            </li>
                            <?php endif; ?>
                            <?php if( isset($details->phone)) : ?><li id="phone"><a
                                    href="tel:<?php echo esc_attr($details->phone) ?>"><?php echo $details->phone; ?></a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <?php if( isset($details->service) && !empty($details->service)) : ?>
                    <div class="directorist-inner__booking-list">
                        <h5 class="directorist-inner__h5title"><?php esc_html_e('Extra Services:', 'directorist-booking'); ?></h5>
                        <?php echo wpautop( $details->service); ?>
                    </div>
                    <?php endif; ?>
                    <?php if( isset($details->message) && !empty($details->message)) : ?>
                    <div class="directorist-inner__booking-list">
                        <h5 class="directorist-inner__h5title"><?php esc_html_e('Message:', 'directorist-booking'); ?></h5>
                        <div class="directorist-inner__msg">
                            <?php echo wpautop( $details->message); ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div class="directorist-inner__booking-list">
                        <h5 class="directorist-inner__h5title"><?php esc_html_e('Booking requested on:', 'directorist-booking'); ?></h5>
                        <ul class="directorist-booking-list">
                            <li class="directorist-highlighted" id="price">
                                <?php 
                                    $created_timestamp = strtotime($value['created']);
                                    echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), $created_timestamp);
                                ?> 
                            </li> 
                        </ul> 
                    </div>
                </div> 
                <div class="directorist-booking-list-actions">

                    <?php if( ( $value['price'] > 0 && ! empty( $enable_payment ) && empty( $value['order_id'] ) && 'directorist' == $booking_payment_type ) || ( $value['price'] > 0 && ! empty( $enable_payment ) && 'woocommerce' == $booking_payment_type && 'pending' == $wcc_order_status ) ) { ?>

                        <a href="<?php echo ! empty( $query_var ) ? esc_url( $query_var ) : ''; ?>" class="directorist-btn directorist-btn-success directorist-booking-list-actions__pay-now">
                        <?php esc_html_e( 'Pay Now', 'directorist-booking' ); ?>
                        </a>

                    <?php } ?>

                    <?php if( $show_reject ) : ?>

                    <a href="#" class="directorist-btn directorist-btn-sm directorist-btn-danger directorist-booking-list-action-reject"
                        id="reject_user_booking"
                        data-booking_id="<?php echo esc_attr($value['ID']); ?>"><i
                            class="sl sl-icon-close"></i>
                        <?php esc_html_e('Cancel', 'directorist-booking'); ?></a>

                    <?php endif; ?>

                    <?php if( $show_refund ) : ?>

                        <a 
                        href                = "#"
                        class               = "directorist-btn directorist-btn-sm directorist-btn-danger directorist-booking-list-action-reject" data-target = "dcl-claim-modal"
                        id                  = "refund_user_booking"
                        data-booking_author = "<?php echo esc_attr($value['bookings_author']); ?>"
                        data-owner_id       = "<?php echo esc_attr($value['owner_id']); ?>"
                        data-booking_id     = "<?php echo esc_attr($value['ID']); ?>"
                        data-user_name      = "<?php echo ! empty( $first_name ) ? esc_attr( $first_name ) : ''; ?>"
                        data-refund_amount  = "<?php echo esc_attr( $refund_amount ); ?>"
                        data-refund_desc    = "<?php echo esc_attr( $refund_desc ); ?>"
                        data-listing_id     = "<?php echo esc_attr($value['listing_id']); ?>"
                        data-user_name      = "<?php echo ! empty( $first_name ) ? esc_attr( $first_name ) : ''; ?>"
                        data-commission_id  = "<?php echo ! empty( $commission_id ) ? esc_attr( $commission_id ) : ''; ?>"
                        >
                            <i class="sl sl-icon-close"></i>
                            <?php esc_html_e('Cancel', 'directorist-booking'); ?>
                        </a>
                    <?php endif; ?>

                </div>
                </div>
            </div>
        </div>
    </div>