

	<?php do_action( 'wallet_dashboard_before_content' ); ?>

<div class="directorist-wallet-wrap">
	<div class="directorist-row">
		<div class="directorist-col-12">
			<?php
			$html = sprintf( '<h2 class="directorist-wallet-title">%s</h2>', __( 'Wallet', 'directorist-booking' ) );
			echo apply_filters( 'wallet_dashboard_content_area_title', $html );
			?>
			<div class="directorist-wallet-card-list">
				<div class="directorist-card directorist-card-wallet directorist-wallet-balance">
					<span class="directorist-card-wallet__amount">
					<?php
					echo ! empty( $total_available_amount ) ? $total_available_amount : 0;
					?>
					</span>
					<span class="directorist-card-wallet__type"><?php _e( 'Available Balance', 'directorist-booking' ); ?></span>
				</div>
				<div class="directorist-card directorist-card-wallet directorist-wallet-earning">
					<span class="directorist-card-wallet__amount">
					<?php
					echo ! empty( $total_earning ) ? $total_earning : 0;
					?>
					</span>
					<span class="directorist-card-wallet__type"><?php _e( 'Total Earnings', 'directorist-booking' ); ?></span>
				</div>
				<div class="directorist-card directorist-card-wallet directorist-wallet-orders">
					<span class="directorist-card-wallet__amount">
					<?php
					echo ! empty( $total_orders ) ? $total_orders : 0;
					?>
					</span>
					<span class="directorist-card-wallet__type"><?php _e( 'Total Orders', 'directorist-booking' ); ?></span>
				</div>
			</div><!-- ends: .directorist-wallet-card-list -->

			<div class="directorist-wallet-table">
				<div class="directorist-wallet-table__top">
					<h3><?php _e( 'Earnings', 'directorist-booking' ); ?></h3><span><?php _e( 'Fee', 'directorist-booking' ); ?>: <strong><?php echo ! empty( $commission_rate ) ? $commission_rate : 0; ?>%</strong></span>
				</div>
				<div class="directorist-table-responsive">
					<table>
						<thead>
							<tr>
								<th><?php _e( 'Items', 'directorist-booking' ); ?></th>
								<th><?php _e( 'Order ID', 'directorist-booking' ); ?></th>
								<th><?php _e( 'Date', 'directorist-booking' ); ?></th>
								<th><?php _e( 'Price', 'directorist-booking' ); ?></th>
								<th><?php _e( 'Fee', 'directorist-booking' ); ?></th>
								<th><?php _e( 'Earnings', 'directorist-booking' ); ?></th>
								<th><?php _e( 'Status', 'directorist-booking' ); ?></th>
							</tr>
						</thead>
						<tbody>
						<?php
						if ( $all_earnings ) {
							foreach ( array_reverse( $all_earnings ) as $earning ) {
								?>
								<tr>
									<td><?php echo ! empty( $earning['listing_name'] ) ? $earning['listing_name'] : ''; ?></td>
									<td>#<?php echo ! empty( $earning['order_id'] ) ? $earning['order_id'] : ''; ?></td>
									<td><span class="directorist-wallet-table-date"><?php echo ! empty( $earning['date'] ) ? $earning['date'] : ''; ?></span></td>
									<td><?php echo ! empty( $earning['amount'] ) ? atbdp_display_price( $earning['amount'], false, '', '', '', false ) : ''; ?></td>
									<td><?php echo ! empty( $earning['site_fee'] ) ? atbdp_display_price( $earning['site_fee'], false, '', '', '', false ) : ''; ?></td>
									<td><?php echo ! empty( $earning['earning'] ) ? atbdp_display_price( $earning['earning'], false, '', '', '', false ) : ''; ?></td>
									<td><?php echo ! empty( $earning['status'] ) ? $earning['status'] : ''; ?></td>
								</tr>
								<?php
							}
						}
						?>
						</tbody>
					</table>
				</div>
				<div class="directorist-wallet-table__pagination">
					<!-- Pagination markup goes here -->
				</div>
			</div><!-- ends: .directorist-wallet-table -->
		</div>
		<div class="directorist-col-lg-6">
			<div class="directorist-wallet-table directorist-wallet-table-payout-history">
				<div class="directorist-wallet-table__top">
					<h3><?php _e( 'Payout History', 'directorist-booking' ); ?></h3>
				</div>
				<div class="directorist-table-responsive">
					<table>
						<thead>
							<tr>
								<th><?php _e( 'Amount', 'directorist-booking' ); ?></th>
								<th><?php _e( 'Payout Method', 'directorist-booking' ); ?></th>
								<th><?php _e( 'Date', 'directorist-booking' ); ?></th>
							</tr>
						</thead>
						<tbody>
							<?php
							if ( $payouts->have_posts() ) {
								while ( $payouts->have_posts() ) :
									$payouts->the_post();
									$username = get_post_meta( get_the_ID(), '_username', true );
									if ( $author_name == $username ) {
										$amount         = get_post_meta( get_the_ID(), '_total_balance_pay', true );
										$payment_method = get_post_meta( get_the_ID(), '_method', true );
										
										$t           = get_the_time( 'U' );
										$date_format = get_option( 'date_format' );
										$date        = date_i18n( $date_format, $t );
										?>
									<tr>
										<td><?php echo ! empty( $amount ) ? atbdp_display_price( $amount, false, '', '', '', false ) : ''; ?></td>
										<td><?php echo ! empty( $payment_method ) ? esc_html( $payment_method ) : 'No Payment Method'; ?></td>
										<td><span class="directorist-wallet-table-date"><?php echo ! empty( $date ) ? esc_html( $date ) : ''; ?></span></td>
									</tr>
										<?php
									}
							  endwhile;
								wp_reset_query();
							}
							?>
						</tbody>
					</table>
				</div>
				<div class="directorist-wallet-table__pagination">
					<!-- Pagination markup goes here -->
				</div>
			</div><!-- ends: .directorist-wallet-table -->
		</div>
		<?php
			$current_user          = wp_get_current_user();
			$payment_method        = get_user_meta( $current_user->ID, 'bdb_payment_method', true );
			$paypal_checked        = ( ! empty( $payment_method ) && 'paypal' == $payment_method ) ? 'checked' : '';
			$bank_transfer_checked = ( ! empty( $payment_method ) && 'bank_transfer' == $payment_method ) ? 'checked' : '';
			$bdb_other_checked     = ( ! empty( $payment_method ) && 'bdb_other' == $payment_method ) ? 'checked' : '';
			$paypal_email          = get_user_meta( $current_user->ID, 'bdb_paypal_email', true );
			$bank_details          = get_user_meta( $current_user->ID, 'bdb_bank_details', true );
			$other_details         = get_user_meta( $current_user->ID, 'bdb_other_details', true );
			$payout_methods 	   = get_terms( [ 'taxonomy' => 'bdb_payout_method', 'hide_empty' => false, ] );
			$user_id    		   = get_current_user_id();    
			//$method_details 	   = get_user_meta( $user_id, '_payout_methods', true );
			
		?>
		<div class="directorist-col-lg-6">
			<div class="directorist-card directorist-wallet-payment-method">
				<div class="directorist-card__header directorist-wallet-payment-method__title">
					<h3><?php _e( 'Payout Method', 'directorist-booking' ); ?></h3>
				</div>

				<div class="directorist-card__body">
					<?php 
						if( ! empty( $payout_methods ) ) {
					?>
					<form id="ddm_process_payout">
					<input type="hidden" name="commission_id" value="<?php echo ! empty( $commission_id ) ? $commission_id : 0; ?>" />
					<?php
					
						foreach( $payout_methods as $key => $method ) { ?>
							<div class="directorist-wallet-payment-method__card">
								<div class="directorist-wallet-payment-method__input">
									<div class="directorist-radio directorist-radio-circle">
										<input type="radio" name="method" <?php echo $key === 0 ? esc_attr( 'checked' ) : ''; ?> id="<?php echo esc_attr( $method->slug ); ?>" value="<?php echo esc_attr( $method->slug ); ?>">
										<label for="<?php echo esc_attr( $method->slug ); ?>" class="directorist-radio__label"><?php echo esc_html( $method->name ); ?></label>
									</div>
									<p class="directorist-wallet-payment-method__desc"><small><?php echo esc_attr( $method->description ); ?></small></p>
								</div>
								<div class="directorist-wallet-payment-method__fields">
									<div class="directorist-form-group">
										<textarea name="payment_method_details[<?php echo esc_attr( $method->slug ); ?>]" id="<?php echo esc_attr( $method->slug ); ?>" class="directorist-form-element ddm_payment_method_details"><?php echo !empty( $method_details[$method->slug] ) ? esc_attr( $method_details[$method->slug] ) : ''; ?></textarea>
									</div>
								</div>
							</div><!-- ends: .directorist-wallet-payment-method__card -->
						<?php } ?>
						<p id="ddm_notice_board"></p>
						<button class="directorist-btn directorist-btn-md directorist-btn-primary directorist-booking-btn-save-card" id="ddm_submit_payment_method" type="submit"><?php _e( 'Save', 'directorist' ); ?></button>
					</form>
					<?php } else { ?>
						<?php esc_html_e( 'No method found!', 'directorist-booking' ); ?>
					<?php } ?>		
				</div>
			</div>
		</div>
	</div>
</div><!-- ends: .wallet-wrapper -->
<?php do_action( 'wallet_dashboard_after_content' ); ?>
