<?php
// get user email
$current_user = wp_get_current_user();
$email        = ! empty( $booking_info->email ) ? $booking_info->email : $current_user->user_email;
$first_name   = ! empty( $booking_info->first_name ) ? $booking_info->first_name : $current_user->first_name;
$phone        = ! empty( $booking_info->phone ) ? $booking_info->phone : get_user_meta( $current_user->ID, 'atbdp_phone', true);
$message      = ! empty( $booking_info->message ) ? $booking_info->message : '';
$last_name    = $current_user->last_name;
$full_name    = $current_user->display_name;
// get meta of listing
$listing_data         = get_post_meta( $data['listing_id'] );
$gallery              = get_post_meta( $data['listing_id'], '_listing_prv_img', true );
$prv_image_full       = wp_get_attachment_image_src(!empty($gallery) ? $gallery : '', 'full');
$payment_booking      = get_post_meta( $data['listing_id'], '_bdb_payment_booking', true );
$reservation_fee      = get_post_meta( $data['listing_id'], '_bdb_reservation_fee', true );
$checkout_page        = ( ! empty( $payment_booking ) ) ? true : false;
$url                  = ATBDP_Permalink::get_checkout_page_link($data['listing_id']);
$guest_booking        = get_directorist_option( 'bdb_guest_booking' );
$booking_payment_type = get_directorist_option( 'booking_payment_type', 'directorist' );
$confirmation_class   = ( 'directorist' == $booking_payment_type ) ? 'directorist-payment' : 'bdb-woocommerce-payment';

$show_date = 'event' != $data['listing_type'] ? true : false;
$show_date = apply_filters( 'directorist_booking_show_date_on_confirmation_page', $show_date );
?>
<div class="directorist-confirm-ticket">
    <div class="directorist-confirm-ticket__summary">
        <!-- Booking Summary -->
        <div class="directorist-confirm-top">
            <?php if( $prv_image_full ) { ?>
                <div class="directorist-confirm__img">
                    <img src="<?php echo !empty($prv_image_full) ? $prv_image_full[0] : ''; ?>" alt="" >
                </div>
            <?php } ?>

            <div class="directorist-confirm__details">
                <h3><?php echo get_the_title($data['listing_id']); ?></h3>
                <?php
                    $currency = get_directorist_option('g_currency', 'USD');
                    $currency_position = get_directorist_option('g_currency_position', 'before');
                    $currency_symbol = atbdp_currency_symbol($currency);
                    ?>
                <ul>
                    <?php if( $show_date && empty( $booking_data ) ) { ?>
                    <li>
                        <span class="la la-calendar-check-o"></span>
                        <?php esc_html_e('Date :', 'directorist-booking'); ?>
                        <span><?php echo date(get_option( 'date_format' ), strtotime( $data['date_start'] ) ); ?><?php if (isset($data['date_end']) && $data['date_start'] != $data['date_end']) echo '<b> - </b>' . date(get_option( 'date_format' ), strtotime($data['date_end'])); ?></span>
                    </li>
                    <?php if (isset($data['_hour'])) { ?>
                    <li><span class="la la-clock-o"></span> <?php esc_html_e('Time :', 'directorist-booking'); ?>
                        <span><?php echo $data['_hour']; ?></span></li><?php } ?>
                    <?php if (isset($data['adults']) && !empty($data['adults'])) {
                                $adults = trim($data['adults'], 'Guest');
                                ?>
                    <li>
                        <span class="la la-users"></span> <?php esc_html_e('Guests :', 'directorist-booking'); ?>
                        <span><?php if (!empty($adults)) echo $data['adults'];
                                        if (isset($data['childrens'])) echo $data['childrens'] . ' Childrens ';
                                        ?></span></li>
                    <?php }
                        }
                        ?>
                    <?php if ( isset( $data['tickets'] )) { ?>
                    <li><span class="la la-ticket-alt"></span><?php esc_html_e('Ticket :', 'directorist-booking'); ?>
                        <span><?php if ( isset( $data['tickets'] ) ) echo $data['tickets'];

                                    ?></span></li>
                    <?php } ?>
                    <?php if( $data['price'] > 0 ): ?>
                    <li class="total-costs"><span class="la la-money"></span>
                        <?php esc_html_e('Total Cost', 'directorist-booking'); ?><span>
                            <?php if($currency_position == 'before') { echo $currency_symbol.' '; } echo atbdp_format_payment_amount($data['price']); if($currency_position == 'after') { echo ' '.$currency_symbol; } ?></span>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>
    <div class="directorist-confirm-ticket__contents">
        <h3><?php echo apply_filters('booking_confirmation_title',__('Personal Details', 'directorist-booking')) ?>
        </h3>
        <form id="booking-confirmation" action="<?php echo !empty($checkout_page) ? $url : '';?>" method="POST"
            role="form">
            <input type="hidden" name="confirmed" value="<?php echo ! empty( $booking_data ) ? 'updated' : 'done'; ?>" />
            <input type="hidden" name="price" value="<?php echo ! empty( $data['price'] ) ? $data['price'] : ''; ?>" />
            <input type="hidden" name="value" value="<?php echo ! empty( $data['submitteddata'] ) ? $data['submitteddata'] : ''; ?>" />
            <input type="hidden" name="user_id" value="<?php echo $current_user->ID; ?>" />
            <input type="hidden" name="owner_id" value="<?php echo get_post_field( 'post_author', $data['listing_id'] ); ?>" />
            <input type="hidden" name="booking_id" value="<?php echo ! empty( $_GET['booking-id'] ) ? esc_attr( $_GET['booking-id'] ) : ''; ?>" />
            <div class="directorist-form-ticket">

                <div class="directorist-form-ticket__list">
                    <label><?php esc_html_e('Full Name', 'directorist-booking'); ?> *</label>
                    <input type="text" name="firstname" id="first_name" value="<?php esc_html_e($full_name); ?>" <?php echo ! empty( $_GET['booking-id'] ) ? "disabled" : ""; ?>>
                </div>

                <div class="directorist-form-ticket__list">
                    <div class="input-with-icon medium-icons">
                        <?php directorist_icon( 'las la-envelope' ); ?>
                        <label><?php esc_html_e('E-Mail Address', 'directorist-booking'); ?> *</label>
                        <input type="text" name="email" id="email" value="<?php esc_html_e($email); ?>" <?php echo ! empty( $_GET['booking-id'] ) ? "disabled" : ""; ?>>
                    </div>
                </div>

                <div class="directorist-form-ticket__list">
                    <div class="input-with-icon medium-icons">
                        <?php directorist_icon( 'las la-phone' ); ?>
                        <label><?php esc_html_e('Phone', 'directorist-booking'); ?></label>
                        <input type="text" name="phone"
                            value="<?php esc_attr_e( $phone ); ?> " <?php echo ! empty( $_GET['booking-id'] ) ? "disabled" : ""; ?>>
                    </div>
                </div>

                <div class="directorist-form-ticket__list">
                    <label><?php esc_html_e('Message', 'directorist-booking'); ?></label>
                    <textarea maxlength="200" name="message"
                        placeholder="<?php esc_html_e('Your short message to the listing owner (optional)','directorist-booking'); ?>"
                        id="booking_message" cols="20" rows="3" <?php echo ! empty( $_GET['booking-id'] ) ? "disabled" : ""; ?>>
                        <?php echo $message ?>
                    </textarea>
                </div>

                <p class='directorist-confirmation-error'></p>

                <input type="hidden" name='guest_booking' id='guest_booking'
                    value='<?php echo ! empty( $guest_booking ) && ! is_user_logged_in() ? 'yes' : ''; ?>'>
                <a href="#" class="booking-confirmation-btn <?php echo $confirmation_class; ?>">
                    <div class="loadingspinner"></div><span class="book-now-text"><?php
                        !empty($payment_booking == 'on') ? esc_html_e('Confirm', 'directorist-booking') : esc_html_e('Confirm', 'directorist-booking') ;
                        ?></span>
                </a>
        </form>
    </div>
</div>