/* eslint-disable */
(function ($) {
	$(document).ready(function () {
		function triggerBooking() {
			var inputClicked = false;
			$('body').on('click', 'a.directorist-payment', function (e) {
				const button = $(this);
				button.addClass('loading');

				e.preventDefault();
				
				// full name validation
				const first_name = $("input[name='firstname']").val();
				const email = $("input[name='email']").val();
				var guest_booking = $("input[name='guest_booking']").val();
				if (first_name === '') {
					$('#first_name').css('border-color', 'red');
					return false;
				}
				// email validation
				if (email === '') {
					$('#email').css('border-color', 'red');
					return false;
				}
				if (guest_booking == 'yes') {
					$.ajax({
						type: 'POST',
						dataType: 'json',
						url: bdb_booking.ajax_url,
						data: {
							action: 'guest_booking',
							guest_email: email
						},
						success(data) {
							if (data.error_msg) {
								$('.directorist-confirmation-error').html(data.error_msg);
							} else {
								$('#booking-confirmation').submit();
							}
						}
					});
				} else {
					$('#booking-confirmation').submit();
				}



			});

			$('body').on('click', 'a.bdb-woocommerce-payment', function (e) {
				const button = $(this);
				button.addClass('loading');

				e.preventDefault();
				let first_name     = $("input[name='firstname']").val();
				let email	   	   = $("input[name='email']").val();
				let user_id	   	   = $("input[name='user_id']").val();
				let owner_id	   = $("input[name='owner_id']").val();
				let price	   	   = $("input[name='price']").val();
				let value	       = $("input[name='value']").val();
				let confirmed      = $("input[name='confirmed']").val();
				let booking_id     = $("input[name='booking_id']").val();
				$.ajax({
					type: 'POST',
					dataType: 'json',
					url: bdb_booking.ajax_url,
					data: {
						action: 'bdb_wcc_payment',
						first_name: first_name,
						email: email,
						user_id : user_id,
						owner_id : owner_id,
						price : price,
						value : value,
						confirmed : confirmed,
						booking_id : booking_id,
					},
					success( data ) {
						console.log( data );
						
						top.location.replace( data );
						if (data.error_msg) {
							$('.directorist-confirmation-error').html(data.error_msg);
						} else {
							//$('#booking-confirmation').submit();
						}
					}
				});

			});

			$('body').on('click', 'a.directorist-book-now', function (e) {
				const button = $(this);
				if (inputClicked == false) {
					$('.directorist-booking-time-picker,.directorist-booking-time-slots-dropdown,.date-picker-listing-rental').addClass(
						'bounce'
					);
				} else {
					button.addClass('loading');
				}
				e.preventDefault();

				const freeplaces = button.data('freeplaces');

				setTimeout(function () {
					button.removeClass('loading');
					$('.directorist-booking-time-picker,.directorist-booking-time-slots-dropdown,.date-picker-listing-rental').removeClass(
						'bounce'
					);
				}, 3000);

				try {
					if (freeplaces > 0) {
						
						// preparing data for ajax
						let startDataSql = moment(
							$('#date-picker').data('daterangepicker').startDate,
							['MM/DD/YYYY']
						).format('YYYY-MM-DD');
						let endDataSql = moment($('#date-picker').data('daterangepicker').endDate, [
							'MM/DD/YYYY',
						]).format('YYYY-MM-DD');

						var ajax_data = {
							listing_type: $('#listing_type').val(),
							listing_id: $('#listing_id').val(),
							// 'nonce': nonce
						};
						if (startDataSql) ajax_data.date_start = startDataSql;
						if (endDataSql) ajax_data.date_end = endDataSql;
						if ($('input#slot').val()) ajax_data.slot = $('input#slot').val();
						if ($('.directorist-booking-time-picker').val()) ajax_data._hour = $('.directorist-booking-time-picker').val();
						if ($('.adults').text()) ajax_data.adults = $('.adults').text();
						if ($('.childrens').val()) ajax_data.childrens = $('.childrens').val();
						if ($('#tickets').text()) ajax_data.tickets = $('#tickets').text();
						if(  ajax_data.adults === 'Guest' ) {
							$('.directorist-booking-error-msg')
							.css('display', 'block')
							.text('Guest field is required');
						} else {
							var services = [];
							$.each($("input[name='_service[]']:checked"), function () {
								services.push($(this).val());
							});
							ajax_data.services = services;
							$('input#booking').val(JSON.stringify(ajax_data));
							$('#form-booking').submit();
						}
					}
				} catch (e) {
					console.log(e);
				}

				if ($('#listing_type').val() == 'event') {
					var ajax_data = {
						listing_type: $('#listing_type').val(),
						listing_id: $('#listing_id').val(),
						// 'nonce': nonce
					};
					var services = [];
					$.each($("input[name='_service[]']:checked"), function () {
						services.push($(this).val());
					});
					ajax_data.services = services;
					var datepicker; 
					if( $('#date-picker').length) { 
						datepicker = $('#date-picker');
					}
						console.log(datepicker)

					let startDataSql = '1970-01-01';
					let endDataSql = '1970-01-01';

					if( datepicker !== undefined ) {
						startDataSql = moment(
							datepicker.data('daterangepicker').startDate,
							['MM/DD/YYYY']
						).format('YYYY-MM-DD');
						endDataSql = moment(datepicker.data('daterangepicker').endDate, [
							'MM/DD/YYYY',
						]).format('YYYY-MM-DD');
					}
					
					// converent data
					if (startDataSql) ajax_data.date_start = startDataSql;
					if (endDataSql) ajax_data.date_end = endDataSql;
					
					if ($('#tickets').text()) ajax_data.tickets = $('#tickets').text();
					$('input#booking').val(JSON.stringify(ajax_data));
					if ($('#tickets').text() && $('#tickets').text() !== 'Qty') {
						$('#form-booking').submit();
					}
				}
			});

			$('.directorist-booking-date-picker-service').each(function (id, el) {
				$(el).daterangepicker({
					opens: 'left',
					singleDatePicker: ($(this).attr('booking_type') == 'rent' ? false : true),
					timePicker: false,
					minDate: moment().subtract(0, 'days'),
					autoApply: true,
					locale: {
						format: 'MM/DD/YYYY',
						firstDay: parseInt(wordpress_data_format.day),
						applyLabel: bdb_booking.applyLabel,
						cancelLabel: bdb_booking.cancelLabel,
						fromLabel: bdb_booking.fromLabel,
						toLabel: bdb_booking.toLabel,
						customRangeLabel: bdb_booking.customRangeLabel,
						daysOfWeek: [
							bdb_booking.day_short_su,
							bdb_booking.day_short_mo,
							bdb_booking.day_short_tu,
							bdb_booking.day_short_we,
							bdb_booking.day_short_th,
							bdb_booking.day_short_fr,
							bdb_booking.day_short_sa,
						],
						monthNames: [
							bdb_booking.month_short_jan,
							bdb_booking.month_short_feb,
							bdb_booking.month_short_mar,
							bdb_booking.month_short_apr,
							bdb_booking.month_short_may,
							bdb_booking.month_short_jun,
							bdb_booking.month_short_jul,
							bdb_booking.month_short_aug,
							bdb_booking.month_short_sep,
							bdb_booking.month_short_oct,
							bdb_booking.month_short_nov,
							bdb_booking.month_short_dec
						],
					},
					isInvalidDate: function (date) {
						// working only for rental
						if (typeof disabedDates == 'undefined') return false;
						if (disabedDates) {
							if (jQuery.inArray(date.format("YYYY-MM-DD"), disabedDates) !== -1) return true;
						}

					}
				});
			});

			var inputClicked = false;

			function directorist_booking_availability() {

				inputClicked = true;
				var bookingType = $(this).attr("booking_type");
				if (bookingType != 'rent' && !$('input#slot').val() && !$('.directorist-booking-time-picker').val()) {
					$('#negative-feedback').fadeIn();

					return;
				}

				const startDataSql = moment($('#date-picker').data('daterangepicker').startDate, [
					'MM/DD/YYYY',
				]).format('YYYY-MM-DD');
				const endDataSql = moment($('#date-picker').data('daterangepicker').endDate, [
					'MM/DD/YYYY',
				]).format('YYYY-MM-DD');

				// preparing data for ajax
				const ajax_data = {
					action: 'checking_booking_availability',
					listing_id: $('input#listing_id').val(),
					date_start: startDataSql,
					date_end: endDataSql,
					// 'nonce': nonce
				};

				if ($('input#slot').val()) ajax_data.slot = $('input#slot').val();
				if ($('input.adults').val()) ajax_data.adults = $('input.adults').val();
				if ($('.directorist-booking-time-picker').val()) ajax_data.hour = $('.directorist-booking-time-picker').val();

				// loader class
				$('a.directorist-book-now').addClass('loading');
				$('a.book-now-notloggedin').addClass('loading');
				$.ajax({
					type: 'POST',
					dataType: 'json',
					url: bdb_booking.ajax_url,
					data: ajax_data,

					success(data) {
						// loader class
						if (data.success == true) {
							if (data.data.free_places > 0) {
								$('a.directorist-book-now').data('freeplaces', data.data.free_places);
								$('.directorist-booking-error-msg').fadeOut();
								$('a.directorist-book-now').removeClass('inactive');
								if (data.data.price) {
									if (bdb_booking.currency_position == 'before') {
										$('.directorist-booking-estimated-cost span').html(
											`${bdb_booking.currency_symbol} ${
																					data.data.price
																			}`
										);
									} else {
										$('.directorist-booking-estimated-cost span').html(
											`${data.data.price} ${
																					bdb_booking.currency_symbol
																			}`
										);
									}

									$('.directorist-booking-estimated-cost').fadeIn();
								}
							} else {
								$('a.directorist-book-now').data('freeplaces', 0);
								$('.directorist-booking-error-msg').fadeIn();

								$('.directorist-booking-estimated-cost').fadeOut();

								$('.directorist-booking-estimated-cost span').html('');
							}
						} else {
							$('a.directorist-book-now').data('freeplaces', 0);
							$('.directorist-booking-error-msg').fadeIn();

							$('.directorist-booking-estimated-cost').fadeOut();
						}
						$('a.directorist-book-now').removeClass('loading');
						$('a.book-now-notloggedin').removeClass('loading');
					},
				});
			}

			let lastDayOfWeek;

			function update_directorist_booking() {
				$('a.directorist-book-now').addClass('loading');
				const date = $('#date-picker').data('daterangepicker').endDate._d;
				let dayOfWeek = date.getDay() - 1;

				if (date.getDay() == 0) {
					dayOfWeek = 6;
				}

				const startDate = moment($('#date-picker').data('daterangepicker').startDate, [
					'MM/DD/YYYY',
				]).format('YYYY-MM-DD');
				const endDate = moment($('#date-picker').data('daterangepicker').endDate, [
					'MM/DD/YYYY',
				]).format('YYYY-MM-DD');
				const ajax_data = {
					action: 'update_booking_slots',
					listing_id: $('input#listing_id').val(),
					date_start: startDate,
					date_end: endDate,
					slot: dayOfWeek,
				};
				$.ajax({
					type: 'POST',
					dataType: 'json',
					data: ajax_data,
					url: bdb_booking.ajax_url,

					success(data) {
						$('.directorist-booking-time-slots-dropdown .directorist-booking-panel-dropdown-scrollable').html(data.data);

						if (dayOfWeek != lastDayOfWeek) {
							$('.directorist-booking-panel-dropdown-scrollable .time-slot input').prop(
								'checked',
								false
							);

							$('.directorist-booking-panel-dropdown.directorist-booking-time-slots-dropdown input#slot').val('');
							$('.directorist-booking-panel-dropdown.directorist-booking-time-slots-dropdown a').html(
								$('.directorist-booking-panel-dropdown.directorist-booking-time-slots-dropdown a').attr(
									'data-placeholder'
								)
							);
							$(' .directorist-booking-estimated-cost span').html(' ');
						}
						lastDayOfWeek = dayOfWeek;

						if (!$(`.directorist-booking-panel-dropdown-scrollable .time-slot[data-day='${dayOfWeek}']`).length) {

							$('.directorist-booking-panel-dropdown.directorist-booking-time-slots-dropdown a').html($('.directorist-booking-no-slots').html());
						} else {
							// when we dont have slots for this day reset cost and show no slots
							$('.directorist-booking-no-slots').hide();
							$(' .directorist-booking-estimated-cost span').html(' ');
						}
						// show only slots for this day
						$('.directorist-booking-panel-dropdown-scrollable .time-slot').hide();

						$(`.directorist-booking-panel-dropdown-scrollable .time-slot[data-day='${dayOfWeek}']`).show();
						$('.time-slot').each(function () {
							const timeSlot = $(this);
							$(this).find('input')
								.on('change', function () {
									const timeSlotVal = timeSlot.find('strong').text();
									const slotArray = [
										timeSlot.find('strong').text(),
										timeSlot.find('input').val(),
									];

									$(
										'.directorist-booking-panel-dropdown.directorist-booking-time-slots-dropdown input#slot'
									).val(JSON.stringify(slotArray));

									$('.directorist-booking-panel-dropdown.directorist-booking-time-slots-dropdown a').html(
										timeSlotVal
									);
									$('.directorist-booking-panel-dropdown').removeClass('active');

									directorist_booking_availability();
								});
						});
						$('a.directorist-book-now').removeClass('loading');
						$('a.book-now-notloggedin').removeClass('loading');
					},
				});
				let is_open = true;
				if ($('.directorist-booking-time-picker').length) {
					//console.log(availableDays[dayOfWeek]);
					if (availableDays) {
						const availableDaysHours = availableDays[dayOfWeek];
						const currentHourArr = [];
						const availableTime = [];
						if (availableDaysHours) {
							$('.directorist-booking-time-picker-wrap').show();
							availableDaysHours.forEach(function (hour, index) {
								const opening_hour = moment(hour.start, ['h:mm:ss a']).format();
								const closing_hour = moment(hour.close, ['h:mm A']).format();
								const availableOpen = moment(hour.start, ['h:mm A']).format(
									'h:mm a'
								);
								const availableClose = moment(hour.close, ['h:mm A']).format(
									'h:mm a'
								);
								if (opening_hour < closing_hour) {
									console.log("clear");
								}
								const availableValue = `${availableOpen} - ${availableClose}`;

								const checking_open = moment(hour.start, ['h:mm A']).format(
									'HH:MM'
								);
								const checking_close = moment(hour.close, ['h:mm A']).format(
									'HH:MM'
								);
								// get hour in 24 format
								const current_hour = $('.directorist-booking-time-picker').val();
								// check if current hour bar is open
								if (
									current_hour >= checking_open &&
									current_hour <= checking_close
								) {
									currentHourArr.push(true);
								} else {
									currentHourArr.push(false);
								}
								availableTime.push(availableValue);
								if (availableTime.length) {
									let content = '<div>';
									availableTime.forEach(function (value, index) {
										content += `<span class="directorist-available-time">${value}</span>`;
									});
									content += '</div>';
									$('.directorist-available-time-list').html(content);
								}
							});
							if (currentHourArr.includes(true)) {
								is_open = true;
								$('a.directorist-book-now').show();
								$('.directorist-available-time-block').show();
								$('a.directorist-book-now').removeClass('db-not-available');
								$('a.directorist-book-now').addClass('db-available');
								$('#negative-feedback').fadeOut();
								directorist_booking_availability();
							} else {
								is_open = false;
								$('#negative-feedback').fadeIn();
								$('.directorist-available-time-block').show();
								$('.directorist-booking-estimated-cost span').html('');
								$('a.directorist-book-now').removeClass('db-available');
								$('a.directorist-book-now').addClass('db-not-available');
								$('a.directorist-book-now').hide();
							}
						} else {
							is_open = false;
							$('#negative-feedback').fadeIn();
							$('.directorist-booking-estimated-cost span').html('');
							$('a.directorist-book-now').removeClass('db-available');
							$('a.directorist-book-now').addClass('db-not-available');
							$('a.directorist-book-now').hide();
							$('.directorist-available-time-block').hide();

						}
					}
				}
			}


			// if slots exist update them
			if ($('.time-slot').length) {
				update_directorist_booking();
			}

			// if slots exist update them
			if ($('.directorist-booking-time-picker').length) {
				update_directorist_booking();
			}
			$('body').on('change', '.directorist-booking-time-picker', function () {
				update_directorist_booking();
			});

			// show only services for actual day from date picker
			$('#date-picker').on('apply.daterangepicker', update_directorist_booking);

			// when slot is selected check if there are available bookings
			$('#date-picker').on('apply.daterangepicker', directorist_booking_availability);
			$('#date-picker').on('cancel.daterangepicker', directorist_booking_availability);

			$('.directorist-booking-ts-dropdown-toggle').on('click', function (e) {
				e.preventDefault();
				$('.directorist-booking-panel-dropdown-content').toggleClass('directorist-booking-pdc-active');
			});
			$('.directorist-booking-panel-dropdown-content').on('click', '.time-slot', function (e) {
				$('.directorist-booking-panel-dropdown-content').removeClass('directorist-booking-pdc-active');
			});

			// flatpicker time picker
			const currentDate = new Date();
			const currentHour = currentDate.getHours();
			const currentMin = currentDate.getMinutes();
			if ($('.directorist-booking-time-picker-wrap input.directorist-booking-time-picker').length) {
				$('.directorist-booking-time-picker-wrap input.directorist-booking-time-picker').flatpickr({
					enableTime: true,
					noCalendar: true,
					dateFormat: 'H:i',
					defaultHour: currentHour,
					defaultMinute: currentMin,
					time_24hr: true,
				});
			}
			$('.directorist-booking-event-tickets .atbd-dropdown-item').on('click', function () {
				var count_ticket = $(this).attr('data-id');
				var reservation_fee = $(this).attr('data-fee');
				var price = $(this).attr('data-price');
				var total_price = (price * count_ticket) + parseFloat(reservation_fee);

				if (reservation_fee || price) {
					$('.directorist-booking-estimated-cost').fadeIn();
					if (bdb_booking.currency_position == 'before') {
						$('.directorist-booking-estimated-cost span').html(`${bdb_booking.currency_symbol} ${total_price}`);
					} else {
						$('.directorist-booking-estimated-cost span').html(
							`${reservation_fee} ${
											bdb_booking.currency_symbol
									}`
						);
					}
				}
				$('.atbd-dropdown-items').hide();
			});

			$('.atbd-drop-select .atbd-dropdown-item').on('click', function () {
				$('.directorist-dropdown__links').hide();
			});

			// get data-id
			const ticketsId = document.getElementById('tickets');
			document.querySelectorAll('.directorist-booking-event-tickets .atbd-dropdown-item').forEach(function (item) {
				const items = item.getAttribute('data-id');
				var pExt = '<span>s</span>';
				item.addEventListener('click', function () {
					$(this)
						.parent()
						.prev(ticketsId)
						.attr('data-id', `${items}`);
					if ($(this).parent().prev(ticketsId).attr('data-id') > 1 && $('.directorist-book-now').children('span').length === 0) {
						$('.directorist-book-now').each(function (id, elm) {
							$(elm).append(pExt);
						});
					} else if ($(this).parent().prev(ticketsId).attr('data-id') <= 1 && $('.directorist-book-now').children('span').length) {
						$('.directorist-book-now').each(function (id, elm) {
							$(elm).children('span').remove();
						});
					}
				});
			});

			//payment method option
			$(".atbd-payment-action").each(function (i, e) {
				$(e).on("click", function (elm) {
					elm.preventDefault();
					if ($(".atbd-payment-action").siblings("ul").hasClass("active") === true) {
						$(".atbd-payment-action").siblings("ul").removeClass("active");
					}
					$(this).siblings("ul").toggleClass("active");
				});
			});
			$("body").on("click", function (e) {
				if (!e.target.closest(".atbd-payment-action")) {
					$(".atbd-payment-action").siblings("ul").removeClass("active");
				}

			});

			//credit card number split
			$('#ccn').keyup(function () {
				var foo = $(this).val().split(" - ").join(""); // remove hyphens
				if (foo.length > 0) {
					foo = foo.match(new RegExp('.{1,4}', 'g')).join(" - ");
				}
				$(this).val(foo);
			});

			//add payment method accordion
			$(".directorist-wallet-payment-method__input input").each(function (i, e) {
				$(".directorist-wallet-payment-method__fields").slideUp();
				if ($(e).prop('checked')) {
					$(".directorist-wallet-payment-method__fields").slideUp();
					$(e).closest(".directorist-wallet-payment-method__input").siblings(".directorist-wallet-payment-method__fields").slideDown();
				}
				$(e).on("change", function () {
					if ($(this).prop('checked')) {
						$(".directorist-wallet-payment-method__fields").slideUp();
						$(this).closest(".directorist-wallet-payment-method__input").siblings(".directorist-wallet-payment-method__fields").slideDown();
					}
				});
			});

			$("#bdb_submit_payment_method").on("click", function (event) {
				event.preventDefault();
				$.ajax({
					type: "post",
					url: bdb_booking.ajax_url,
					data: {
						action: "bdb_payment_method", //calls wp_ajax_nopriv_ajaxlogin
						_nonce: $("#bdb_payment_method_nonce").val(),
						payment_method: $(".bdb_payment_method:checked").attr("value"),
						paypal_email: $("#bdb-paypal-email").val(),
						bank_details: $("#bdb-bank-details").val(),
						other: $("#bdb-other-details").val(),
					},
					beforeSend: function () {
						//$("#atbdp-send-system-info-submit").html("Sending");
					},
					success: function (data) {
						//console.log(data);
						$("#directorist-booking-payment-notice").html(data.data.success);
					},
					error: function (data) {
						console.log(data);
					},
				});
			});

			$('body').on('submit', '#ddm_process_payout', function (e) {
				//if (ddm_script_helper.is_admin) return;
				e.preventDefault();
				
				var $form = $(e.target);
				var form_data = new FormData();
				form_data.append('action', 'directoirst_digital_product_request_payout');
				//form_data.append('directorist_nonce', ddm_script_helper.directorist_nonce);
				var fieldValuePairs = $form.serializeArray(); // Append Form Fields Values
			
				var _iterator2 = _createForOfIteratorHelper(fieldValuePairs),
					_step2;
			
				try {
				  for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
					var field = _step2.value;
			
					if ('' === field.value) {
					  continue;
					}
			
					form_data.append(field.name, field.value);
				  }
				} catch (err) {
				  _iterator2.e(err);
				} finally {
				  _iterator2.f();
				}
			
				$.ajax({
				  method: 'POST',
				  processData: false,
				  contentType: false,
				  url: bdb_booking.ajax_url,
				  data: form_data,
				  success: function success(response) {
					console.log(response.message);
			
					if (response.error) {
					  $('#ddm_notice_board').empty().removeClass('ddm_success').addClass('ddm_error').append(response.message);
					} else {
					  $('#ddm_notice_board').empty().removeClass('ddm_error').addClass('ddm_success').append(response.message);
					}
				  },
				  beforeSend: function beforeSend() {
					$('#ddm_process_payout #ddm_submit_payment_method').addClass('ddm_loading');
				  },
				  complete: function complete() {
					$('#ddm_process_payout #ddm_submit_payment_method').removeClass('ddm_loading');
					setTimeout(function () {
					  $('#ddm_notice_board').empty();
					}, 1500);
				  },
				  error: function error(_error2) {
					console.log(_error2);
				  }
				});
			});

			function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

			function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

			function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

			$('.atbd-dropdown-toggle:not(#tickets)').on('click', function () {
				$(this).siblings('.atbd-dropdown-items').slideToggle();
			});

			// Hide Clicked Anywhere
			$(document).bind('click', function (e) {
				let clickedDom = $(e.target);
				if (!clickedDom.hasClass('atbd-dropdown-toggle'))
					$('.atbd-dropdown-items').slideUp();
			});

			// select data-status
			const bpStatus = document.getElementById('bdb_listing_status');
			document.querySelectorAll('.bdb-approved').forEach(function (item) {
				const items = item.getAttribute('data-status');
				item.addEventListener('click', function () {
					bpStatus.setAttribute('data-status', `${items}`);
				});
			});

			//custom select
			const atbdSelect = document.querySelectorAll('.atbd-drop-select');
			if (atbdSelect !== null) {
				atbdSelect.forEach(function (el) {
					el.querySelectorAll('.atbd-dropdown-item').forEach(function (item) {
						item.addEventListener('click', function (e) {
							e.preventDefault();
							$('.directorist-booking-error-msg').css('display', 'none');
							el.querySelector('.atbd-dropdown-toggle').textContent = item.textContent;
							el.querySelectorAll('.atbd-dropdown-item').forEach(function (elm) {
								elm.classList.remove('atbd-active');
							});
							item.classList.add('atbd-active');
						});
					});
				});
			}
		}

		triggerBooking();
		window.addEventListener('triggerBooking', triggerBooking);

		//Dashboard Calender Width on Resize Fixed
		if ($('.directorist-booking-calender__adv').innerWidth() < 800) {
			$('.directorist-booking-calender__adv').addClass('directorist-booking-calender__adv--res-fix');
		}

		//Booking check-in - check-out date range picker
		function checkInOut(){
			if ($('.directorist-booking-entry').length) {
				$('.directorist-booking-entry').daterangepicker({
					autoUpdateInput: false,
					locale: {
						format: 'MM/DD/YYYY',
						firstDay: parseInt(wordpress_data_format.day),
						applyLabel: bdb_booking.applyLabel,
						cancelLabel: bdb_booking.cancelLabel,
						fromLabel: bdb_booking.fromLabel,
						toLabel: bdb_booking.toLabel,
						customRangeLabel: bdb_booking.customRangeLabel,
						daysOfWeek: [
							bdb_booking.day_short_su,
							bdb_booking.day_short_mo,
							bdb_booking.day_short_tu,
							bdb_booking.day_short_we,
							bdb_booking.day_short_th,
							bdb_booking.day_short_fr,
							bdb_booking.day_short_sa,
						],
						monthNames: [
							bdb_booking.month_short_jan,
							bdb_booking.month_short_feb,
							bdb_booking.month_short_mar,
							bdb_booking.month_short_apr,
							bdb_booking.month_short_may,
							bdb_booking.month_short_jun,
							bdb_booking.month_short_jul,
							bdb_booking.month_short_aug,
							bdb_booking.month_short_sep,
							bdb_booking.month_short_oct,
							bdb_booking.month_short_nov,
							bdb_booking.month_short_dec
						],
					},
				});
				$('.directorist-booking-entry').on('apply.daterangepicker', function (ev, picker) {
					$(this).children('input[name="custom_field[directorist-booking-check-in]"]').val(picker.startDate.format('ddd, D MMM'));
					$(this).children('input[name="custom_field[directorist-booking-check-out]"]').val(picker.endDate.format('ddd, D MMM'));

				});
				$('.directorist-booking-entry').on('cancel.daterangepicker', function (ev, picker) {
					$(this).children('.directorist-booking-entry__data').val('');
				});
			}
		}
		checkInOut();
		window.addEventListener('directorist-search-form-nav-tab-reloaded', checkInOut);

		// To Stop Input Box Number Quickly Increasing Decreasing in Chrome
		$(document).on('mouseup', function (e) {
			e.stopPropagation()
		});

		//Excerpt Text
		function excerptDescriptionToggle() {
			var bookingDescription = document.querySelector('.directorist-booking__description .directorist-booking__info--desc .desc');
			if(bookingDescription) {
				var bookingDescriptionText = bookingDescription.innerHTML;
				var bookingDescriptionWord = bookingDescriptionText.split(/\s+/);
				var bookingDescriptionAll = document.querySelectorAll('.directorist-booking__description .directorist-booking__info--desc .desc');
				var bookingDescriptionExcerpt; 
				
				bookingDescriptionAll.forEach(function(elm){
					var parent = elm.parentNode.querySelector('.directorist-booking__info--btn');
					if(bookingDescriptionWord.length > '17') {
						parent.classList.add('visible')

						if(elm.innerHTML.length > '300') {
							bookingDescriptionExcerpt = bookingDescriptionText.slice(0, 290); 
							elm.innerHTML = bookingDescriptionExcerpt;
						}
						else if(elm.innerHTML.length > '100') {
							bookingDescriptionExcerpt = bookingDescriptionText.slice(0, 90); 
							elm.innerHTML = bookingDescriptionExcerpt;
						}
						else if(elm.innerHTML.length > '17') {
							bookingDescriptionExcerpt = bookingDescriptionText.slice(0, 16); 
							elm.innerHTML = bookingDescriptionExcerpt;
						}
					} else {
						if(parent.classList.contains('visible')) {
							parent.classList.remove('visible');
						}
					}
				})

				$('body').on('click', '.directorist-booking__info--btn', function (event) {
					var descriptionText = $(this).parent('.directorist-booking__info--desc ').find('.desc');
					descriptionText[0].innerHTML = bookingDescriptionText;
			
					this.classList.remove('visible');

					if(this.nextElementSibling) {
						this.nextElementSibling.classList.add('visible')
					}

					if(this.classList.contains('show-less')) {
						descriptionText[0].innerHTML = bookingDescriptionExcerpt;
						if(this.previousElementSibling) {
							this.previousElementSibling.classList.add('visible')
						}
					}
				});
			}
		}
		excerptDescriptionToggle();

	});
})(jQuery);