<?php
/**
 * @package  Directorist - Compare Listing
 */


/**
 * Plugin Name:       Directorist - Compare Listing
 * Plugin URI:        https://directorist.com/product/directorist-compare-listing
 * Description:       This is an extension for Directorist plugin. It helps to your visitors to choose the perfect product or service by compar the listing.
 * Version:           1.1.6
 * Requires at least: 5.2
 * Author:            wpWax
 * Author URI:        https://wpwax.com
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       directorist-compare-listing
 * Domain Path:       /languages
 */


/**
 * If this file is called directly, abrot!!!
 */
if (!defined('ABSPATH')) {
    exit;                      // Exit if accessed
}


if (!class_exists('ATDListingCompare')) {
    /**
     * Main plugin class
     */
    final class ATDListingCompare
    {
        /**
         * Created plugin Singleton instance
         *
         * @var string
         */
        private static $instance;


        /**
         * Class constructor
         * 
         * @return object ATDListingCompare 
         */
        public static function instance()
        {
            // Authenticate, is instance create or not
            if (!isset(self::$instance) && !(self::$instance instanceof ATDListingCompare)) {
                self::$instance = new ATDListingCompare();
                self::$instance->define_constant();
                self::$instance->instance_plugin_classes();               
            }

            return self::$instance;
        }



        /**
         * Define the required plugin constant
         *
         * @return void
         */
        public function define_constant()
        {
            $server = isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : '';

            define('ATDLC_COOKIES_DOMAIN', $server);
            define('ATDLC_COOKIES_NAME', 'atbdlc__selected_listings_id');
            define('ATDLC_PLUGIN_VERSION', self::get_version_from_file_content( __FILE__ ) );
            define('ATDLC_BASE_FILE', __FILE__);
            define('ATDLC_PLUGIN_DIR_PATH', dirname(__FILE__));
            define('ATDLC_PLUGIN_DIR_URL', plugin_dir_url(__FILE__));
            define('ATDLC_PLUGIN_DIRNAME', dirname(plugin_basename(__FILE__)));
            define('ATDLC_PLUGIN_TEMPLATES_DIR', dirname(__FILE__) . "/Inc/View/");
            define('ATDLC_ADMIN_CSS', ATDLC_PLUGIN_DIR_URL . "assets/admin/css/");
            define('ATDLC_ADMIN_JS', ATDLC_PLUGIN_DIR_URL . "assets/admin/js/");
            define('ATDLC_FRONTEND_CSS', ATDLC_PLUGIN_DIR_URL . "assets/frontend/css/");
            define('ATDLC_FRONTEND_JS', ATDLC_PLUGIN_DIR_URL . "assets/frontend/js/");
            // plugin author url
            if (!defined('ATBDP_AUTHOR_URL')) { define('ATBDP_AUTHOR_URL', 'https://directorist.com'); }
            // post id from download post type (edd)
            if (!defined('ATBDP_ATDLC_POST_ID')) { define('ATBDP_ATDLC_POST_ID', 26378); }
        }

         /**
         * Get version from file content
         *
         * @return string
         */
        public static function get_version_from_file_content( $file_path = '' ) {
            $version = '';
    
            if ( ! file_exists( $file_path ) ) {
                return $version;
            }
    
            $content = file_get_contents( $file_path );
            $version = self::get_version_from_content( $content );
            
            return $version;
        }

        /**
         * Get version from content
         *
         * @return string
         */
        public static function get_version_from_content( $content = '' ) {
            $version = '';
    
            if ( preg_match('/\*[\s\t]+?version:[\s\t]+?([0-9.]+)/i', $content, $v) ) {
                $version = $v[1];
            }
    
            return $version;
        }

        /**
         * Iintialize all other class of this plugin
         *
         * @return void
         */
        public function instance_plugin_classes()
        {
            require_once( dirname( __FILE__ ) . '/includes.php' );
            IncludeClasses::includes();

            $class_names = array(
                'Enqueue',
                'Activate',
                'AjaxHandler',
                'CompareButton',
                'HelperFunctions',
                'ExtensionSettings',
                'ShortcodeListingCompare'
            );

            foreach( $class_names as $class_name ){
                if( method_exists( $class_name, 'register' ) ){
                    $object = new $class_name;
                    $object->register();
                }
            }
            if (!class_exists('EDD_SL_Plugin_Updater')) {
                // load our custom updater if it doesn't already exist
                include dirname(__FILE__) . '/Inc/Controller/Base/EDD_SL_Plugin_Updater.php';
            }
            $license_key = trim( get_option( 'directorist_compare_listings_license' ) );
            new EDD_SL_Plugin_Updater( ATBDP_AUTHOR_URL, __FILE__, array(
                'version'   => ATDLC_PLUGIN_VERSION, // current version number
                'license'   => $license_key, // license key (used get_option above to retrieve from DB)
                'item_id'   => ATBDP_ATDLC_POST_ID, // id of this plugin
                'author'    => 'AazzTech', // author of this plugin
                'url'       => home_url(),
                'beta'      => false, // set to true if you wish customers to receive update notifications of beta releases
            ) );
        }
        
    } // End class


    /**
     * Initializes the main plugin
     *
     * @return \ATDListingCompare class
     */
    function ATDListingCompare()
    {
        return ATDListingCompare::instance();
    }


    /**
     * Handle plugin activation
     *
     * @return void
     */
    function atd_listing_compare_plugin_activate()
    {
        // Get the Directorist plugin is active or deactive
        if (in_array('directorist/directorist-base.php', (array)get_option('active_plugins'))) {

            // Get Directorist - Compare Listings plugin activation time
            $installed = get_option('atd_listing_compare_installed');
            if (!$installed) {
                update_option('atd_listing_compare_installed', time());
            }
            // Store current version of this plugin.
            update_option('atd_listing_compare_version', ATDLC_PLUGIN_VERSION);
        }

        // This for auto create page when the plugin are activae
        Activate::atdlc_compare_page_auto_create();
    }
    register_activation_hook(__FILE__, 'atd_listing_compare_plugin_activate');



    /**
     * Handle plugin deactivation
     *
     * @return void
     */
    function atd_listing_compare_plugin_deactivate()
    {
        //flush_rewrite_rules();
    }
    register_deactivation_hook(__FILE__, 'atd_listing_compare_plugin_deactivate');

    if ( ! function_exists( 'directorist_is_plugin_active' ) ) {
        function directorist_is_plugin_active( $plugin ) {
            return in_array( $plugin, (array) get_option( 'active_plugins', array() ), true ) || directorist_is_plugin_active_for_network( $plugin );
        }
    }
    
    if ( ! function_exists( 'directorist_is_plugin_active_for_network' ) ) {
        function directorist_is_plugin_active_for_network( $plugin ) {
            if ( ! is_multisite() ) {
                return false;
            }
                    
            $plugins = get_site_option( 'active_sitewide_plugins' );
            if ( isset( $plugins[ $plugin ] ) ) {
                    return true;
            }
    
            return false;
        }
    }


    /**
     * If the Directorist plugin is activate then Directorist - Compare Listings plugin is run otherwise don't run.
     */
    if ( directorist_is_plugin_active( 'directorist/directorist-base.php' ) ) {
        /**
         * If called this method then Directorist - Compare Listings plugin is run otherwise don't run
         */
        ATDListingCompare(); // get the plugin running
    }
}
