/**
 * @package  Directorist - Compare Listing
 */

(function($){
    $(document).ready(function () {

        // Load Selected Listings Sidebar
        loadSelectedListings_sidebar();

        // Load Selected Listings Sidebar
        function loadSelectedListings_sidebar() {

            if ( ! $( '.directorist-compare-btn' ).length ) {
                return;
            }

            $.ajax({
                url: atdlc_frontend_ajax_object.ajaxurl,
                type: "POST",
                data: {
                    action: 'get_the_selected_listings_sidebar',
                },
                success: function ( response ) {

                    if ( ! response.content ) {
                        return;
                    }

                    $( document.body ).append( response.content );
                },
                error: function ( error ) {
                    console.log( { error } );
                }
            });
        }

        /**
         * On click compare button Add or remove the listing
         */
        $( "body" ).on( "click", ".directorist-compare-btn", function (e) {
            e.preventDefault();
            var listingId = $( this ).attr( 'id' );

            // Add to compare
            add_to_compare( listingId );
        });

        $(".directorist-compare-listing-table td").each(function() {
            if(isEmpty($(this))){
                $(this).html('<div class="directorist-compare-listing-table-unchecked"><i class="la la-times"></i></div>');
            }
        });
        function isEmpty( el ){
            return !$.trim(el.html())
        }

        /**
         * Selected listing add to compare if don't exists in selected listings array,
         * if exists then remove from compare
         *
         * @param listingId Silected listing ID
         */
        function add_to_compare( listingId ){
            $.ajax({
                url: atdlc_frontend_ajax_object.ajaxurl,
                type: "POST",
                data: {
                    action: 'selected_listing',
                    listing_id: listingId,
                },
                success: function ( result ) {
                    var result = JSON.parse( result );

                    const listing_id = result['listing_id'];
                    const tooltip    = $( ".directorist-tooltip_" + listing_id );
                    const compareBtn = $( "#atdlc_single-compare-btn_" + listing_id );

                    if( 'add' == result['is_listing_add_or_remove'] ){
                        // Display select window
                        $( document.body ).append( result['frame'] );

                        // Display selected listings in select window
                        $( 'div#directorist-compare-listing-items__wrapper' ).append( result['selected_listing'] );

                        // Show current total selected listings
                        $( 'div#directorist-compare-listing-count' ).text( result['current_items'] );

                        // Change tooltip text
                        $( "a.directorist-tooltip_" + listing_id ).attr( "aria-label", result['tooltip_text'] );

                        // Add selected mark class
                        tooltip.addClass( 'directorist-compare-added' );
                        compareBtn.addClass( 'atdlc_single-listing-selected-listing-btn' );
                    } else {
                        // Remove selected mark class
                        tooltip.removeClass( 'directorist-compare-added' );
                        compareBtn.removeClass( 'atdlc_single-listing-selected-listing-btn' );

                        // Remove Sidebar Listing Item
                        const sidebarListingItem = $( '#directorist-compare-listing-single' + listing_id );

                        if ( sidebarListingItem.length ) {
                            sidebarListingItem.remove();
                        }

                        // Show current total selected listings
                        $( 'div#directorist-compare-listing-count' ).text( result['current_items'] );
                    }

                    // Change tooltip text
                    $( "a.directorist-tooltip_" + listing_id ).attr( "data-label", result['tooltip_text'] );

                    // Select limit aleart window
                    $( document.body ).append( result['limit_alert_message'] );

                    // Hide select limit aleart window
                    $( 'div#atdlc_limit-aleart-message' ).delay( 5000 ).fadeOut();

                    // Remove Sidebar if no listing is selected
                    if ( result['current_items'] === 0 ) {
                        $( '.directorist-compare-listing-wrapper' ).remove();
                    }
                }
            });
        }



        /**
         * Listing remove form compare
         */
        $( "body" ).on( "click", "#directorist-compare-listing-single__action__btn", function (e) {
            e.preventDefault();
            var listingId = $(this).attr("remove_btn_id");

            // Remove listing from compare
            remove_from_compare(  listingId );
        });


        /**
         * Selected listing remover function
         *
         * @param listingId Selected listing ID
         */
        function remove_from_compare( listingId ){
            $.ajax({
                url: atdlc_frontend_ajax_object.ajaxurl,
                type: "POST",
                data: {
                    action: 'remove_listing_from_compare',
                    listing_id: listingId
                },
                success: function (result) {
                    var result = JSON.parse(result);

                    // Show current total listings selected
                    $( 'div#directorist-compare-listing-count' ).text( result['current_items'] );

                    // If selected listing is only one then rander this statement
                    if( 1 > result['current_items'] ){
                        // Remove compare table
                        $( "div#directorist-compare-listing-table-wrapper" ).remove();

                        // Remove select window
                        $( "div#directorist-compare-listing-wrapper" ).remove();

                        // Remove selected mark class
                        $( ".directorist-tooltip_" + listingId ).removeClass( 'directorist-compare-added' );
                        $( "#atdlc_single-compare-btn_" + listingId ).removeClass( 'atdlc_single-listing-selected-listing-btn' );

                        // Change tooltip text
                        $( "a.directorist-tooltip_" + listingId ).attr( "data-label", result['tooltip_text'] );
                    }

                    // // If selected listings is more then one then rander this statement
                    if ( 1 <= result['current_items'] ) {
                        // Listing remove form compare
                        $( "[id^='directorist-compare-listing-th_"+ listingId +"']" ).remove();

                        // Listing remove from select window
                        $( "div#directorist-compare-listing-single" + listingId ).remove();

                        // Remove selected mark class
                        $( ".directorist-tooltip_" + listingId).removeClass( 'directorist-compare-added' );
                        $( "#atdlc_single-compare-btn_" + listingId ).removeClass( 'atdlc_single-listing-selected-listing-btn' );

                        // Change tooltip text
                        $( "a.directorist-tooltip_" + listingId ).attr( "data-label", result['tooltip_text'] );
                    }
                }
            });
        }



        /**
         * Display select window after reload
         */
        $.ajax({
            url: atdlc_frontend_ajax_object.ajaxurl,
            type: "POST",
            data: {
                action: 'display_select_window'
            },
            success: function (result) {
                //var result = JSON.parse(result);

                // Show current total listings selected
                $( 'div#directorist-compare-listing-count' ).text( result['current_items'] );

                // If selected listing is only one then rander this statement
                if( 1 > result['current_items'] ){
                    // Remove compare table
                    $( "div#directorist-compare-listing-table-wrapper" ).remove();

                    // Remove select window
                    $( "div#directorist-compare-listing-wrapper" ).remove();

                    // Remove selected mark class
                    $( ".directorist-tooltip_" + listingId ).removeClass( 'directorist-compare-added' );
                    $( "#atdlc_single-compare-btn_" + listingId ).removeClass( 'atdlc_single-listing-selected-listing-btn' );

                    // Change tooltip text
                    $( "a.directorist-tooltip_" + listingId ).attr( "data-label", result['tooltip_text'] );

                    // Empty selected listings alert message by ajax
                    $( "#empty_listings_message" ).text( result['empty_listings_message'] );
                }

                // // If selected listings is more then one then rander this statement
                if ( 1 <= result['current_items'] ) {
                    // Listing remove form compare
                    $( "[id^='directorist-compare-listing-th_"+ listingId +"']" ).remove();

                    // Listing remove from select window
                    $( "div#directorist-compare-listing-single" + listingId ).remove();

                    // Remove selected mark class
                    $( ".directorist-tooltip_" + listingId).removeClass( 'directorist-compare-added' );
                    $( "#atdlc_single-compare-btn_" + listingId ).removeClass( 'atdlc_single-listing-selected-listing-btn' );

                    // Change tooltip text
                    $( "a.directorist-tooltip_" + listingId ).attr( "data-label", result['tooltip_text'] );
                }
            }
        });



        /**
         * Collapse out or show select window
         */
        $( "body" ).on( "click", "#directorist-compare-listing-collapse-out", function (e) {
            e.preventDefault();

            $( "#directorist-compare-listing-wrapper" ).animate({ right: '-17px' });
            // Add ID attr
            $( "div.directorist-compare-listing-collapse-btn" ).attr( "id", "atdlc_collapse-in" );
        });



        /**
         * Collapse in or hide select window
         */
        $( "body" ).on( "click", "#atdlc_collapse-in", function (e) {
            e.preventDefault();

            $( "#directorist-compare-listing-wrapper" ).animate({ right: '-320px' });
            // Add ID attr
            $( "div.directorist-compare-listing-collapse-btn" ).attr( "id", "directorist-compare-listing-collapse-out" );
        });

        /* tooltip fix */
        setTimeout(function() {
            if($(".slick-list").length){
                $(".atdlc_tooltiptext").parents(".slick-list").addClass("atbdp_tooltip-fix");
            }
        }, 500);


    }); // End document ready function
})(jQuery);