<?php
/**
 * @package  Directorist - Compare Listing
 */

if( ! class_exists( 'ShortcodeListingCompare' ) ){
    /**
     * Listing compare shortcode handler class
     */
    class ShortcodeListingCompare
    {
        /**
        * Class constructor
        * Call all hooks which we wanna triger
        */ 
        public function register()
        {
            // Listing compare table shortcode
            add_shortcode( 'directorist_listing_compare', array( $this, 'directorist_listing_compare_shortcode' ) );

            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'remove_directorist_listing_compare_shortcode' ) );
        }


        /**
         * Create shortcode output
         * 
         * @param shortcode content
         * @return shortcode content
         */
        public function directorist_listing_compare_shortcode( $attr, $content )
        {
            ob_start();
           
            // Get selected listings ID from cookies
            $atd_lg_select_limit = get_directorist_option( 'atd_lg_select_limit', 5);
            $listing_ids    = isset( $_COOKIE[ATDLC_COOKIES_NAME] ) ? $_COOKIE[ATDLC_COOKIES_NAME] : '';
            $listings       = explode( ',', $listing_ids);

            $args = array(
                'post_type'     => 'at_biz_dir',
                'post_status'   => 'publish',
                'post__in'      => $listings,
                'posts_per_page' => $atd_lg_select_limit
            );
            $query = new WP_Query( $args );            

            // Authenticate, is selected listings or not
            if( !empty( $listing_ids ) ){
                // Require compare table
                require_once( ATDLC_PLUGIN_TEMPLATES_DIR."compare-page.php" );
            }else{
                // If don't select listings to compare, alert message
                $empty_listings_message = __( 'No result found.', 'directorist-compare-listing' );
                echo "<div>$empty_listings_message</div>";            
            }            

            // Don't select listings to compare, alert message by ajax
            echo "<div id='empty_listings_message'></div>";

            $content = ob_get_contents();
            ob_get_clean();
            
            return $content;
        }


        /**
         * Compare table shortcode remover function
         */
        public function remove_directorist_listing_compare_shortcode()
        {
            // Get Listing compare enable option
            $is_cl_enable = get_directorist_option( 'atd_lg_compare_is_enable', 1 );

            // Authenticate, is Compare Listings option enable or not
            if( 1 !== ( int )$is_cl_enable ){
                remove_shortcode( 'directorist_listing_compare' );
            }
        }

    }// End class
}