<?php
/**
 * @package  Directorist - Compare Listing
 */

if( ! class_exists( 'HelperFunctions' ) ){
    /**
     * All helper functions handler class
     */
    class HelperFunctions
    {
        /**
         * Get all selected listings ID
         * 
         * @return array
         */
        public static function get_selected_ids()
        {
            // Get selected listings ID from cookies like a string 
            $string_of_ids = isset( $_COOKIE[ATDLC_COOKIES_NAME] ) ? $_COOKIE[ATDLC_COOKIES_NAME] : '';
            // Make array of IDs from a string 
            $array_of_ids = explode( ',', $string_of_ids );

            $ids = array();
            foreach( $array_of_ids as $id ){
                if( !empty( $id ) ){
                    array_push( $ids, $id );
                }                
            }

            return $ids;
        }


        
        /**
         * Get all the pages in an array where each page is an array of key:value:id and key:label:name
         *
         * Example : array(
         *              array('value'=> 1, 'label'=> 'page_name'),
         *              array('value'=> 50, 'label'=> 'page_name'),
         *          )
         * @return array page names with key value pairs in a multi-dimensional array
         */
        public static function get_pages_vl_arrays()
        {
            $pages          = get_pages();
            $pages_options  = array();

            if ( $pages ) {
                foreach( $pages as $page ) {
                    $pages_options[] = array(
                        'value' => $page->ID,
                        'label' => $page->post_title
                    );
                }
            }

            return $pages_options;
        }



        /**
         * It retrieves an option from the database if it exists and returns false if it is not exist.
         * It is a custom function to get the data of custom setting page
         * @param string $name The name of the option we would like to get. Eg. map_api_key
         * @param string $group The name of the group where the option is saved. eg. general_settings
         * @param mixed $default Default value for the option key if the option does not have value then default *      will be returned
         * @return mixed    It returns the value of the $name option if it exists in the option $group in the *      database, false otherwise.
         */
        public static function atbdp_get_option( $name, $group, $default = false )
        {
            // at first get the group of options from the database.
            // then check if the data exists in the array and if it exists then return it
            // if not, then return false
            if( empty( $name ) || empty( $group ) ){
                if( !empty( $default ) ){
                    return $default;
                }

                return false;
            } // vail if either $name or option $group is empty

            $options_array = ( array )get_option( $group );

            if( array_key_exists( $name, $options_array ) ) {
                return $options_array[$name];
            }else{
                if( ! empty( $default ) ){
                    return $default;
                }

                return false;
            }
        }


    }// End class

}