<?php
/**
 * @package  Directorist - Compare Listing
 */

if (!class_exists('ExtensionSettings')) {
    /**
     * Plugin Settings handler class
     */
    class ExtensionSettings
    {
        /**
         * Class constructor
         * Call all hooks which we wanna triger
         */
        public function register()
        {
            // settings 
            add_filter( 'atbdp_listing_type_settings_field_list', array( $this, 'atbdp_listing_type_settings_field_list' ) );
            add_filter( 'atbdp_extension_fields', array( $this, 'atbdp_extension_fields' ) );
            add_filter( 'atbdp_extension_settings_submenu', array( $this, 'atbdp_extension_settings_submenus' ) );

            // Compare Listings plugin's compare page shortcode holder page select on directorist 'Pages, Links & Views' menu
            add_filter('atbdp_pages_settings_fields', array($this, 'add_to_directorist_pages_settings_menu'));

            add_filter('atbdp_license_settings_controls', array($this, 'compare_listings_license_settings_controls'));

            // Settings hook remover
            add_action('plugins_loaded', array($this, 'remove_listing_compare_settings_hook'));
        }

        
        public function atbdp_extension_fields(  $fields ) {
            $fields[] = ['atd_lg_compare_is_enable'];
            return $fields;
        }
    
        public function atbdp_listing_type_settings_field_list( $compare_fields ) {
            $compare_fields['atd_lg_compare_is_enable'] = [
                'label'             => __('Enable Compare Listings', 'directorist-compare-listing'),
                'type'              => 'toggle',
                'value'             => true,
            ];
            $compare_fields['atdlc_select_window_title'] = [
                'type'              => 'text',
                'label'             => __('Title', 'directorist-compare-listing'),
                'value'             => __('Compare Listings', 'directorist-compare-listing'),
            ];
            $compare_fields['atd_lg_select_limit'] = [
                'type'              => 'text',
                'label'             => __('Limit', 'directorist-compare-listing'),
                'value'             => 5,
            ];
            $compare_fields['atdlc_lc_btn_display_on'] = [
                'label'     => __('Display Compare Button', 'directorist-compare-listing'),
                'type'      => 'checkbox',
                'value'     => [
                    'atdlc_all_listings',
                    'atdlc_single_listing',
                    'atdlc_author_profile',
                    'atdlc_user_dashboard',
                    'atdlc_related_post'
                ],
                'options'   => [
                    [
                        'value' => 'atdlc_all_listings',
                        'label' => __('All Listings', 'directorist-compare-listing')
                    ], 
                    [
                        'value' => 'atdlc_single_listing',
                        'label' => __('Single Listing', 'directorist-compare-listing')
                    ],
                    [
                        'value' => 'atdlc_author_profile',
                        'label' => __('Author Profile', 'directorist-compare-listing')
                    ],
                    [
                        'value' => 'atdlc_user_dashboard',
                        'label' => __('User Dashboard', 'directorist-compare-listing')
                    ],
                    [
                        'value' => 'atdlc_related_post',
                        'label' => __('Related Post', 'directorist-compare-listing')
                    ]
                ],
            ];
            $compare_fields['compare_listings_page'] = [
                'label'             => __('Compare Listings Page', 'directorist-compare-listing'),
                'type'              => 'select',
                'description'   => sprintf(__('Following shortcode must be in the selected page %s',  'directorist-compare-listing'), '<strong style="color: #ff4500;">[directorist_listing_compare]</strong>'),
                'value'             => atbdp_get_option('compare_listings_page', 'atbdp_general'),
                'showDefaultOption' => true,
                'options'           => $this->get_pages_vl_arrays(),
            ];
    
            
            return $compare_fields;
        }
    
        public function atbdp_extension_settings_submenus( $submenu ) {
            $submenu['atd_lg_compare_submenu'] = [
                'label'       => __('Compare Listings', 'directorist-compare-listing'),
                'icon'        => '<i class="fa fa-exchange-alt"></i>',
                'sections'    => apply_filters( 'atbdp_compare_settings_controls', [
                'general_section' => [
                        'title'       => __('Compare Listings Settings', 'directorist-compare-listing'),
                        'description' => __('You can Customize all the settings of Compare Listings extension here',
                        'directorist-compare-listing'
                        ),
                        'fields'      =>  [ 
                        'atdlc_select_window_title', 'atd_lg_select_limit', 'atdlc_lc_btn_display_on', ''
                        ],
                            ],
                        ] ),
            ];
    
            return $submenu;
        }

        /**
         * @since 1.0
         */
        public function compare_listings_license_settings_controls($default)
        {
            $status = get_option('directorist_compare_listings_license_status');
            if (!empty($status) && (false !== $status && 'valid' == $status)) {
                $action = array(
                    'type'       => 'toggle',
                    'name'       => 'compare_listings_deactivated',
                    'label'      => __('Action', 'directorist-compare-listing'),
                    'validation' => 'numeric',
                );
            } else {
                $action = array(
                    'type'       => 'toggle',
                    'name'       => 'compare_listings_activated',
                    'label'      => __('Action', 'directorist-compare-listing'),
                    'validation' => 'numeric',
                );
            }
            $new = apply_filters('atbdp_compare_listings_license_controls', array(
                'type'        => 'section',
                'title'       => __('Compare Listings', 'directorist-compare-listing'),
                'description' => __('You can active your Compare Listings extension here.', 'directorist-compare-listing'),
                'fields'      => apply_filters('atbdp_compare_listings_license_settings_field', array(
                    array(
                        'type'        => 'textbox',
                        'name'        => 'compare_listings_license',
                        'label'       => __('License', 'directorist-compare-listing'),
                        'description' => __('Enter your Compare Listings extension license', 'directorist-compare-listing'),
                        'default'     => '',
                    ),
                    $action,
                )),
            ));
            $settings = apply_filters('atbdp_licence_menu_for_rank_featured', true);
            if ($settings) {
                array_push($default, $new);
            }

            return $default;
        }

        /**
         * Add compare page select setting field
         * 
         * @return array
         */
        public function add_to_directorist_pages_settings_menu( $settings_fields )
        {
            $settings_fields[] = ['compare_listings_page'];
            
            return $settings_fields;
        }


        /**
         * Settings hook remover function
         */
        public function remove_listing_compare_settings_hook()
        {
            // Get Listing compare enable option
            $is_cl_enable = get_directorist_option('atd_lg_compare_is_enable', 1);

            // Authenticate, is Compare Listings option enable or not
            if (1 !== (int)$is_cl_enable) {
                remove_filter('atbdp_extension_settings_submenus', array($this, 'add_listing_compare_plugin_settings_submenu'));

                remove_filter('atbdp_pages_settings_fields', array($this, 'add_to_directorist_pages_settings_menu'));
            }
        }

        function get_pages_vl_arrays()
        {
            $pages = get_pages();
            $pages_options = array();
            if ($pages) {
                foreach ($pages as $page) {
                    $pages_options[] = array('value' => $page->ID, 'label' => $page->post_title);
                }
            }

            return $pages_options;
        }
    } // End class
}
