<?php
/**
 * @package  Directorist - Compare Listing
 */

if( ! class_exists( 'CompareButton' ) ){
    /**
    * Compare button handler class
    */
    class CompareButton
    {
        /**
         * Class constructor
         * Call all hooks which we wanna triger
         */
        public function register()
        {
            // Compare button on grid viewer hook
            add_action( 'atbdp_listing_thumbnail_area', array( $this, 'display_compare_btn_on_grid_listings' ), 10 );

            // Compare button on list viewer hook
            add_action( 'directorist_list_view_top_content_end', array( $this, 'display_compare_btn_on_list_listings' ), 10 );

            // Compare button on single listings viewer hook
            add_action( 'atbdp_single_listing_before_favourite_icon', array( $this,
            'display_compare_btn_on_single_listings' ) );

             // Compare button on user dashboard viewer hook
             add_action( 'atbdp_user_dashboard_listings_before_expiration', array( $this, 'display_compare_btn_on_user_dashboard' ) );


            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'remove_compare_button_from_listings' ) );
        }




        /**
        * Compare button display in all listings on grid view
        */
        public function display_compare_btn_on_grid_listings()
        {
            // By default compare button show on these pages
            $default_btn_on_pages = array(
                'atdlc_all_listings',
                'atdlc_single_listing',
                'atdlc_author_profile',
                'atdlc_user_dashboard',
                'atdlc_related_post'
            );
            // Get permission whice page compare button can be show
            $btn_on_pages   = get_directorist_option( 'atdlc_lc_btn_display_on' );
            $btn_on_pages   = !empty( $btn_on_pages ) ? $btn_on_pages : $default_btn_on_pages;
            $btn_on_pages   = ! is_array( $btn_on_pages ) ? array( $btn_on_pages ) : $btn_on_pages;
            $page_id = get_queried_object_id();
            $author_page = get_directorist_option('author_profile_page');
            $all_listing_page = get_directorist_option('all_listing_page');
            if( ( $page_id == $all_listing_page ) && ( !in_array( 'atdlc_all_listings', $btn_on_pages ) ) ){
                return;
            }
            if( ( $page_id == $author_page ) && ( !in_array( 'atdlc_author_profile', $btn_on_pages ) ) ){
                return;
            }
            if( is_singular(ATBDP_POST_TYPE) && ( !in_array( 'atdlc_related_post', $btn_on_pages ) ) ){
                return;
            }

            // Get listing ID
            $listingId          = get_the_ID();
            $tool_tip_text      = __( 'Add to compare', 'directorist-compare-listing' );

            // Get selected listings ID
            $listings           = HelperFunctions::get_selected_ids();

            if( in_array( $listingId, $listings ) ){
                $select_mark    = 'directorist-compare-added';
                $tool_tip_text  = __( 'Remove from compare', 'directorist-compare-listing' );
            }
            $select_mark        = !empty( $select_mark ) ? $select_mark : '';

            $compare_button ="
            <a href='#' class='directorist-compare-btn directorist-info-item directorist-info-item directorist-tooltip directorist-tooltip_$listingId $select_mark' id='$listingId' data-label='$tool_tip_text'>
            " . directorist_icon( 'las la-exchange-alt', false, 'atdlc-compare-icon' ) . "
            </a>
            ";

            echo $compare_button;
        }



        /**
        * Compare button display in all listing page on list view
        */
        public function display_compare_btn_on_list_listings()
        {
            // Get listing ID
            $listingId          = get_the_ID();
            $tool_tip_text      = __( 'Add to compare', 'directorist-compare-listing' );

            // Get selected listings ID
            $listings           = HelperFunctions::get_selected_ids();

            if( in_array( $listingId, $listings ) ){
                $select_mark    = 'directorist-compare-added';
                $tool_tip_text  = __( 'Remove from compare', 'directorist-compare-listing' );
            }

            $select_mark        = !empty( $select_mark ) ? $select_mark : '';

            $compare_button = "
            <a href='#' class='directorist-compare-btn directorist-info-item directorist-tooltip directorist-tooltip_$listingId $select_mark' id='$listingId' data-label='$tool_tip_text'>
            " . directorist_icon( 'las la-exchange-alt', false, 'atdlc-compare-icon' ) . "
            </a>
            ";

            echo $compare_button;
        }



        /**
        * Compare button display on single listing page
        */
        public function display_compare_btn_on_single_listings()
        {
            // Get listing ID
            $listingId          = get_the_ID();
            $tool_tip_text      = __( 'Add to compare', 'directorist-compare-listing' );

            // Get selected listings ID
            $listings           = HelperFunctions::get_selected_ids();

            if( in_array( $listingId, $listings ) ){
                $select_mark    = 'atdlc_single-listing-selected-listing-btn';
                $tool_tip_text  = __( 'Remove from compare', 'directorist-compare-listing' );
            }

            $select_mark        = !empty( $select_mark ) ? $select_mark : '';

            $compare_button = "
            <a href='#' class='directorist-compare-btn directorist-tooltip directorist-tooltip_$listingId $select_mark' id='$listingId' data-label='$tool_tip_text'>
            " . directorist_icon( 'las la-exchange-alt', false, 'atdlc-compare-icon' ) . "
            </a>
            ";

            echo  $compare_button;
        }



        /**
        * Compare button on user dashboard
        *
        * @param post
        * @return void
        */
        public function display_compare_btn_on_user_dashboard( $listingId )
        {
            $tool_tip_text      = __( 'Add to compare', 'directorist-compare-listing' );

            // Get selected listings ID
            $listings           = HelperFunctions::get_selected_ids();

            if( in_array( $listingId, $listings ) ){
                $select_mark    = 'directorist-compare-added';
                $tool_tip_text  = __( 'Remove from compare', 'directorist-compare-listing' );
            }

            $select_mark        = !empty( $select_mark ) ? $select_mark : '';

            $compare_button = "
            <a href='#' class='directorist-compare-btn directorist-tooltip directorist-tooltip_$listingId $select_mark' id='$listingId' data-label='$tool_tip_text'>
            " . directorist_icon( 'las la-exchange-alt', false, 'atdlc-compare-icon' ) . "
            </a>
            ";

            echo $compare_button;
        }


        /**
         * Compare button remover function from listings
         */
        public function remove_compare_button_from_listings()
        {
            // By default compare button show on these pages
            $default_btn_on_pages = array(
                'atdlc_all_listings',
                'atdlc_single_listing',
                'atdlc_author_profile',
                'atdlc_user_dashboard',
                'atdlc_related_post'
            );

            // Get option value from extension settings
            $enable_lc_optn = get_directorist_option( 'atd_lg_compare_is_enable', 1 );
            // Get permission whice page compare button can be show
            $btn_on_pages   = get_directorist_option( 'atdlc_lc_btn_display_on' );
            $btn_on_pages   = !empty( $btn_on_pages ) ? $btn_on_pages : $default_btn_on_pages;
            $btn_on_pages   = ! is_array( $btn_on_pages ) ? array( $btn_on_pages ) : $btn_on_pages;

            // Compare button remover from all listing page
            if( ( 1 !== ( int )$enable_lc_optn ) || ( !in_array( 'atdlc_all_listings', $btn_on_pages ) ) ){
                // Compare button remover from list view
                remove_action( 'directorist_list_view_top_content_end', array( $this, 'display_compare_btn_on_list_listings' ) );
            }

            // Compare button remover from single listing page
            if( ( 1 !== ( int )$enable_lc_optn ) || ( !in_array( 'atdlc_single_listing', $btn_on_pages ) ) ){
                remove_action( 'atbdp_single_listing_before_favourite_icon', array( $this, 'display_compare_btn_on_single_listings' ) );
            }

            // Compare button remover from user dashboard page
            if( ( 1 !== ( int )$enable_lc_optn ) || ( !in_array( 'atdlc_user_dashboard', $btn_on_pages ) ) ){
               remove_action( 'atbdp_user_dashboard_before_expiration', array( $this, 'display_compare_btn_on_user_dashboard' ) );
           }

        }

    }// End class
}