<?php
/**
 * Custom field file upload field template.
 * @package DirectoristDigitalMarketplace
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use \Directorist\Helper;

if ( ! defined( 'ABSPATH' ) ) {
	die();
}
?>
<div class="ddm-template single-tiers-template">
	<span class="ddm-template__title"><?php _e( 'Tiers', 'directorist-digital-marketplace' ); ?></span>
	<?php 
	if( ! empty( $args['fields_data']['tiers'] ) ) {
		foreach( $args['fields_data']['tiers'] as $tier ) {
			$title = ! empty( $tier['title'] ) ? esc_html( $tier['title'] ) : '';
			$price = ! empty( $tier['price'] ) ? esc_html( $tier['price'] ) : '';
			$description = ! empty( $tier['description'] ) ? esc_html( $tier['description'] ) : '';
			$id = preg_replace( "/[\s_]/", "-", $title );
			?>
			<div class="ddm-template-input">
				<div class="input-part">
					<input type="radio" value="<?php echo esc_attr( $price ); ?>" name="tiers" id="<?php echo esc_html( strtolower( $id ) ); ?>">
				</div>
				<div class="label-part">
					<label for="<?php echo esc_html( strtolower( $id ) ); ?>">
						<?php echo esc_html( $title); ?>
						<span class="directorist-listing-price"><?php echo Helper::formatted_price( $price ); ?></span>
					</label>
					<p><?php echo esc_html( $description ); ?></p>
				</div>	
			</div>
	<?php } 
	}?>
</div>
