<?php
/**
 * Custom field file upload field template.
 * @package DirectoristDigitalMarketplace
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use \Directorist\Helper;

if ( ! defined( 'ABSPATH' ) ) {
	die();
}
?>
<div class="ddm_listing-pricing-total">
	<?php 
	$price = ! empty( $args['fields_data']['tiers'] ) ? $args['fields_data']['tiers'][0]['price'] : $args['fields_data']['price'];
	if( ! empty( $price ) ) { 
		echo atbdp_display_price( $price );
		?>
		<input type="hidden" checked value="<?php echo esc_attr( $price ); ?>">
	<?php } 

	if( ! empty( $args['fields_data']['monthly'] ) ) {
		Helper::price_template( get_the_ID() );
		?>
		<span> / <?php _e( 'mo', 'directorist-digital-marketplace' ); ?></span>
		<input type="hidden" value="<?php echo esc_attr( $price ); ?>">
	<?php } 

	elseif( ! empty( $args['fields_data']['hourly'] ) ) { 
		?>
		<span> / <?php _e( 'hr', 'directorist-digital-marketplace' ); ?></span>
		<input type="hidden" value="<?php echo esc_attr( $price ); ?>">
	<?php } ?>
</div>
