<?php
/**
 * Custom field file upload field template.
 * @package DirectoristDigitalMarketplace
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use \Directorist\Helper;

if ( ! defined( 'ABSPATH' ) ) {
	die();
}
?>
<div class="ddm-template single-extras-template">
	<span class="ddm-template__title"><?php _e( 'Extras (Optional)', 'directorist-digital-marketplace' ); ?></span>
	<?php 
		foreach( $args['fields_data']['extras'] as $extra ) { ?>
			<div class="ddm-template-input">
				<div class="input-part">
					<input type="checkbox" value="<?php echo ! empty( $extra['price'] ) ? esc_attr( $extra['price'] ) : ''; ?>" name="extras[<?php echo ! empty( $extra['title'] ) ? esc_attr( strtolower( $extra['title'] ) ) : ''; ?>]">
				</div>
				<div class="label-part">
					<label for="directorist_listing_extras1">
						<?php echo ! empty( $extra['title'] ) ? esc_html( $extra['title'] ) : ''; ?>
						<span class="directorist-listing-price"><?php echo ! empty( $extra['price'] ) ? Helper::formatted_price( $extra['price'] ) : ''; ?></span>
					</label>
				</div>	
			</div>
	<?php } ?>
</div>

