<?php
/**
 * Custom field file upload field template.
 * @package DirectoristDigitalMarketplace
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die();
}
?>
<div class="ddm-template tiers-template">
	<span class="ddm-template__title"><?php esc_html_e( 'Tiers (Optional)', 'directorist-digital-marketplace'); ?></span>
	<div class="ddm-template__items">
		<div class="ddm-template__list ddm-template__list-tiers">

		<?php 
		if( ! empty( $args['fields_data']['tiers'] ) ) {
			foreach( $args['fields_data']['tiers'] as $index => $tire ) { 
				?>
					<div class="ddm-template__wrapper ddm-template__wrapper-tiers" id='ddm-template__wrapper-tiers-<?php echo esc_attr( $index ); ?>' data-index="<?php echo esc_attr( $index ); ?>" draggable="true">
						<div class="ddm-template__single-wrapper ddm-template__single-wrapper-tiers">
							<div class="ddm-template__drag">
								<a href="#" class="ddm-template__drag-btn"><?php directorist_icon( 'las la-arrows-alt' ); ?></a>
							</div>
							<div class="ddm-template__input ddm-template__input-tiers-title">
								<input value="<?php echo ! empty( $tire['title'] ) ? esc_attr( $tire['title'] ) : ''; ?>" type="text" placeholder="<?php esc_html_e( 'Title', 'directorist-digital-marketplace'); ?>" id="ddm-tiers-title-<?php echo esc_attr( $index ); ?>" name="price_tiers[<?php echo esc_attr( $index ); ?>][title]" >
							</div>
							<div class="ddm-template__input ddm-template__input-tiers-price">
								<input value="<?php echo ! empty( $tire['price'] ) ? esc_attr( $tire['price'] ) : ''; ?>" type="number" placeholder="<?php esc_html_e( 'Price', 'directorist-digital-marketplace'); ?>" id="ddm-tiers-price-<?php echo esc_attr( $index ); ?>" name="price_tiers[<?php echo esc_attr( $index ); ?>][price]">
							</div>
							<div class="ddm-template__input ddm-template__input-tiers-description">
								<input type="text" value="<?php echo ! empty( $tire['description'] ) ? esc_attr( $tire['description'] ) : ''; ?>" placeholder="<?php esc_html_e( 'Description', 'directorist-digital-marketplace'); ?>" id="ddm-tiers-description-<?php echo esc_attr( $index ); ?>" name="price_tiers[<?php echo esc_attr( $index ); ?>][description]" >
							</div>
							<div class="ddm-template__remove ddm-template__remove-tiers">
								<a href="#" class="ddm-template__remove-btn ddm-template__remove-btn-tiers"><?php directorist_icon( 'las la-trash' ); ?></a>
							</div>
						</div>				 
					</div> 

				<?php
			}
		}
		?>
		</div>
		<a href="#" class="ddm-template__add-btn ddm-template__add-btn-tiers"><?php echo directorist_icon( 'las la-plus' ); ?><?php esc_html_e( 'Add New', 'directorist-digital-marketplace'); ?></a>
	</div>

</div>
