<?php
/**
 * Custom field file upload field template.
 * @package DirectoristDigitalMarketplace
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die();
}
?>

<div class="ddm-template extras-template">
	<span class="ddm-template__title"><?php esc_html_e( 'Extras (Optional)', 'directorist-digital-marketplace'); ?></span>
	<div class="ddm-template__items">
		<div class="ddm-template__list ddm-template__list-extras">
		<?php 
		if( ! empty( $args['fields_data']['extras'] ) ) {
			foreach( $args['fields_data']['extras'] as $index => $extra ) { 
		?>
			<div class="ddm-template__wrapper ddm-template__wrapper-extras" id='ddm-template__wrapper-extras-<?php echo esc_attr( $index ); ?>' data-index="<?php echo esc_attr( $index ); ?>" draggable="true">
				<div class="ddm-template__single-wrapper ddm-template__single-wrapper-extras">
					<div class="ddm-template__drag">
						<a href="#" class="ddm-template__drag-btn"><?php echo directorist_icon( 'las la-arrows-alt' ); ?></a>
					</div>
					<div class="ddm-template__input ddm-template__input-extras-title">
						<input value="<?php echo esc_attr( $extra['title'] ); ?>" type="text" placeholder="<?php esc_html_e( 'Title', 'directorist-digital-marketplace'); ?>" id="ddm-extras-title-<?php echo esc_attr( $index ); ?>" name="price_extras[<?php echo esc_attr( $index ); ?>][title]" >
					</div>
					<div class="ddm-template__input ddm-template__input-extras-price">
						<input value="<?php echo esc_attr( $extra['price'] ); ?>" type="number" placeholder="<?php esc_html_e( 'Price', 'directorist-digital-marketplace'); ?>" id="ddm-extras-price-<?php echo esc_attr( $index ); ?>" name="price_extras[<?php echo esc_attr( $index ); ?>][price]" >
					</div>
					<div class="ddm-template__remove ddm-template__remove-extras">
						<a href="#" class="ddm-template__remove-btn ddm-template__remove-btn-extras"><?php echo directorist_icon( 'las la-trash' ); ?></a>
					</div>
				</div>
			</div>
		<?php
			}
		}
		?>
		</div>
		<a href="#" class="ddm-template__add-btn ddm-template__add-btn-extras"><?php echo directorist_icon( 'las la-plus' ); ?><?php esc_html_e( 'Add New', 'directorist-digital-marketplace'); ?></a>
	</div>
</div>

