	<?php 
use DirectoristDigitalMarketplace\Module\WooCommerce\WC_Helper;
do_action( 'wallet_dashboard_before_content' ); ?>

	<div class="directorist-wallet-wrap">
		<div class="directorist-row">
			<div class="directorist-col-12">
				<?php
				$html = sprintf( '<h2 class="directorist-wallet-title">%s</h2>', __( 'Wallet', 'directorist-digital-marketplace' ) );
				echo apply_filters( 'wallet_dashboard_content_area_title', $html );
				?>
				<div class="directorist-wallet-card-list">
					<div class="directorist-card directorist-card-wallet directorist-wallet-balance">
						<span class="directorist-card-wallet__amount">
						<?php
						echo wc_price( $available_payout_amount );
						?>
						</span>
						<span class="directorist-card-wallet__type"><?php _e( 'Available Balance', 'directorist-digital-marketplace' ); ?></span>
					</div>
					<div class="directorist-card directorist-card-wallet directorist-wallet-earning">
						<span class="directorist-card-wallet__amount">
						<?php
						echo ! empty( $total_sold ) ? wc_price ( $total_sold ) : 0;
						?>
						</span>
						<span class="directorist-card-wallet__type"><?php _e( 'Total Sold', 'directorist-digital-marketplace' ); ?></span>
					</div>
					<div class="directorist-card directorist-card-wallet directorist-wallet-orders">
						<span class="directorist-card-wallet__amount">
						<?php
						echo ! empty( $orders ) ? count( $orders ) : 0;
						?>
						</span>
						<span class="directorist-card-wallet__type"><?php _e( 'Total Orders', 'directorist-digital-marketplace' ); ?></span>
					</div>
				</div><!-- ends: .directorist-wallet-card-list -->

				<div class="directorist-wallet-table">
					<div class="directorist-wallet-table__top">
						<h3><?php _e( 'Earnings', 'directorist-digital-marketplace' ); ?></h3>
						<span><?php _e( 'Fee', 'directorist-digital-marketplace' ); ?>: <strong><?php echo ! empty( $commission_rate ) ? $commission_rate : 0; ?>%</strong></span>
					</div>
					<?php 
					if ( $orders ) {
						?>
					<div class="directorist-walet-table-tab-part">
						<div class="tab-content directorist-walet-table-tab-content" id="waletTabContent">
							<div class="tab-pane fade show active" id="directorist-walet-booking" role="tabpanel" aria-labelledby="directorist-walet-booking-tab">
								<div class="directorist-table-responsive">
									<table>
										<thead>
											<tr>
												<th><?php _e( 'Listing', 'directorist-digital-marketplace' ); ?></th>
												<th><?php _e( 'Order ID', 'directorist-digital-marketplace' ); ?></th>
												<th><?php _e( 'Date', 'directorist-digital-marketplace' ); ?></th>
												<th><?php _e( 'Price Sold', 'directorist-digital-marketplace' ); ?></th>
												<th><?php _e( 'My Earnings', 'directorist-digital-marketplace' ); ?></th>
												<th><?php _e( 'Status', 'directorist-digital-marketplace' ); ?></th>
											</tr>
										</thead>
										<tbody>
										<?php
											foreach ( $orders as $order_id ) {
												$order = wc_get_order( $order_id );
												$paid  = $order->get_meta( '_ddm_paid_payout' );
												$products = $order->get_items();
												$status = $order->get_status();
												$product_name = '';
												foreach( $products as $product ) {
													$product_name = $product->get_name();
												}
												?>
												<tr>
													<td><?php echo esc_html( $product_name ); ?></td>
													<td>#<?php echo esc_html( $order_id ); ?></td>
													<td><span class="directorist-wallet-table-date"><?php echo esc_html( date(get_option('date_format'), strtotime( $order->get_date_completed() ) ) ); ?></span></td>
													<td><?php echo wc_price( $order->get_total() ); ?></td>
													<td><?php echo wc_price( (int)$order->get_total() - (int)WC_Helper::commission_per_order( $order )); ?></td>
													<td><?php echo ( 'completed' !== $status ) ? esc_html__( 'Pending', 'directorist-digital-marketplace' ) : ( $paid ? esc_html__( 'Paid', 'directorist-digital-marketplace' ) : esc_html__( 'Available', 'directorist-digital-marketplace' ) ); ?></td>
												</tr>
												<?php
											}
										?>
										</tbody>
									</table>
								</div>
								<div class="directorist-wallet-table__pagination"></div>
								<!-- Pagination markup goes here -->
							</div>
						</div>
					</div>
					<?php }else{
						esc_html_e( 'No earning yet!', 'directorist-digital-marketplace' );
					} ?>
				</div><!-- ends: .directorist-wallet-table -->
			</div>
			<div class="directorist-col-lg-6">
				<div class="directorist-wallet-table directorist-wallet-table-payout-history">
					<div class="directorist-wallet-table__top">
						<h3><?php _e( 'Payout History', 'directorist-digital-marketplace' ); ?></h3>
					</div>
					<?php 
					if ( $payouts ) {
					?>
					<div class="directorist-table-responsive">
						<table>
							<thead>
								<tr>
									<th><?php _e( 'Amount', 'directorist-digital-marketplace' ); ?></th>
									<th><?php _e( 'Payout Method', 'directorist-digital-marketplace' ); ?></th>
									<th><?php _e( 'Date', 'directorist-digital-marketplace' ); ?></th>
								</tr>
							</thead>
							<tbody>
								<?php
								foreach( $payouts as $payout ){
									$amount         = get_post_meta( $payout, '_amount', true );
									$method = get_post_meta( $payout, '_method', true );
									$term = get_term_by( 'slug', $method, 'ddm_payout_method' );
									$name = ! is_wp_error( $term ) ? $term->name : '' ;
									$t           = get_the_time( 'U' );
									$date_format = get_option( 'date_format' );
									$date        = date_i18n( $date_format, $t );
									?>
								<tr>
									<td><?php echo atbdp_display_price( $amount ); ?></td>
									<td><?php echo esc_html( $name ); ?></td>
									<td><span class="directorist-wallet-table-date"><?php echo ! empty( $date ) ? esc_html( $date ) : ''; ?></span></td>
								</tr>
								<?php
								}
								?>
							</tbody>
						</table>
					</div>
					<?php }else{
						esc_html_e( 'No payout history yet!', 'directorist-digital-marketplace' );
					}?>
					<div class="directorist-wallet-table__pagination">
						<!-- Pagination markup goes here -->
					</div>
				</div><!-- ends: .directorist-wallet-table -->
			</div>
			<div class="directorist-col-lg-6">
				<div class="directorist-card directorist-wallet-payment-method">
					<div class="directorist-card__header directorist-wallet-payment-method__title">
						<h3><?php _e( 'Payout Methods', 'directorist-digital-marketplace' ); ?></h3>
					</div>
					<div class="directorist-card__body">
						<?php 
							if( ! empty( $payout_methods ) ) {
						?>
						<form id="ddm_process_payout">
							<?php
							foreach( $payout_methods as $key => $method ) { ?>
								<div class="directorist-wallet-payment-method__fields">
									<div class="directorist-form-group">
										<input type="radio" <?php echo $key === 0 ? esc_attr( 'checked' ) : ''; ?>  name="method" id="<?php echo esc_attr( $method->slug ); ?>" value="<?php echo esc_attr( $method->slug ); ?>">
										<label for="<?php echo esc_attr( $method->slug ); ?>"><?php echo esc_html( $method->name ); ?></label>
										<p class="directorist-wallet-payment-method__desc"><small><?php echo esc_attr( $method->description ); ?></small></p>
									</div>
									<div class="directorist-wallet-payment-method__fields">
										<div class="directorist-form-group payout_method_details">
											<textarea name="payment_method_details[<?php echo esc_attr( $method->slug ); ?>]" id="<?php echo esc_attr( $method->slug ); ?>" class="directorist-form-element ddm_payment_method_details"><?php echo !empty( $method_details[$method->slug] ) ? esc_attr( $method_details[$method->slug] ) : ''; ?></textarea>
										</div>
									</div>
								</div>
								<?php
							}
							?>						
							<p id="ddm_notice_board"></p>
							<button class="directorist-btn directorist-btn-md directorist-btn-primary directorist-booking-btn-save-card" id="ddm_submit_payment_method" type="submit"><?php _e( 'Save', 'directorist-digital-marketplace' ); ?></button>
						</form>
						<?php }else{
						esc_html_e( 'No method found!', 'directorist-digital-marketplace' );
					} ?>
					</div>
				</div>
			</div>
		</div>
	</div><!-- ends: .wallet-wrapper -->
	<?php do_action( 'wallet_dashboard_after_content' ); ?>
