<?php 

use DirectoristDigitalMarketplace\Module\WooCommerce\WC_Helper; ?>
	<div class="directorist-download-wrap">
		<div class="directorist-row">
			<div class="directorist-col-12">
				<?php
				$html = sprintf( '<h2 class="directorist-download-title">%s</h2>', __( 'Downloads', 'directorist-digital-marketplace' ) );
				echo apply_filters( 'download_dashboard_content_area_title', $html );
				?>
				<div class="directorist-download-card-list">
					<div class="directorist-download-card-single directorist-download-card-heading">
						<span class="directorist-download-card-single-heading">Listing Name</span>
						<span class="directorist-download-card-single-heading">Purchase Date</span>
						<span class="directorist-download-card-single-heading">Order Number</span>
						<span class="directorist-download-card-single-heading">Remaining Download</span>
						<span class="directorist-download-card-single-heading">Action</span>
					</div>
					<?php 
					foreach( $downloads as $download ) {
						$order = wc_get_order( $download['order_id'] );
						?>
						<div class="directorist-download-card-single">
							<span class="directorist-download-card-name"><?php echo esc_html( $download['product_name'] ); ?></span>
							<span class="directorist-download-card-name"><?php echo esc_html( wc_format_datetime( $order->get_date_completed() )); ?></span>
							<span class="directorist-download-card-name"><?php echo '#'. esc_html( $download['order_id'] ); ?></span>
							<span class="directorist-download-card-name"><?php echo ! empty( $download['downloads_remaining'] ) ? esc_html( $download['downloads_remaining'] ) : esc_html__( 'Unlimited', 'directorist-digital-download' ); ?></span>
							<a class="directorist-download-card-btn" href="<?php echo esc_url( $download['download_url'] ); ?>">Download</a>
						</div>
						
					<?php }
					?>
				</div>
			</div>
			
		</div>
	</div><!-- ends: .download-wrapper -->
	<?php do_action( 'download_dashboard_after_content' ); ?>
