<?php

/**
 * Helper functions.
 *
 * @package DirectoristDigitalMarketplace
 */

namespace DirectoristDigitalMarketplace\Global_Helpers;
use WP_Query;
/**
 * Prints The Public Template
 * 
 * @param string $path
 * @param array $data
 * @param bool $extract
 * 
 * @return void Prints Public Template
 */
function get_the_template( $path = '', $data = [], $extract = true ) {

    $file_path = DDM_TEMPLATE_PATH . $path;

    get_the_file_content( $file_path, $data, $extract );
}


/**
 * Get The Admin Template
 * 
 * @param string $path
 * @param array $data
 * @param bool $extract
 * 
 * @return string Admin Template
 */
function get_view( $path = '', $data = [], $extract = true ) {

    ob_start();

    get_the_view( $path, $data, $extract );

    return ob_get_clean();
}

/**
 * Prints The Admin Template
 * 
 * @param string $path
 * @param array $data
 * @param bool $extract
 * 
 * @return void Prints Admin Template
 */
function get_the_view( $path = '', $data = [], $extract = true ) {

    $file_path = DDM_VIEW_PATH . $path;

    get_the_file_content( $file_path, $data, $extract );
}

/**
 * Prints The File Content
 * 
 * @param string $path
 * @param array $data
 * @param bool $extract
 * 
 * @return void Prints the file contents
 */
function get_the_file_content( $path = '', $data = [], $extract = true ) {

    $file = $path . '.php';

    if ( ! file_exists( $file ) ) {
        return;
    }

    if ( $extract ) {
        extract( $data );
    }
    
    include $file;
}

/**
 * Include the template file
 * 
 * @param string $template_file
 * @param array $args
 * 
 * @return void 
 */
function get_template( $template_file, $args = [] ) {
    if ( is_array( $args ) ) {
        extract( $args );
    }

    $theme_template  = '/directorist-digital-marketplace/' . $template_file . '.php';
    $plugin_template = DDM_TEMPLATE_PATH . $template_file . '.php';

    if ( file_exists( get_stylesheet_directory() . $theme_template ) ) {
        $file = get_stylesheet_directory() . $theme_template;
    } elseif ( file_exists( get_template_directory() . $theme_template ) ) {
        $file = get_template_directory() . $theme_template;
    } else {
        $file = $plugin_template;
    }

    if ( file_exists( $file ) ) {
        include $file;
    }
}

/**
 * Gets first array item value.
 *
 * @since 1.0
 * @param array $array Source array.
 * @param mixed $default Default value.
 * @return mixed
 */
function ddm_get_first_array_value( $array, $default = null ) {
	$value = $default;

	if ( is_array( $array ) && $array ) {
		$value = reset( $array );
	}

	return $value;
}

function get_payouts( $user_id, $status = 'pending' ) {
    return get_posts([
        'post_type' => 'ddm_payout',
        'posts_per_page' => -1,
        'post_status' => $status,
        'author' => $user_id,
        'fields' => 'ids',
    ]);
}

function get_commission( $user_id, $status = 'pending' ) {
    return get_posts([
        'post_type' => 'ddm_commission',
        'posts_per_page' => 1,
        'post_status' => $status,
        'author' => $user_id,
        'fields' => 'ids',
    ]);
}

function add_payout( $user_id, $args = [] ) {
    $default = [
        'post_type' => 'ddm_payout',
        'post_status' => 'pending',
        'author' => $user_id,
    ];
    return wp_insert_post( array_merge( $default, $args ) );
}

function add_commission( $user_id, $args = [] ) {
    $commission = get_commission( $user_id );
    
    if( $commission ) {
        $amount_to_pay = get_post_meta( $commission[0], '_amount', true );
        $admin_earning = get_post_meta( $commission[0], '_earning', true );
        $amount_to_pay += ! empty( $args['meta_input']['_amount'] ) ? $args['meta_input']['_amount'] : 0;
        $admin_earning += ! empty( $args['meta_input']['_earning'] ) ? $args['meta_input']['_earning'] : 0;
        update_post_meta( $commission[0], '_amount', $amount_to_pay );
        update_post_meta( $commission[0], '_earning', $admin_earning );
        return $commission[0];
    }
    $default = [
        'post_type' => 'ddm_commission',
        'post_status' => 'pending',
        'author' => $user_id,
    ];
    return wp_insert_post( array_merge( $default, $args ) );
}

function get_vendor_orders( $user_id, $args = [] ) {

    $args = array_merge( [
        'post_type'   => 'shop_order',
        'post_status' => [ 'wc-completed', 'wc-on-hold'],
        'numberposts' => -1,
        'fields'      => 'ids',
        'meta_query'  => [
            [
                'key'       => 'ddm_vendor',
                'value'     => $user_id,
                'compare'   => '=',
            ],
        ],
    ], $args );

    $orders = new WP_Query( $args );
    return $orders->posts;

}